/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.scan;

import SK.gnome.morena.Morena;
import SK.gnome.morena.MorenaImage;
import SK.gnome.twain.TwainException;
import SK.gnome.twain.TwainManager;
import SK.gnome.twain.TwainSource;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.scan.IDocScan;
import in.gov.uidai.ec.icas.scan.ScannerProp;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorenaTwainScan
implements IDocScan {
    private static final Logger LOGGER = LoggerFactory.getLogger(MorenaTwainScan.class);
    private TwainSource source;
    private String[] deviceList;

    @Override
    public synchronized String[] getDeviceList() {
        try {
            TwainSource[] listSources = TwainManager.listSources();
            if (listSources.length > 0) {
                this.deviceList = new String[listSources.length];
                for (int i = 0; i < listSources.length; ++i) {
                    LOGGER.debug("Source = [" + listSources[i].toString() + "]");
                    this.deviceList[i] = listSources[i].toString();
                }
            }
        }
        catch (Exception e) {
            throw new ClientException("Failed to get device list", e);
        }
        return this.deviceList;
    }

    @Override
    public synchronized BufferedImage acquireImage() {
        if (this.isSourceUnavailable()) {
            return null;
        }
        try {
            MorenaImage image = new MorenaImage((ImageProducer)this.source);
            if (image.getHeight() == 0 && image.getWidth() == 0) {
                image = new MorenaImage((ImageProducer)this.source);
            }
            if (image.getStatus() == 4) {
                throw new ClientException("Document scan cancelled");
            }
            Image awtImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)image);
            BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            bi.createGraphics().drawImage(awtImage, 0, 0, null);
            return bi;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to acquire image", (Throwable)e);
            throw new ClientException("Unable to acquire image.", e);
        }
    }

    @Override
    public synchronized void acquireImage(String fileName) {
        if (this.isSourceUnavailable()) {
            return;
        }
        try {
            MorenaImage image = new MorenaImage((ImageProducer)this.source);
            if (image.getStatus() == 4) {
                throw new ClientException("Document scan cancelled");
            }
            Image awtImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)image);
            BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            bi.createGraphics().drawImage(awtImage, 0, 0, null);
            File tempImage = new File("tempFile.jpg");
            ImageIO.write((RenderedImage)bi, "jpg", tempImage);
            long imageSize = tempImage.length() / 1024L;
            LOGGER.debug("Image size before: " + imageSize);
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            ImageWriter writer = iter.next();
            String fname = fileName + ".jpg";
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(fname));
            writer.setOutput(ios);
            JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
            iwparam.setCompressionMode(2);
            if (imageSize > 300L) {
                iwparam.setCompressionQuality(0.1f);
            }
            writer.write(null, new IIOImage(bi, null, null), iwparam);
            ios.flush();
            writer.dispose();
            ios.close();
            LOGGER.debug("Size of acquired image is " + image.getWidth() + " x " + image.getHeight() + " x " + image.getPixelSize());
            boolean res = tempImage.delete();
            if (res) {
                LOGGER.info("Image deleted");
            } else {
                LOGGER.info("Image not deleted");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to acquire image", (Throwable)e);
            throw new ClientException("Unable to acquire image.", e);
        }
    }

    @Override
    public synchronized void setSource(String sourceName) {
        try {
            for (TwainSource element : TwainManager.listSources()) {
                if (!element.toString().equals(sourceName)) continue;
                this.source = element;
                this.setSourceProperties();
            }
        }
        catch (Exception e) {
            throw new ClientException("Error while setting source", e);
        }
    }

    @Override
    public synchronized void showUI(boolean val) {
        this.source.setVisible(val);
        try {
            this.source.setIndicators(val);
        }
        catch (TwainException e) {
            LOGGER.debug("Error while setting UI indicators visibility");
        }
    }

    @Override
    public synchronized void setProperties(ScannerProp scanProp) {
        try {
            switch (scanProp.getMode()) {
                case COLOR: {
                    this.source.setColorMode();
                    break;
                }
                case BLACK: {
                    this.source.setGrayScaleMode();
                }
            }
            this.source.setResolution((double)scanProp.getDpi());
        }
        catch (TwainException e) {
            throw new ClientException("Error setting scanner properties", e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            Morena.close();
        }
        catch (Throwable e) {
            LOGGER.debug("Error occurred while closing morena resources", e);
        }
    }

    private synchronized void setSourceProperties() {
        if (this.isSourceUnavailable()) {
            throw new ClientException("Device not connected");
        }
        try {
            this.source.maskUnsupportedCapabilityException(true);
            this.source.maskBadValueException(true);
            this.source.setVisible(false);
            this.source.setUnits(0);
            this.source.setFrame(0.0, 0.0, 8.4, 11.3);
        }
        catch (Exception e) {
            throw new ClientException("Error while setting properties", e);
        }
    }

    private synchronized boolean isSourceUnavailable() {
        boolean available;
        try {
            available = this.source.getDeviceOnLine();
        }
        catch (Exception e) {
            throw new ClientException("Error while testing device connectivity", e);
        }
        return !available;
    }
}

