/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CSVWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVWriter.class);
    private CsvListWriter writer;
    private List<String> fieldColumn;

    public void init(OutputStream output, List<String> fieldColumn) {
        OutputStreamWriter streamWriter = new OutputStreamWriter(output, StandardCharsets.UTF_8);
        this.writer = new CsvListWriter((Writer)streamWriter, CsvPreference.EXCEL_PREFERENCE);
        this.fieldColumn = fieldColumn;
    }

    public void writeHeader(String ... strings) {
        try {
            this.writer.writeHeader(strings);
        }
        catch (IOException | SuperCSVException e) {
            LOGGER.error("Error writing header", e);
        }
    }

    public void writeHeader() {
        try {
            ArrayList<String> headerEntry = new ArrayList<String>();
            for (String entry : this.fieldColumn) {
                String[] parts = entry.split("=");
                headerEntry.add(parts[0].trim());
            }
            String[] headerRecord = headerEntry.toArray(new String[headerEntry.size()]);
            this.writer.writeHeader(headerRecord);
        }
        catch (IOException | SuperCSVException e) {
            LOGGER.error("Error writing header", e);
        }
    }

    public <T> void writeAll(List<T> recordList) throws Exception {
        ArrayList<String> headerEntry = new ArrayList<String>();
        for (String entry : this.fieldColumn) {
            String[] parts = entry.split("=");
            headerEntry.add(parts[0].trim());
        }
        String[] headerRecord = headerEntry.toArray(new String[headerEntry.size()]);
        this.writeHeader(headerRecord);
        for (T record : recordList) {
            ArrayList<String> recordStrList = new ArrayList<String>();
            for (String entry : this.fieldColumn) {
                String fieldName = entry.split("=")[1].trim();
                String value = BeanUtils.getProperty(record, (String)fieldName.trim());
                recordStrList.add(value);
            }
            String[] dataRecord = recordStrList.toArray(new String[recordStrList.size()]);
            this.replaceNullWithEmptyStr(dataRecord);
            this.writer.write(dataRecord);
        }
    }

    public <T> void writeNext(T record) throws Exception {
        ArrayList<String> recordStrList = new ArrayList<String>();
        for (String headerName : this.fieldColumn) {
            String fieldName = headerName.split("=")[1].trim();
            String value = BeanUtils.getProperty(record, (String)fieldName.trim());
            recordStrList.add(value);
        }
        String[] dataRecord = recordStrList.toArray(new String[recordStrList.size()]);
        this.replaceNullWithEmptyStr(dataRecord);
        this.writer.write(dataRecord);
    }

    private void replaceNullWithEmptyStr(String[] dataRecord) {
        for (int i = 0; i < dataRecord.length; ++i) {
            String str = dataRecord[i];
            if (!StringUtils.isEmpty((String)str)) continue;
            dataRecord[i] = "";
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing CSVWriter", (Throwable)e);
        }
    }
}

