/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.text;

import in.gov.uidai.ec.icas.text.IBundleContextPreference;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.text.IResourceBundleProvider;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ResourceBundleContext
implements ApplicationContextAware,
InitializingBean,
IResourceBundleContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleContext.class);
    protected final Map<String, IResourceBundleProvider> providerMap = new HashMap<String, IResourceBundleProvider>();
    protected Locale tlitLocale;
    protected ApplicationContext appCtxt;

    public void setPreference(IBundleContextPreference pref) {
        this.tlitLocale = UidLocaleUtils.parseLocaleStr(pref.getTransliterationLocale("hi_IN"));
        Locale.setDefault(UidLocaleUtils.parseLocaleStr(pref.getApplicationLocale("en_in")));
    }

    public void setApplicationContext(ApplicationContext ctxt) throws BeansException {
        this.appCtxt = ctxt;
    }

    public void afterPropertiesSet() throws Exception {
        String[] bNames;
        for (String bName : bNames = this.appCtxt.getBeanNamesForType(IResourceBundleProvider.class)) {
            IResourceBundleProvider rbp = (IResourceBundleProvider)this.appCtxt.getBean(bName);
            this.providerMap.put(rbp.getPrefix().toLowerCase(), rbp);
        }
        LOGGER.debug("pre-loading of resource bundles complete");
    }

    @Override
    public String getLocaleMessage(Object key, Object ... arguments) {
        try {
            String message = this.getMessageImpl(key, true);
            message = MessageFormat.format(message, arguments);
            return message;
        }
        catch (Exception exep) {
            return "!" + key + "!";
        }
    }

    @Override
    public String getMessage(Object key, Object ... arguments) {
        try {
            String message = this.getMessageImpl(key, false);
            message = MessageFormat.format(message, arguments);
            return message;
        }
        catch (Exception exep) {
            return "!" + key + "!";
        }
    }

    @Override
    public Locale getLocale() {
        return this.tlitLocale;
    }

    private String getMessageImpl(Object key, boolean local) {
        String keyStr = null;
        keyStr = key instanceof String ? (String)key : key.toString();
        String[] parts = keyStr.split(":", 2);
        if (parts.length < 2) {
            Set<String> keySet = this.providerMap.keySet();
            ResourceBundle bundle = null;
            for (String keyName : keySet) {
                bundle = local ? this.providerMap.get(keyName).getBundle(this.tlitLocale) : this.providerMap.get(keyName).getDefaultBundle();
                if (!bundle.containsKey(keyStr)) continue;
                return bundle.getString(keyStr);
            }
        } else {
            String providerName = parts[0].toLowerCase();
            String propKey = parts[1];
            if (this.providerMap.containsKey(providerName)) {
                ResourceBundle bundle = null;
                bundle = local ? this.providerMap.get(providerName).getBundle(this.tlitLocale) : this.providerMap.get(providerName).getDefaultBundle();
                if (bundle.containsKey(propKey)) {
                    return bundle.getString(propKey);
                }
            }
        }
        return "!" + keyStr + "!";
    }
}

