/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.text;

import in.gov.uidai.ec.icas.text.IBundleContextPreference;
import in.gov.uidai.ec.icas.text.IResourceBundleProvider;
import in.gov.uidai.ec.icas.text.ResourceBundleClassLoader;
import in.gov.uidai.ec.icas.text.Utf8PropertyResourceBundle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ResourceBundleProvider
implements InitializingBean,
IResourceBundleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleProvider.class);
    private ResourceBundle defaultBundle;
    private Map<String, ResourceBundle> languageBundleMap = new HashMap<String, ResourceBundle>();
    private String prefix;
    private String filePath;
    private Locale tlitLocale;
    private String bundleKey;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setBundleKey(String key) {
        this.bundleKey = key;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public void setPreference(IBundleContextPreference pref) {
        this.tlitLocale = this.parseLocaleStr(pref.getTransliterationLocale("hi_IN"));
        Locale.setDefault(this.parseLocaleStr(pref.getApplicationLocale("en_in")));
    }

    @Override
    public ResourceBundle getBundle(Locale locale) {
        return this.languageBundleMap.get(locale.toString());
    }

    @Override
    public ResourceBundle getDefaultBundle() {
        return this.defaultBundle;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("loading bundle for key '" + this.bundleKey + "'");
        ResourceBundleClassLoader rbcl = null;
        if (StringUtils.isNotBlank((String)this.filePath)) {
            rbcl = new ResourceBundleClassLoader(this.getClass().getClassLoader());
            rbcl.setFilePath(this.filePath);
        }
        ResourceBundle.Control control = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        try {
            ResourceBundle bundle = rbcl != null ? ResourceBundle.getBundle(this.bundleKey, this.tlitLocale, rbcl, control) : ResourceBundle.getBundle(this.bundleKey, this.tlitLocale, control);
            bundle = new Utf8PropertyResourceBundle((PropertyResourceBundle)bundle);
            this.languageBundleMap.put(this.tlitLocale.toString(), bundle);
            LOGGER.debug("'" + this.bundleKey + "' loaded for locale " + this.tlitLocale);
        }
        catch (MissingResourceException exep) {
            LOGGER.warn(exep.getMessage());
        }
        try {
            this.defaultBundle = rbcl != null ? ResourceBundle.getBundle(this.bundleKey, Locale.getDefault(), rbcl) : ResourceBundle.getBundle(this.bundleKey);
            this.defaultBundle = new Utf8PropertyResourceBundle((PropertyResourceBundle)this.defaultBundle);
            LOGGER.debug("loaded for default locale");
        }
        catch (MissingResourceException exep) {
            LOGGER.warn(exep.getMessage());
        }
    }

    private Locale parseLocaleStr(String localeStr) {
        Locale locale = null;
        String[] parts = localeStr.split("_", 2);
        locale = parts.length == 1 ? new Locale(parts[0]) : (parts.length > 1 ? new Locale(parts[0], parts[1]) : Locale.getDefault());
        return locale;
    }

    @Override
    public void setLocale(Locale tlitLocale) {
        LOGGER.debug("loading bundle for key '" + this.bundleKey + "'");
        ResourceBundleClassLoader rbcl = null;
        if (StringUtils.isNotBlank((String)this.filePath)) {
            rbcl = new ResourceBundleClassLoader(this.getClass().getClassLoader());
            rbcl.setFilePath(this.filePath);
        }
        ResourceBundle.Control control = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        try {
            ResourceBundle bundle = rbcl != null ? ResourceBundle.getBundle(this.bundleKey, tlitLocale, rbcl, control) : ResourceBundle.getBundle(this.bundleKey, tlitLocale, control);
            bundle = new Utf8PropertyResourceBundle((PropertyResourceBundle)bundle);
            LOGGER.debug("'" + this.bundleKey + "' loaded for locale " + tlitLocale);
            this.languageBundleMap.put(tlitLocale.toString(), bundle);
        }
        catch (MissingResourceException exep) {
            LOGGER.debug(exep.getMessage());
        }
        this.tlitLocale = tlitLocale;
    }
}

