/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.text;

import in.gov.uidai.ec.icas.error.ClientException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UidLocaleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidLocaleUtils.class);
    private static final String LANG_CODE_TO_LOCALE_FILE = "res/icas/language-codes.properties";
    private static Map<Integer, String> langCodetoLocaleMap = new HashMap<Integer, String>();

    public static final String getLocaleStrFromLangCode(int langCode) {
        return langCodetoLocaleMap.get(langCode);
    }

    public static Locale getLocaleFromLangCode(int langCode) {
        String localeStr = langCodetoLocaleMap.get(langCode);
        if (localeStr != null) {
            return UidLocaleUtils.parseLocaleStr(localeStr);
        }
        return Locale.getDefault();
    }

    public static Locale parseLocaleStr(String localeStr) {
        Locale locale = null;
        String[] parts = localeStr.split("_", 3);
        locale = parts.length == 1 ? new Locale(parts[0]) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : (parts.length == 3 ? new Locale(parts[0], parts[1], parts[2]) : Locale.getDefault()));
        return locale;
    }

    public static final String getLangCodeFrmLocaleStr(String localeStr) {
        for (Map.Entry<Integer, String> lngCdeLocaleStrEntry : langCodetoLocaleMap.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((String)localeStr, (String)lngCdeLocaleStrEntry.getValue())) continue;
            if (lngCdeLocaleStrEntry.getKey() < 10) {
                return "0" + lngCdeLocaleStrEntry.getKey().toString();
            }
            return lngCdeLocaleStrEntry.getKey().toString();
        }
        return "06";
    }

    private UidLocaleUtils() {
    }

    static {
        Properties langCodeProps = new Properties();
        try {
            langCodeProps.load(UidLocaleUtils.class.getClassLoader().getResourceAsStream(LANG_CODE_TO_LOCALE_FILE));
        }
        catch (IOException e) {
            LOGGER.error("Error loading language code", (Throwable)e);
            throw new ClientException("ec-errors:missingResource", e);
        }
        Set<Object> keySet = langCodeProps.keySet();
        for (Object key : keySet) {
            int code = Integer.parseInt(key.toString());
            langCodetoLocaleMap.put(code, langCodeProps.getProperty(key.toString()).trim());
        }
    }
}

