/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationVersion {
    public static final String VERSION;
    public static final String FULLDISPLAYVERSION;
    public static final String INTERNALVERSION;
    public static final String DISTRIBUTION;
    public static final String OS;
    public static final String ARCH;
    private static String[] versionInfoParts;
    private static final Logger LOGGER;

    private ApplicationVersion() {
    }

    private static String readVersionInformation(String versionFilePath) {
        try {
            Path path = Paths.get(versionFilePath, new String[0]);
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            return lines.get(0);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while reading version information for version file" + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static String extractOS() {
        try {
            return versionInfoParts[2];
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while extracting OS information." + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static String extractArch() {
        try {
            return versionInfoParts[3];
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while extracting OS Arch information." + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static String extractDistribution() {
        try {
            return versionInfoParts[1];
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while extracting distribution information." + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static String extractVersion() {
        try {
            String internalVersion = versionInfoParts[0];
            String[] versionParts = internalVersion.split("\\.");
            return String.join((CharSequence)".", versionParts[0], versionParts[1], versionParts[2], versionParts[3]);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while extracting version." + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static String extractInternalVersion() {
        try {
            return versionInfoParts[0];
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while extracting internal version." + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static String getFullDisplayVersion() {
        try {
            String[] versionParts = versionInfoParts[0].split("\\.");
            String ecmpVersion = ApplicationVersion.extractVersion();
            return String.format("%s/%s-%s", ecmpVersion, versionParts[4], versionInfoParts[1]);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while formatting full display version." + e.getMessage());
            ApplicationVersion.showErrorMessageAndExit();
            return "";
        }
    }

    private static void showErrorMessageAndExit() {
        JOptionPane.showOptionDialog(null, "Application version is not available or is invalid. Please reinstall the application.", "Aadhaar", -1, 0, null, null, null);
        System.exit(-1);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ApplicationVersion.class);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ApplicationVersion.class.getClassLoader();
        }
        Properties props = new Properties();
        try {
            InputStream input = cl.getResourceAsStream("res/icas/version.properties");
            props.load(input);
            input.close();
        }
        catch (Exception exep) {
            LOGGER.error("Error occurred while reading version.properties" + exep.getMessage());
        }
        VERSION = props.getProperty("version", "xx.xx.xx");
        String versionInformation = ApplicationVersion.readVersionInformation("version");
        versionInfoParts = versionInformation.split(",");
        DISTRIBUTION = ApplicationVersion.extractDistribution();
        INTERNALVERSION = ApplicationVersion.extractInternalVersion();
        FULLDISPLAYVERSION = ApplicationVersion.getFullDisplayVersion();
        OS = ApplicationVersion.extractOS();
        ARCH = ApplicationVersion.extractArch();
    }
}

