/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class ModelBase<T> {
    private final List<IValidityEventListener> validityChangeListeners = new ArrayList<IValidityEventListener>();
    private final List<IMandatoryEventListener> mandatoryChangeListeners = new ArrayList<IMandatoryEventListener>();
    private final List<Consumer<T>> changeListeners = new ArrayList<Consumer<T>>();
    private final List<Consumer<T>> documentUploadListeners = new ArrayList<Consumer<T>>();
    private final List<Consumer<T>> docNameChangeListeners = new ArrayList<Consumer<T>>();
    protected IResourceBundleContext rbCtx;
    private boolean isValid;
    private boolean isMandatory;

    public ModelBase(IResourceBundleContext rbCtx) {
        this.rbCtx = rbCtx;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void setValid(boolean isValid) {
        if (this.isValid != isValid) {
            this.isValid = isValid;
            this.fireValidityChangeEvent(isValid);
        }
    }

    protected String getMessage(Object key, Object ... arguments) {
        return key != null ? this.rbCtx.getMessage(key, arguments) : null;
    }

    public void addValidityChangeListener(IValidityEventListener delegate) {
        if (delegate == null) {
            return;
        }
        this.validityChangeListeners.add(delegate);
    }

    private void fireValidityChangeEvent(boolean validity) {
        this.validityChangeListeners.forEach(listener -> listener.accept(validity));
    }

    public void addChangeListener(Consumer<T> delegate) {
        if (delegate == null) {
            return;
        }
        this.changeListeners.add(delegate);
    }

    public void addDocumentUploadListener(Consumer<T> delegate) {
        if (delegate == null) {
            return;
        }
        this.documentUploadListeners.add(delegate);
    }

    public void addDocNameChangeListener(Consumer<T> delegate) {
        if (delegate == null) {
            return;
        }
        this.docNameChangeListeners.add(delegate);
    }

    protected void fireChangeEvent(T changedValue) {
        this.changeListeners.forEach(listener -> listener.accept(changedValue));
    }

    protected void fireDocumentUploadEvent(T changedValue) {
        this.documentUploadListeners.forEach(listener -> listener.accept(changedValue));
    }

    protected void fireDocNameChangeEvent(T changedValue) {
        this.docNameChangeListeners.forEach(listener -> listener.accept(changedValue));
    }

    public void addMandatoryChangeListener(IMandatoryEventListener delegate) {
        if (delegate == null) {
            return;
        }
        this.mandatoryChangeListeners.add(delegate);
    }

    protected void fireMandatoryChangeEvent(boolean isMandatory) {
        this.mandatoryChangeListeners.forEach(listener -> listener.accept(isMandatory));
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean isMandatory) {
        if (this.isMandatory != isMandatory) {
            this.isMandatory = isMandatory;
            this.fireMandatoryChangeEvent(isMandatory);
        }
    }

    public static interface IMandatoryEventListener {
        public void accept(boolean var1);
    }

    public static interface IValidityEventListener {
        public void accept(boolean var1);
    }
}

