/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service;

import javax.sql.DataSource;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class RuntimeDomainDBConfig {
    @Autowired
    @Qualifier(value="ds.runtime")
    DataSource runtimeDataSource;

    @Bean
    public SqlSessionFactoryBean runtimeSqlSessionFactory() {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(this.runtimeDataSource);
        sessionFactory.setConfigLocation((Resource)new ClassPathResource("db/runtime/runtime.config.xml"));
        return sessionFactory;
    }

    @Bean
    public SqlSessionTemplate runtimeSqlSession() throws Exception {
        return new SqlSessionTemplate(this.runtimeSqlSessionFactory().getObject());
    }
}

