/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.appointment;

import com.google.protobuf.InvalidProtocolBufferException;
import in.gov.uidai.appointment.qr.proto.AddressData;
import in.gov.uidai.appointment.qr.proto.EnrolAppointmentData;
import in.gov.uidai.appointment.qr.proto.HeadOfFamilyData;
import in.gov.uidai.appointment.qr.proto.UpdateAppointmentData;
import in.gov.uidai.ec.security.impl.SignatureNotVerifiedException;
import in.gov.uidai.ec.service.appointment.IAppointmentService;
import in.gov.uidai.ec.service.appointment.QRCodeReader;
import in.gov.uidai.ec.service.appointment.QrCodeReaderException;
import in.gov.uidai.ec.service.appointment.QrRSASHA256SignatureValidator;
import in.gov.uidai.ec.service.appointment.model.Address;
import in.gov.uidai.ec.service.appointment.model.AppointmentTypeEnum;
import in.gov.uidai.ec.service.appointment.model.HeadOfFamily;
import in.gov.uidai.ec.service.appointment.model.IAppointment;
import in.gov.uidai.ec.service.appointment.model.NewEnrolAppointment;
import in.gov.uidai.ec.service.appointment.model.NewEnrolment;
import in.gov.uidai.ec.service.appointment.model.QRData;
import in.gov.uidai.ec.service.appointment.model.UpdateEnrolAppointment;
import in.gov.uidai.ec.service.appointment.model.UpdateEnrolment;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import java.io.File;
import java.util.Optional;

public class AppointmentService
implements IAppointmentService {
    private IAppointment appointment;
    private IPinCodeService postOfficeDataService;

    public static String toDisplayCase(String s) {
        String ACTIONABLE_DELIMITERS = " '-/";
        StringBuilder sb = new StringBuilder();
        boolean capNext = true;
        for (char c : s.toCharArray()) {
            c = capNext ? Character.toUpperCase(c) : Character.toLowerCase(c);
            sb.append(c);
            capNext = " '-/".indexOf(c) >= 0;
        }
        return sb.toString();
    }

    public void setPostOfficeDataService(IPinCodeService postOfficeDataService) {
        this.postOfficeDataService = postOfficeDataService;
    }

    @Override
    public IAppointment getAppointmentDetails() {
        return this.appointment;
    }

    @Override
    public IAppointment scanAppointmentSlip(File file) throws QrCodeReaderException, SignatureNotVerifiedException {
        QrRSASHA256SignatureValidator signatureValidator = new QrRSASHA256SignatureValidator("appointments/QRCodeSignature.cer");
        QRCodeReader qrCodeReader = new QRCodeReader();
        QRData qrData = qrCodeReader.read(file);
        boolean isSignatureValid = signatureValidator.verify(qrData.getAppointmentData(), qrData.getSignature());
        if (isSignatureValid) {
            IAppointment appointmentData;
            this.appointment = appointmentData = this.convertToAppointmentData(qrData);
            return appointmentData;
        }
        throw new SignatureNotVerifiedException("Failed to verify signature");
    }

    private IAppointment convertToAppointmentData(QRData qrData) throws QrCodeReaderException {
        if (qrData.getAppointmentType() == AppointmentTypeEnum.NEW) {
            return this.getNewEnrolmentData(qrData.getAppointmentData());
        }
        if (qrData.getAppointmentType() == AppointmentTypeEnum.UPDATE) {
            return this.getUpdateEnrolmentData(qrData.getAppointmentData());
        }
        throw new QrCodeReaderException("Invalid QR code. Cannot determine appointment type to be of NEW or UPDATE");
    }

    private IAppointment getNewEnrolmentData(byte[] qrData) throws QrCodeReaderException {
        EnrolAppointmentData appointmentDataProto;
        try {
            appointmentDataProto = EnrolAppointmentData.parseFrom((byte[])qrData);
        }
        catch (InvalidProtocolBufferException e) {
            throw new QrCodeReaderException("Invalid protocol buffer for QR code.", (Exception)((Object)e));
        }
        HeadOfFamilyData headOfFamilyProto = appointmentDataProto.getHeadoffamily();
        HeadOfFamily headOfFamily = this.setHODDetails(headOfFamilyProto);
        AddressData addressProto = appointmentDataProto.getAddress();
        Address address = this.setAddressDetails(addressProto);
        NewEnrolment newEnrolment = new NewEnrolment();
        newEnrolment.setAppointmentId(appointmentDataProto.getAppointmentid().trim());
        newEnrolment.setFullName(AppointmentService.toDisplayCase(appointmentDataProto.getFullname().trim()));
        newEnrolment.setGender(AppointmentService.toDisplayCase(appointmentDataProto.getGender().trim()));
        newEnrolment.setDob(appointmentDataProto.getDob().trim());
        newEnrolment.setAge(appointmentDataProto.getAge());
        newEnrolment.setAddress(address);
        newEnrolment.setMobileNo(appointmentDataProto.getMobileno().trim());
        newEnrolment.setIsdCode(appointmentDataProto.getIsd().trim());
        newEnrolment.setEmail(appointmentDataProto.getEmail().trim());
        newEnrolment.setNRI(appointmentDataProto.getIsNRI());
        newEnrolment.setHeadOfFamily(headOfFamily);
        NewEnrolAppointment appointmentEnrolEntity = new NewEnrolAppointment();
        appointmentEnrolEntity.setNewEnrolment(newEnrolment);
        return appointmentEnrolEntity;
    }

    private IAppointment getUpdateEnrolmentData(byte[] qrData) throws QrCodeReaderException {
        UpdateAppointmentData appointmentDataProto;
        try {
            appointmentDataProto = UpdateAppointmentData.parseFrom((byte[])qrData);
        }
        catch (InvalidProtocolBufferException e) {
            throw new QrCodeReaderException("Invalid protocol buffer for QR code.", (Exception)((Object)e));
        }
        AddressData addressProto = appointmentDataProto.getNewaddress();
        Address address = null;
        if (addressProto.getAllFields().size() > 0) {
            address = this.setAddressDetails(addressProto);
        }
        HeadOfFamilyData headOfFamilyProto = appointmentDataProto.getHeadoffamily();
        HeadOfFamily headOfFamily = this.setHODDetails(headOfFamilyProto);
        UpdateEnrolment updateEnrolment = new UpdateEnrolment();
        updateEnrolment.setAppointmentId(appointmentDataProto.getAppointmentid().trim());
        updateEnrolment.setAadhaarId(appointmentDataProto.getAadhaarid().trim());
        updateEnrolment.setFullName(AppointmentService.toDisplayCase(appointmentDataProto.getFullname().trim()));
        updateEnrolment.setBiometricUpdate(appointmentDataProto.getBiometricupdate().trim());
        updateEnrolment.setNewName(AppointmentService.toDisplayCase(appointmentDataProto.getNewname().trim()));
        updateEnrolment.setNewGender(AppointmentService.toDisplayCase(appointmentDataProto.getNewgender().trim()));
        updateEnrolment.setNewDob(appointmentDataProto.getNewdob().trim());
        updateEnrolment.setNewAddress(address);
        updateEnrolment.setNewMobile(appointmentDataProto.getNewmobile().trim());
        updateEnrolment.setNewIsdCode(appointmentDataProto.getNewisd().trim());
        updateEnrolment.setNewEmail(appointmentDataProto.getNewemail().trim());
        updateEnrolment.setNRI(appointmentDataProto.getIsNRI());
        updateEnrolment.setHeadOfFamily(headOfFamily);
        UpdateEnrolAppointment appointmentUpdateEntity = new UpdateEnrolAppointment();
        appointmentUpdateEntity.setUpdateEnrolment(updateEnrolment);
        return appointmentUpdateEntity;
    }

    private Address setAddressDetails(AddressData addressProto) {
        Address address = this.fetchAddressDetails(addressProto);
        address.setCareOf(AppointmentService.toDisplayCase(addressProto.getCareof().trim()));
        address.setCareOfName(AppointmentService.toDisplayCase(addressProto.getCareofname().trim()));
        address.setHouseNo(AppointmentService.toDisplayCase(addressProto.getHouseno().trim()));
        address.setStreet(AppointmentService.toDisplayCase(addressProto.getStreet().trim()));
        address.setLandmark(AppointmentService.toDisplayCase(addressProto.getLandmark().trim()));
        address.setArea(AppointmentService.toDisplayCase(addressProto.getArea().trim()));
        return address;
    }

    private Address fetchAddressDetails(AddressData addressProto) {
        Address address = new Address();
        String pincodeFromProto = addressProto.getPincode().trim();
        if (pincodeFromProto.equals("")) {
            return new Address();
        }
        PostalAddress postalAddress = PostalAddress.EMPTY_POSTAL_ADDRESS;
        Optional<PostalAddress> addressOpt = this.postOfficeDataService.findByPinCode(Integer.parseInt(pincodeFromProto), false).stream().filter(f -> f.getVtc().getAddressValue().equals(addressProto.getVtc())).findFirst();
        if (addressOpt.isPresent()) {
            postalAddress = addressOpt.get();
        }
        address.setVtc(postalAddress.getVtc());
        address.setDistrict(postalAddress.getDistrict());
        address.setState(postalAddress.getState());
        address.setPincode(postalAddress.getPinCode());
        address.setPostOfficeName(postalAddress.getSubDistrict());
        return address;
    }

    private HeadOfFamily setHODDetails(HeadOfFamilyData headOfFamilyProto) {
        HeadOfFamily headOfFamily = null;
        if (headOfFamilyProto.getAllFields().size() > 0) {
            headOfFamily = new HeadOfFamily();
            headOfFamily.setType(headOfFamilyProto.getType().trim());
            headOfFamily.setName(AppointmentService.toDisplayCase(headOfFamilyProto.getName().trim()));
            headOfFamily.setEnrolmentId(headOfFamilyProto.getEnrolmentid().trim());
            headOfFamily.setAadhaarId(headOfFamilyProto.getAadharid().trim());
        }
        return headOfFamily;
    }
}

