/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.appointment;

import boofcv.abst.fiducial.QrCodePreciseDetector;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import in.gov.uidai.ec.service.appointment.QrCodeReaderException;
import in.gov.uidai.ec.service.appointment.model.QRData;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QRCodeReader {
    private static final int SIGNATURE_LENGTH = 256;
    private static final int APPOINTMENT_TYPE_LENGTH = 1;
    private static final int QR_MESSAGE_LENGTH = 257;
    private static final Logger LOGGER = LoggerFactory.getLogger(QRCodeReader.class);

    QRCodeReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QRData read(File file) throws QrCodeReaderException {
        if (!file.exists()) throw new QrCodeReaderException("Error reading QR Code: File does not exist: " + file.getAbsolutePath());
        try {
            BufferedImage qrImage;
            if (file.getName().endsWith(".jpg")) {
                qrImage = ImageIO.read(file);
                FileUtils.deleteQuietly((File)file);
            } else {
                PDDocument document = PDDocument.load((File)file);
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                if (document.getNumberOfPages() < 1) {
                    throw new QrCodeReaderException("PDF File containing QR Code is empty: number of pages = " + document.getNumberOfPages());
                }
                qrImage = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
            }
            GrayU8 gray = ConvertBufferedImage.convertFrom((BufferedImage)qrImage, (GrayU8)null);
            QrCodePreciseDetector detector = FactoryFiducial.qrcode(null, GrayU8.class);
            detector.process((ImageGray)gray);
            List detections = detector.getDetections();
            if (detections.size() != 1) {
                if (detections.size() != 0) throw new QrCodeReaderException("More than one QR code detected in given PDF");
                throw new QrCodeReaderException("No QR code detected in given PDF");
            }
            QrCode qrCode = (QrCode)detections.get(0);
            BigInteger qrDataNumber = new BigInteger(qrCode.message);
            byte[] qrDecompressedData = this.decompress(qrDataNumber.toByteArray());
            try (ByteArrayInputStream in = new ByteArrayInputStream(qrDecompressedData);){
                int dataLength = in.available();
                if (dataLength < 257) {
                    throw new QrCodeReaderException("Invalid QR Code");
                }
                byte[] appointmentData = new byte[dataLength - 1 - 256];
                byte[] signature = new byte[256];
                in.read();
                int i = in.read(appointmentData, 0, appointmentData.length);
                int j = in.read(signature, 0, 256);
                if (i > 0 || j > 0) {
                    LOGGER.info("Read completed");
                } else {
                    LOGGER.info("No more data present");
                }
                QRData qRData = new QRData(qrDecompressedData[0], signature, appointmentData);
                return qRData;
            }
        }
        catch (IOException e) {
            throw new QrCodeReaderException("Failed to load PDF for reading QR code. ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decompress(byte[] data) throws QrCodeReaderException {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] buffer = new byte[2048];
            while (!inflater.finished()) {
                int count;
                try {
                    count = inflater.inflate(buffer);
                }
                catch (DataFormatException e) {
                    throw new QrCodeReaderException("Invalid QR code detected in given PDF. ", e);
                }
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new QrCodeReaderException("Failed to close outputStream while decompressing qr data. ", e);
        }
    }
}

