/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.appointment;

import in.gov.uidai.ec.security.impl.SecurityConstants;
import in.gov.uidai.ec.security.impl.SignatureNotVerifiedException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QrRSASHA256SignatureValidator
implements SecurityConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(QrRSASHA256SignatureValidator.class);
    private static final String SIGNATURE_ALGORITHM = "SHA-256";
    private static final String ENCRYPTION_ALGORITHM = "SHA256withRSA";
    private final String keyFileName;

    QrRSASHA256SignatureValidator(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public boolean verify(byte[] appointmentData, byte[] signature) throws SignatureNotVerifiedException {
        try {
            PublicKey publicKey = this.getPublicKeyFromCertificate(this.keyFileName);
            if (publicKey == null) {
                LOGGER.error("Error retrieving public key");
                throw new Exception("Error retrieving public key for signature verification: " + this.keyFileName);
            }
            Signature publicSignature = Signature.getInstance(ENCRYPTION_ALGORITHM);
            publicSignature.initVerify(publicKey);
            String shaDigest = this.getSHARec(appointmentData);
            publicSignature.update(Hex.decodeHex((char[])shaDigest.toCharArray()));
            return publicSignature.verify(signature);
        }
        catch (Exception e) {
            throw new SignatureNotVerifiedException("Signature Not Verified. ", e);
        }
    }

    private PublicKey getPublicKeyFromCertificate(String certificatePath) throws CertificateException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            InputStream certStream = ClassLoader.getSystemResourceAsStream(certificatePath);
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(certStream);
            return x509Certificate.getPublicKey();
        }
        catch (Exception e) {
            throw new CertificateException("Unable to get certificate. ", e);
        }
    }

    private String getSHARec(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(SIGNATURE_ALGORITHM);
        return Hex.encodeHexString((byte[])md.digest(input));
    }
}

