/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.appointment.model;

import in.gov.uidai.ec.service.appointment.model.Address;
import in.gov.uidai.ec.service.appointment.model.HeadOfFamily;

public class UpdateEnrolment {
    public static final String NO_BIOMETRIC_UPDATE = "no biometric update";
    public static final String BIOMETRIC_UPDATE = "biometric update";
    public static final String MANDATORY_BIOMETRIC_UPDATE = "mandatory biometric update";
    public static final String RESIDENT_LESS_THAN_5_YEARS = "resident less than 5 years old";
    private String schemaVersion;
    private String appointmentId;
    private String aadhaarId;
    private String fullName;
    private String biometricUpdate;
    private String newName;
    private String newGender;
    private String newDob;
    private Address newAddress;
    private String newMobile;
    private String newIsdCode;
    private String newEmail;
    private HeadOfFamily headOfFamily;
    private boolean isNRI;

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAadhaarId() {
        return this.aadhaarId;
    }

    public void setAadhaarId(String aadhaarId) {
        this.aadhaarId = aadhaarId;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getBiometricUpdate() {
        if (this.biometricUpdate == null) {
            return null;
        }
        switch (this.biometricUpdate.trim()) {
            case "0": {
                return NO_BIOMETRIC_UPDATE;
            }
            case "1": {
                return BIOMETRIC_UPDATE;
            }
            case "2": {
                return MANDATORY_BIOMETRIC_UPDATE;
            }
            case "3": {
                return RESIDENT_LESS_THAN_5_YEARS;
            }
        }
        return null;
    }

    public void setBiometricUpdate(String biometricUpdate) {
        this.biometricUpdate = biometricUpdate;
    }

    public String getNewGender() {
        return this.newGender;
    }

    public void setNewGender(String newGender) {
        this.newGender = newGender;
    }

    public String getNewDob() {
        return this.newDob;
    }

    public void setNewDob(String newDob) {
        this.newDob = newDob;
    }

    public Address getNewAddress() {
        return this.newAddress;
    }

    public void setNewAddress(Address newAddress) {
        this.newAddress = newAddress;
    }

    public String getNewMobile() {
        return this.newMobile;
    }

    public void setNewMobile(String newMobile) {
        this.newMobile = newMobile;
    }

    public String getNewEmail() {
        return this.newEmail;
    }

    public void setNewEmail(String newEmail) {
        this.newEmail = newEmail;
    }

    public HeadOfFamily getHeadOfFamily() {
        return this.headOfFamily;
    }

    public void setHeadOfFamily(HeadOfFamily headOfFamily) {
        this.headOfFamily = headOfFamily;
    }

    public boolean isNameUpdated() {
        return this.isValueUpdated(this.newName);
    }

    public boolean isGenderUpdated() {
        return this.isValueUpdated(this.newGender);
    }

    public boolean isDobUpdated() {
        return this.isValueUpdated(this.newDob);
    }

    public boolean isAddressUpdated() {
        return this.newAddress != null;
    }

    public boolean isMobileNumberUpdated() {
        return this.isValueUpdated(this.newMobile);
    }

    public boolean isEmailUpdated() {
        return this.isValueUpdated(this.newEmail);
    }

    public boolean isHOFUpdated() {
        return this.headOfFamily != null;
    }

    public boolean isBiometricUpdated() {
        return this.biometricUpdate != null && !this.biometricUpdate.equalsIgnoreCase("0");
    }

    private boolean isValueUpdated(String value) {
        if (value == null) {
            return false;
        }
        return !value.equalsIgnoreCase("");
    }

    public boolean isNRI() {
        return this.isNRI;
    }

    public void setNRI(boolean NRI) {
        this.isNRI = NRI;
    }

    public String getNewIsdCode() {
        return this.newIsdCode;
    }

    public void setNewIsdCode(String newIsdCode) {
        this.newIsdCode = newIsdCode;
    }
}

