/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.autosyncupload;

import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.packet.metadata.AutoPacketMetadata;
import in.gov.uidai.ec.escapi.packet.metadata.AutoPacketMetadataEnvelope;
import in.gov.uidai.ec.escapi.packet.metadata.EnrolStatus;
import in.gov.uidai.ec.escapi.packet.metadata.EnrolmentMetadata;
import in.gov.uidai.ec.escapi.packet.metadata.PacketStatusMetadata;
import in.gov.uidai.ec.escapi.packet.metadata.SecurityParameterMetadata;
import in.gov.uidai.ec.escapi.packet.metadata.SessionMetadata;
import in.gov.uidai.ec.escapi.packet.metadata.StationMetadata;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.security.sapi.IHashGenerator;
import in.gov.uidai.ec.service.autosyncupload.IAutoSyncUploadService;
import in.gov.uidai.ec.service.autosyncupload.IEnrolmentPacketHashProvider;
import in.gov.uidai.ec.service.autosyncupload.PathProvider;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrol.EnrollmentPacketManager;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.IEnrolmentIDGenerator;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.packet.IEnrolVerifyDAO;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import in.gov.uidai.ec.service.packetgenerator.IEnrolPacketGeneratorService;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.token.TokenManagerDAO;
import in.gov.uidai.ec.utils.DateUtils;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoSyncUploadService
implements IAutoSyncUploadService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSyncUploadService.class);
    private static final String TOKEN_API = "PACKET_STATUS_API";
    private static final String AAD = "Packet-Sync";
    private IEnrolmentIDGenerator enrolmentIDGenerator;
    private ISessionService sessionService;
    private File autoSyncRootFolder;
    private IEnrolVerifyDAO enrollmentDb;
    private EnrollmentPacketManager enrolPacketManager;
    private IEnrolmentPacketHashProvider packetHashProvider;
    private IRegistrationService registrationService;
    private TokenManagerDAO tokenDAO;
    private IEnrolPacketGeneratorService enrolmentPacketGenerator;
    private IHashGenerator hashGenerator;
    private EnrollmentService enrollmentService;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;
    private IPreSyncPreference preSyncPref;
    private IOucDataStore oucDataStore;

    public void setOucDataStore(IOucDataStore dataStore) {
        this.oucDataStore = dataStore;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setEnrolmentIDGenerator(IEnrolmentIDGenerator enrolmentIDGenerator) {
        this.enrolmentIDGenerator = enrolmentIDGenerator;
    }

    public void setSessionService(ISessionService iSessionService) {
        this.sessionService = iSessionService;
    }

    public void setEnrollmentDb(IEnrolVerifyDAO enrollmentDb) {
        this.enrollmentDb = enrollmentDb;
    }

    public void setAutoSyncRootFolder(File root) {
        this.autoSyncRootFolder = root;
    }

    public void setPacketHashProvider(IEnrolmentPacketHashProvider packetHashProvider) {
        this.packetHashProvider = packetHashProvider;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setEnrolPacketManager(EnrollmentPacketManager enrollmentPacketManager) {
        this.enrolPacketManager = enrollmentPacketManager;
    }

    public void setEnrolmentPacketGenerator(IEnrolPacketGeneratorService enrolmentPacketGenerator) {
        this.enrolmentPacketGenerator = enrolmentPacketGenerator;
    }

    public void setHashGenerator(IHashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setTokenManagerDAO(TokenManagerDAO dao) {
        this.tokenDAO = dao;
    }

    @Override
    public void savePacket() throws Exception {
        try {
            this.prepare();
            byte[] packetData = this.enrolmentPacketGenerator.generatePacket();
            EID eid = this.enrollmentService.getEnrolId();
            File packetFile = this.getPacketFileInTempDir();
            this.savePacketToDisk(eid, packetData, packetFile);
            LOGGER.info("saved packet file, path = {}, file exists = {}, eid = {}", new Object[]{packetFile.getAbsolutePath(), packetFile.exists(), eid.toString()});
            Date packetCreatedDate = new Date();
            if (!this.verifyIfPacketAlreadyExists(eid)) {
                this.writeMetadataAndCreateFinalPacket(eid, packetCreatedDate);
            }
            LOGGER.info("finished writeMetadataAndCreateFinalPacket on eid = " + eid.toString());
            this.enrolPacketManager.updatePacketDetailsInDb(packetCreatedDate);
            LOGGER.info("finished packet status db update on eid = " + eid.toString());
        }
        catch (IOException e) {
            LOGGER.info("Error connecting to Enrol Service Client!!!", (Throwable)e);
            if (this.enrollmentService.getEnrolId() != null) {
                this.cleanUp(this.enrollmentService.getEnrolId().toString());
            }
            throw e;
        }
        catch (StationInfoStoreException e) {
            LOGGER.info("Error storing/fetching information from Enrol Service Client!!!", (Throwable)e);
            if (this.enrollmentService.getEnrolId() != null) {
                this.cleanUp(this.enrollmentService.getEnrolId().toString());
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error creating packet: ", (Throwable)e);
            if (this.enrollmentService.getEnrolId() != null) {
                this.cleanUp(this.enrollmentService.getEnrolId().toString());
            }
            throw e;
        }
        finally {
            this.enrollmentService.resetDocumentsFromModel();
            this.enrollmentService.clearMemory();
        }
    }

    public File getPacketFileInTempDir() {
        EID eid = this.enrollmentService.getEnrolId();
        return PathProvider.PacketDestFile(this.autoSyncRootFolder.getPath(), eid.hashValue());
    }

    private void writeMetadataAndCreateFinalPacket(EID eid, Date packetCreatedDate) throws Exception {
        AutoPacketMetadataEnvelope metadataForSave = this.getPacketMetadataDetailsForSave(packetCreatedDate);
        this.enrolServiceClientApiService.saveMetaDataToTmpDir(metadataForSave);
        LOGGER.info("finished writing to mata data json and packet status json for eid = " + eid);
        this.renameTempDirToEidDir(eid.toString());
        LOGGER.info("finished renaming tmp dir to eid , eid = " + eid);
    }

    private boolean verifyIfPacketAlreadyExists(EID eid) {
        File target = new File(this.autoSyncRootFolder + File.separator + eid + File.separator + eid.hashValue() + ".pkt.zip");
        if (target.exists()) {
            FileUtils.deleteQuietly((File)PathProvider.TempFolder(this.autoSyncRootFolder.getPath()));
            return true;
        }
        return false;
    }

    private void prepare() throws Exception {
        File tmp = PathProvider.TempFolder(this.autoSyncRootFolder.getPath());
        if (tmp.exists()) {
            boolean deleteStatus = FileUtils.deleteQuietly((File)tmp);
            if (!deleteStatus) {
                throw new Exception("failed to clean and prepare for enrollment");
            }
        } else {
            boolean result = tmp.mkdirs();
            if (!result) {
                throw new Exception("failed to create tmp directory for new enrollment");
            }
        }
    }

    @Override
    public void cleanUp(String eid) {
        try {
            File tmp = PathProvider.TempFolder(this.autoSyncRootFolder.getPath());
            boolean deleteStatus = FileUtils.deleteQuietly((File)tmp);
            this.enrollmentDb.delete(eid);
            if (!deleteStatus) {
                throw new Exception("AutoSyncUploadService : deleteTmpFolder : Failed to delete tmp folder");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private PacketStatusMetadata getPktStatusMetadata(Date packetCreatedDate, File packetFile) throws Exception {
        PacketStatusMetadata packetStatusMetadata = new PacketStatusMetadata();
        References references = this.enrollmentService.getReferences();
        ReferenceIntroducer referenceIntroducer = references.getReferenceIntroducer();
        if (referenceIntroducer.isMandatory()) {
            packetStatusMetadata.setActor(referenceIntroducer.getName());
        }
        packetStatusMetadata.setLocationCode(this.getLocationCode());
        packetStatusMetadata.setPacketSize(Long.toString(packetFile.length()));
        try {
            packetStatusMetadata.setDate(DateUtils.getXMLTimeStamp(packetCreatedDate.getTime()));
        }
        catch (DatatypeConfigurationException e) {
            throw new Exception("Error while converting date " + e.getMessage());
        }
        packetStatusMetadata.setStatus(EnrolStatus.APPROVED);
        if (references.getHofDoc().isMandatory()) {
            packetStatusMetadata.setPacketVerifyType(PacketVerifyType.HOF);
        } else if (references.getReferenceIntroducer().isMandatory()) {
            packetStatusMetadata.setPacketVerifyType(PacketVerifyType.INTRODUCER);
        } else {
            packetStatusMetadata.setPacketVerifyType(PacketVerifyType.POI_POA);
        }
        return packetStatusMetadata;
    }

    public String getLocationCode() {
        String locationCode = this.enrollmentService.getDemoContactDetails().getAddress().getLocationCode();
        if (!this.enrollmentService.isUpdateEnrollment() && (locationCode.length() < 27 || "000000000000000000000000000".equalsIgnoreCase(locationCode))) {
            throw new ClientException("domain-errors:internal", new Object[]{" The location code cannot be 00000"});
        }
        if (!this.enrollmentService.isUpdateEnrollment()) {
            return locationCode;
        }
        if (locationCode.length() < 27 || "000000000000000000000000000".equalsIgnoreCase(locationCode)) {
            return "000000000000000000000000000";
        }
        return locationCode;
    }

    private AutoPacketMetadataEnvelope getPacketMetadataDetailsForSave(Date packetCreatedDate) throws Exception {
        File packetFile = this.getPacketFileInTempDir();
        String previousPacketSignature = this.enrolServiceClientApiService.getLastPacketSignature();
        StationMetadata stationMetadata = this.getStationMetadata();
        SessionMetadata sessionMetadata = this.getSessionMetadata();
        EnrolmentMetadata enrolmentMetadata = this.getEnrolmentMetadata(packetCreatedDate);
        PacketStatusMetadata packetStatusMetadata = this.getPktStatusMetadata(packetCreatedDate, packetFile);
        String tokenId = this.tokenDAO.getToken(TOKEN_API);
        SecurityParameterMetadata securityParameterMetadata = new SecurityParameterMetadata(tokenId);
        AutoPacketMetadata pmd = new AutoPacketMetadata(stationMetadata, sessionMetadata, enrolmentMetadata, packetStatusMetadata, securityParameterMetadata);
        String currentPacketSignature = this.sessionService.sign(pmd.toByteArray(), AAD);
        String pmdSequenceSignature = this.sessionService.sign((previousPacketSignature + currentPacketSignature).getBytes(), AAD);
        return new AutoPacketMetadataEnvelope(pmd, currentPacketSignature, pmdSequenceSignature);
    }

    private SessionMetadata getSessionMetadata() throws IOException, StationInfoStoreException {
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        return new SessionMetadata(this.enrollmentService.getConfirmerDetails().getOperator().getUserId(), this.sessionService.getUserSessionId(), Float.toString(gpsInfo.getLatitude().floatValue()), Float.toString(gpsInfo.getLongitude().floatValue()), Float.toString(gpsInfo.getAltitude().floatValue()));
    }

    private StationMetadata getStationMetadata() {
        String clientType = "Online";
        clientType = this.enrollmentService.isOnlineUpdate() ? clientType : "Offline";
        return new StationMetadata(this.registrationService.getRegistrarId(), this.registrationService.getAgencyId(), this.registrationService.getStationId(), this.registrationService.getRegisteredMachineCode(), this.sessionService.getRegistrationSequenceNumber(), ApplicationVersion.VERSION, ApplicationVersion.FULLDISPLAYVERSION, clientType);
    }

    private EnrolmentMetadata getEnrolmentMetadata(Date packetCreatedDate) throws Exception {
        UserDetails introducer;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        UserDetails supervisorDetails = this.enrollmentService.getConfirmerDetails().getSupervisor();
        String superVisorId = null;
        if (supervisorDetails != null) {
            superVisorId = supervisorDetails.getUserId();
        }
        String introducerId = (introducer = this.enrollmentService.getConfirmerDetails().getIntroducer()) != null ? introducer.getUid() : null;
        References references = this.enrollmentService.getReferences();
        ReferenceIntroducer referenceIntroducer = references.getReferenceIntroducer();
        if (references.isMandatory()) {
            introducerId = referenceIntroducer.getAadhaarNumber();
        }
        String currentPacketHash = this.packetHashProvider.getCurrentPacketHash();
        String sequenceNum = Long.toString(this.enrolmentIDGenerator.getCurrentSequenceValue());
        String mobileNumber = contact.getMobile().number();
        String isdCode = contact.getMobile().isdCode();
        String emailId = contact.getEmail().email();
        StringBuilder updatedBitValues = null;
        LOGGER.info("IF demographic update ::: " + this.enrollmentService.isUpdateEnrollment() + " If Document only update ::: " + this.enrollmentService.isDocumentUpdate() + " If Mandatory Biometric Update ::: " + this.enrollmentService.isMandatoryBiometricUpdate() + " If OffLine Document Update ::: " + this.enrollmentService.isOffLineDocumentUpdate() + "If Bio update ::: " + this.enrollmentService.isBiometricUpdate());
        if (this.enrollmentService.isUpdateEnrollment()) {
            if (this.enrollmentService.isBiometricUpdate() || this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isMandatoryBiometricUpdate() || this.enrollmentService.isOffLineDocumentUpdate() || this.enrollmentService.isBiometricUpdate()) {
                updatedBitValues = this.enrollmentService.getUpdatedBitValues();
            }
        } else {
            updatedBitValues = this.enrollmentService.getUpdatedBitValues();
        }
        EnrolmentMetadata enrolmentMetadata = new EnrolmentMetadata(this.enrollmentService.getEnrolId().toString(), this.enrollmentService.getAppointmentId(), this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? PacketType.DOCUPDATE.getEnrolFlag() : (this.enrollmentService.isUpdateEnrollment() ? PacketType.UPDATE.getEnrolFlag() : PacketType.NEW.getEnrolFlag()), packetCreatedDate, superVisorId, introducerId, sequenceNum, this.enrolPacketManager.generateBioExceptionPattern(), this.enrollmentService.getEnrollmentLangCode(), currentPacketHash, mobileNumber, isdCode, emailId, updatedBitValues);
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        if (personalDetail != null) {
            if (personalDetail.getName() != null) {
                enrolmentMetadata.setResidentName(personalDetail.getName().english());
            }
            if (personalDetail.getNpr() != null) {
                enrolmentMetadata.setNprNumber(personalDetail.getNpr().getNprNumber());
            }
        }
        enrolmentMetadata.setBiometricsMandatory(Boolean.valueOf(this.enrollmentService.isMandatoryBiometricUpdate()));
        this.setGstData(enrolmentMetadata);
        ResidentialStatus residentialStatus = this.enrollmentService.getDemoResidentialStatus();
        enrolmentMetadata.setNriEnrollment(Boolean.valueOf(residentialStatus.isNRI()));
        return enrolmentMetadata;
    }

    private void setGstData(EnrolmentMetadata enrolmentMetadata) throws IOException, StationInfoStoreException {
        ChargesInfo chargesInfo = this.oucDataStore.getChargesInfo();
        float amount = this.enrollmentService.isMandatoryBiometricUpdate() && this.enrollmentService.getMandatoryBiometricCheckResponse().getFreeUpdate().equalsIgnoreCase("No") ? chargesInfo.getAmountChargedForBiometricUpdate() : (this.enrollmentService.isMandatoryBiometricUpdate() || !this.enrollmentService.isUpdateEnrollment() ? 0.0f : (this.enrollmentService.isBiometricUpdate() ? chargesInfo.getAmountChargedForBiometricUpdate() : (this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? chargesInfo.getAmountChargedForDemographicUpdate() : chargesInfo.getAmountChargedForDemographicUpdate())));
        float gst = chargesInfo.getGstApplied();
        float gstCharged = amount * gst / 100.0f;
        float totalAmountCharged = amount + gstCharged;
        enrolmentMetadata.setAmount(Float.valueOf(amount));
        enrolmentMetadata.setGstCharged(Float.valueOf(gstCharged));
        enrolmentMetadata.setTotalAmountCharged(Float.valueOf(totalAmountCharged));
    }

    private void renameTempDirToEidDir(String eid) throws Exception {
        File tmp = PathProvider.TempFolder(this.autoSyncRootFolder.getPath());
        File eidFolder = new File(this.autoSyncRootFolder, eid);
        try {
            FileUtils.moveDirectory((File)tmp, (File)eidFolder);
        }
        catch (Exception e) {
            throw new Exception("error while renaming Temp Dir to Eid Directory" + e.getMessage());
        }
    }

    private void savePacketToDisk(EID eid, byte[] packetData, File originalPacketFile) throws IOException {
        boolean integrityCheckFailed;
        String inMemoryPacketHash = this.getBase64Hash(packetData);
        int retry = 2;
        String fileName = eid.hashValue();
        do {
            boolean j;
            if (originalPacketFile.exists() && !originalPacketFile.delete()) {
                LOGGER.error("unable to delete packet file");
                throw new RuntimeException("unable to delete packet file");
            }
            FileUtils.writeByteArrayToFile((File)originalPacketFile, (byte[])packetData);
            File packetCopy = this.createCopyOfPacket(fileName, originalPacketFile);
            byte[] packetCopyFileBytes = FileUtils.readFileToByteArray((File)packetCopy);
            String packetCopyFileHash = this.getBase64Hash(packetCopyFileBytes);
            boolean bl = integrityCheckFailed = !packetCopyFileHash.equals(inMemoryPacketHash);
            if (!integrityCheckFailed) continue;
            boolean i = originalPacketFile.delete();
            if (i & (j = packetCopy.delete())) {
                LOGGER.info("File deleted");
                continue;
            }
            LOGGER.info("File not deleted");
        } while (integrityCheckFailed && retry-- > 1);
        if (integrityCheckFailed) {
            throw new RuntimeException("packet integrity check failed after multiple retries");
        }
    }

    private File createCopyOfPacket(String fileName, File target) throws IOException {
        File packetCopy = PathProvider.PacketCopyDestFile(this.autoSyncRootFolder.getPath(), fileName);
        if (packetCopy.exists() && !packetCopy.delete()) {
            LOGGER.error("unable to delete packet copy file");
            throw new RuntimeException("unable to delete packet copy file");
        }
        FileUtils.copyFile((File)target, (File)packetCopy);
        return packetCopy;
    }

    private String getBase64Hash(byte[] packetData) {
        byte[] hash = this.hashGenerator.generateHash(packetData);
        return Base64.getEncoder().encodeToString(hash);
    }
}

