/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.autosyncupload;

import in.gov.uidai.ec.security.sapi.IHashGenerator;
import in.gov.uidai.ec.service.autosyncupload.IEnrolmentPacketHashProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PacketHashProvider
implements IEnrolmentPacketHashProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketHashProvider.class);
    private String autoSyncRootFolder;
    private IHashGenerator hashGenerator;

    PacketHashProvider() {
    }

    public void setAutoSyncRootFolder(String root) {
        this.autoSyncRootFolder = root;
    }

    public void setHashGenerator(IHashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    @Override
    public String getCurrentPacketHash() throws Exception {
        File packetZip = this.getPacketZipFile();
        try (FileInputStream is = new FileInputStream(packetZip.getPath());){
            byte[] currentPacketHash = this.hashGenerator.generateHash((InputStream)is);
            String string = Base64.getEncoder().encodeToString(currentPacketHash);
            return string;
        }
    }

    private File getPacketZipFile() throws Exception {
        File eidFolder = new File(Paths.get(this.autoSyncRootFolder, "tmp").toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("reading list of files from " + eidFolder.getAbsolutePath());
        }
        File[] files = Objects.requireNonNull(eidFolder.listFiles());
        File packetZip = null;
        for (File file : files) {
            if (!file.getName().endsWith("zip")) continue;
            packetZip = file;
            break;
        }
        if (packetZip == null) {
            throw new FileNotFoundException("could not find packet");
        }
        return packetZip;
    }
}

