/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.autosyncupload;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.security.impl.RecoverableFile;
import in.gov.uidai.ec.security.impl.RecoverableFileException;
import in.gov.uidai.ec.service.autosyncupload.PacketSkipReason;
import in.gov.uidai.ec.service.autosyncupload.PacketStatus;
import in.gov.uidai.ec.service.autosyncupload.SyncUploadStatus;
import in.gov.uidai.ec.service.packet.IPacketStatusReader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PacketStatusReader
implements IPacketStatusReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketStatusReader.class);
    private File autoSyncRootFolder;

    PacketStatusReader() {
    }

    public void setAutoSyncRootFolder(File autoSyncRootFolder) {
        this.autoSyncRootFolder = autoSyncRootFolder;
    }

    @Override
    public SyncUploadStatus getStatus(String eid, long lastCheckTime) {
        Path skipFilePath = Paths.get(this.autoSyncRootFolder.getPath(), eid, "skip.json");
        boolean isSkipped = false;
        PacketSkipReason packetSkipReason = null;
        try {
            RecoverableFile recoverableSkipFile = new RecoverableFile(skipFilePath.toString());
            isSkipped = recoverableSkipFile.exists();
            if (isSkipped) {
                packetSkipReason = this.readSkipFile(recoverableSkipFile, eid);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking if " + eid + " is skipped:", (Throwable)e);
        }
        PacketStatus packetStatus = this.getPacketStatus(eid, lastCheckTime);
        return new SyncUploadStatus(packetStatus, isSkipped, packetSkipReason);
    }

    private PacketStatus getPacketStatus(String eid, long lastCheckTime) {
        try {
            Path path = Paths.get(this.autoSyncRootFolder.getPath(), eid, "packetstatus.json");
            RecoverableFile packetStatusFile = new RecoverableFile(path.toString());
            if (packetStatusFile.lastModified() == 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error("Error reading packet status json file:" + path.toString() + " (The system cannot find the file specified)");
                }
                return null;
            }
            if (packetStatusFile.lastModified() > lastCheckTime) {
                byte[] fileInputStream = packetStatusFile.read();
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                return (PacketStatus)mapper.readValue(fileInputStream, PacketStatus.class);
            }
            return null;
        }
        catch (RecoverableFileException e) {
            LOGGER.error("Error reading packet status for " + eid + " :", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while reading data for " + eid + " : ", (Throwable)e);
        }
        return null;
    }

    private PacketSkipReason readSkipFile(RecoverableFile skipFile, String eid) {
        try {
            byte[] fileInputStream = skipFile.read();
            ObjectMapper mapper = new ObjectMapper();
            return (PacketSkipReason)mapper.readValue(fileInputStream, PacketSkipReason.class);
        }
        catch (RecoverableFileException e) {
            LOGGER.error("error occurred while reading skip file for eid: " + eid);
            LOGGER.debug("error occurred while reading skip file for eid: " + eid + ". ", (Throwable)e);
        }
        catch (JsonParseException e) {
            LOGGER.error("error occurred while parsing skip file for eid: " + eid);
            LOGGER.debug("error occurred while parsing skip file for eid: " + eid + ". ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOGGER.error("error occurred while json mapping for skip file for eid: " + eid);
            LOGGER.debug("error occurred while json mapping for skip file for eid: " + eid + ". ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("exception occurred while reading skip file for eid: " + eid);
            LOGGER.debug("exception occurred while reading skip file for eid: " + eid + ". ", (Throwable)e);
        }
        return new PacketSkipReason();
    }
}

