/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.autosyncupload;

import in.gov.uidai.ec.service.autosyncupload.EnrolmentCreationInformation;
import in.gov.uidai.ec.service.autosyncupload.PacketSkipReason;
import in.gov.uidai.ec.service.autosyncupload.PacketStatus;
import in.gov.uidai.ec.service.autosyncupload.ProcessingStatus;
import in.gov.uidai.ec.service.autosyncupload.SyncUploadStatus;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrol.EnrollmentPacketManager;
import in.gov.uidai.ec.service.enrol.IEnrolmentIDPreference;
import in.gov.uidai.ec.service.packet.IEnrolVerifyDAO;
import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.packet.IPacketStatusReader;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketStatusUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketStatusUpdater.class);
    private IPacketStatusReader packetStatusReaderForJson;
    private IPacketService packetService;
    private long lastCheckTime = 0L;
    private IEnrolmentIDPreference enrolPref;
    private EnrollmentPacketManager packetManager;
    private IEnrolVerifyDAO enrolVerifyDAO;
    private IPreSyncPreference preSyncPref;

    public void setEnrolPref(IEnrolmentIDPreference enrolPref) {
        this.enrolPref = enrolPref;
    }

    public void setPacketManager(EnrollmentPacketManager manager) {
        this.packetManager = manager;
    }

    public void setPreSyncPref(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public final void setEnrolVerifyDAO(IEnrolVerifyDAO enrolVerifyDAO) {
        this.enrolVerifyDAO = enrolVerifyDAO;
    }

    public void setPacketService(IPacketService packetService) {
        this.packetService = packetService;
    }

    public void setPacketStatusReader(IPacketStatusReader packetStatusReader) {
        this.packetStatusReaderForJson = packetStatusReader;
    }

    private void updatePacketStatus() {
        List<EnrolmentCreationInformation> enrolInfoList = this.packetService.getPacketStatusList();
        this.cleanDuplicateStatusEntries(enrolInfoList);
        HashMap<PacketStatusType, List> packetsForStatusUpdate = new HashMap<PacketStatusType, List>();
        HashMap<ProcessingStatus, List> packetsForStatusInfoUpdate = new HashMap<ProcessingStatus, List>();
        HashMap<String, PacketSkipReason> skippedPackets = new HashMap<String, PacketSkipReason>();
        HashMap<String, PacketSkipReason> notSkippedPackets = new HashMap<String, PacketSkipReason>();
        ArrayList<String> packetsTobeMarkedForDelete = new ArrayList<String>();
        for (EnrolmentCreationInformation enrolInfo : enrolInfoList) {
            String eid = enrolInfo.getEnrolId();
            SyncUploadStatus syncUploadStatus = this.packetStatusReaderForJson.getStatus(eid, this.lastCheckTime);
            PacketStatus packetInfo = syncUploadStatus.getPacketStatus();
            if (packetInfo == null) continue;
            PacketStatusType statusType = packetInfo.getStatus();
            ProcessingStatus packetStatusInfo = packetInfo.getProcessingStatus();
            if (packetStatusInfo != null && packetStatusInfo.isRejected()) {
                statusType = PacketStatusType.REJECTED;
            }
            packetsForStatusUpdate.putIfAbsent(statusType, new ArrayList());
            ((List)packetsForStatusUpdate.get((Object)statusType)).add(eid);
            if (syncUploadStatus.isSkipped()) {
                skippedPackets.put(eid, syncUploadStatus.getPacketSkipReason());
                continue;
            }
            notSkippedPackets.put(eid, new PacketSkipReason());
            if (packetStatusInfo != null) {
                packetsForStatusInfoUpdate.putIfAbsent(packetStatusInfo, new ArrayList());
                ((List)packetsForStatusInfoUpdate.get(packetStatusInfo)).add(eid);
            }
            if (!this.isEidAllowedToBeMarkedForDelete(enrolInfo, packetStatusInfo)) continue;
            packetsTobeMarkedForDelete.add(eid);
        }
        packetsForStatusUpdate.forEach((key, value) -> {
            this.packetService.updatePacketStatusForEids((List<String>)value, (PacketStatusType)((Object)key));
            this.packetService.updatePacketSummaryStatusForEids((List<String>)value, (PacketStatusType)((Object)key));
        });
        packetsForStatusInfoUpdate.forEach((key, value) -> this.packetService.updatePacketSummaryProcessingStateForEids((List<String>)value, (ProcessingStatus)key));
        if (!skippedPackets.isEmpty()) {
            this.packetService.setAutoSyncUploadSkipped(skippedPackets, true);
        }
        if (!notSkippedPackets.isEmpty()) {
            this.packetService.setAutoSyncUploadSkipped(notSkippedPackets, false);
        }
        if (!packetsForStatusUpdate.isEmpty()) {
            this.packetService.upsertLastSync(System.currentTimeMillis());
        }
        if (!packetsTobeMarkedForDelete.isEmpty()) {
            this.packetService.updatePacketStatusForEids(packetsTobeMarkedForDelete, PacketStatusType.DELETED);
            this.packetService.updatePacketSummaryStatusForEids(packetsTobeMarkedForDelete, PacketStatusType.DELETED);
        }
    }

    private boolean isEidAllowedToBeMarkedForDelete(EnrolmentCreationInformation enrolDetails, ProcessingStatus processingStatus) {
        Date pktStatusEntryDate = new Date(enrolDetails.getPacketStatusEntryDate());
        long diff = new Date().getTime() - pktStatusEntryDate.getTime();
        long days = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
        if (days > 90L) {
            return true;
        }
        if (processingStatus == null) {
            return false;
        }
        return processingStatus.isCompleted();
    }

    private void cleanDuplicateStatusEntries(List<EnrolmentCreationInformation> packetStatusList) {
        HashMap packetStatusHashMap = new HashMap();
        if (packetStatusList == null || packetStatusList.isEmpty()) {
            return;
        }
        packetStatusList.forEach(packetStatus -> packetStatusHashMap.putIfAbsent(packetStatus.getEnrolId(), packetStatus));
        packetStatusList.clear();
        packetStatusList.addAll(new ArrayList(packetStatusHashMap.values()));
    }

    public void execute() {
        try {
            this.purgePackets();
        }
        catch (Exception e) {
            LOGGER.error("Failed to purge packets. ", (Throwable)e);
        }
        LOGGER.debug("Starting packet status and processing status update");
        long checkStartTime = System.currentTimeMillis();
        this.updatePacketStatus();
        LOGGER.debug("Finished packet status update");
        this.lastCheckTime = checkStartTime;
    }

    private void purgePackets() {
        LOGGER.debug("Starting packet purge");
        HashSet<String> deletedEnrolIds = new HashSet<String>();
        deletedEnrolIds.addAll(this.packetService.findByStatus(PacketStatusType.DELETED, this.enrolPref.getPurgeTime("30d").getValue()));
        deletedEnrolIds.addAll(this.packetService.findByStatus(PacketStatusType.REJECTED, this.enrolPref.getPurgeTime("30d").getValue()));
        if (StringUtils.equalsIgnoreCase((String)this.preSyncPref.getPktIntgFailedDelete("Y"), (String)"Y")) {
            deletedEnrolIds.addAll(this.packetService.findByStatus(PacketStatusType.PKTINTG_FAILED, this.enrolPref.getPurgeTime("30d").getValue()));
            LOGGER.debug("adding integrity failed packet into delete EID list..");
        }
        deletedEnrolIds.forEach(eidStr -> {
            try {
                EID enrolId = EID.valueOf(eidStr);
                if (enrolId == null) {
                    return;
                }
                this.enrolVerifyDAO.delete((String)eidStr);
                String cidrPacket = this.packetManager.getPacketLocation(enrolId).getCanonicalPath() + ".pkt.zip";
                FileUtils.deleteQuietly((File)new File(cidrPacket));
                String autoSyncPacketFolder = this.packetManager.getAutoSyncPacketLocation(enrolId).getCanonicalPath();
                FileUtils.deleteQuietly((File)new File(autoSyncPacketFolder));
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error("error while purging packets", (Throwable)e);
                }
                LOGGER.error("error while purging packets" + e.getMessage());
            }
        });
        LOGGER.debug("Finished packet purge");
    }
}

