/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.autosyncupload;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import in.gov.uidai.ec.service.autosyncupload.ProcessingStatusType;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ProcessingStatus {
    private String packetState;
    private String packetStateDesc;
    @JsonProperty(value="rejectReason")
    private RejectReason rejectReason;
    private String timestamp;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingStatus.class);

    public ProcessingStatus() {
    }

    public ProcessingStatus(String packetState, String packetStateDesc, RejectReason rejectReason, String timestamp) {
        this.packetState = packetState;
        this.packetStateDesc = packetStateDesc;
        this.rejectReason = rejectReason;
        this.timestamp = timestamp;
    }

    public String getPacketState() {
        return this.packetState;
    }

    public String getPacketStateDesc() {
        return this.packetStateDesc;
    }

    public String getRejectReasonCode() {
        return this.rejectReason != null ? this.rejectReason.getCode() : null;
    }

    public String getRejectReasonDescription() {
        return this.rejectReason != null ? this.rejectReason.getDescription() : null;
    }

    public String getSubRejectReasonCode() {
        if (this.rejectReason == null || this.rejectReason.getSubRejectReason() == null) {
            return null;
        }
        return Arrays.stream(this.rejectReason.getSubRejectReason()).filter(code -> code != null && StringUtils.isNotBlank((String)code.getCode())).map(code -> String.valueOf(code.getCode())).collect(Collectors.joining(","));
    }

    public String getSubRejectReasonDescription() {
        if (this.rejectReason == null || this.rejectReason.getSubRejectReason() == null) {
            return null;
        }
        return Arrays.stream(this.rejectReason.getSubRejectReason()).filter(code -> code != null && StringUtils.isNotBlank((String)code.getDescription())).map(code -> String.valueOf(code.getDescription())).collect(Collectors.joining(","));
    }

    public RejectReason getRejectReason() {
        return this.rejectReason;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public long getTimestampEpoch() {
        SimpleDateFormat df = new SimpleDateFormat(ECMPDateFormats.RFC_3339_DATE_FORMAT.getFormat());
        try {
            Date date = df.parse(this.timestamp);
            return date.getTime();
        }
        catch (ParseException e) {
            LOGGER.error("invalid timestamp value found in packetstatus.json", (Throwable)e);
            return -1L;
        }
    }

    boolean isCompleted() {
        return this.packetState != null && (this.packetState.equalsIgnoreCase(ProcessingStatusType.COMPLETED.toString()) || this.packetState.equalsIgnoreCase(ProcessingStatusType.COMPLETED_PRINT_PENDING.toString()));
    }

    boolean isRejected() {
        return this.packetState != null && (this.packetState.equalsIgnoreCase(ProcessingStatusType.REJECTED.toString()) || this.packetState.equalsIgnoreCase(ProcessingStatusType.REJECTED_PRINT_PENDING.toString()));
    }

    public int hashCode() {
        return Objects.hash(this.packetState, this.packetStateDesc, this.rejectReason, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingStatus that = (ProcessingStatus)obj;
        return !(!this.packetState.equals(that.packetState) || this.packetStateDesc != null && !this.packetStateDesc.equals(that.packetStateDesc) || this.rejectReason != null && !this.rejectReason.equals(that.rejectReason) || !this.timestamp.equals(that.timestamp));
    }

    public static class RejectReason {
        private String code;
        private String description;
        @JsonProperty(value="subRejectReason")
        private SubRejectReason[] subRejectReason;

        public RejectReason() {
        }

        public RejectReason(String code, String description, SubRejectReason[] subRejectReason) {
            this.code = code;
            this.description = description;
            this.subRejectReason = subRejectReason;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public SubRejectReason[] getSubRejectReason() {
            return this.subRejectReason;
        }

        public static class SubRejectReason {
            private String code;
            private String description;

            public SubRejectReason() {
            }

            public SubRejectReason(String code, String description) {
                this.code = code;
                this.description = description;
            }

            public String getCode() {
                return this.code;
            }

            public String getDescription() {
                return this.description;
            }
        }
    }
}

