/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.biometricsauth;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BioVerificationException;
import in.gov.uidai.ec.service.biometricsauth.RDBiometricsVerification;
import in.gov.uidai.ec.service.biometricsauth.model.LeftIrisAuth;
import in.gov.uidai.ec.service.biometricsauth.model.RDAuthBiometrics;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.biometricsauth.model.SingleFingerAuth;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.TriConsumer;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.session.ISessionService;
import org.springframework.beans.factory.InitializingBean;

public class BiometricsAuthService
implements InitializingBean {
    private ISessionService sessionService;
    private EnrollmentService enrollmentService;
    private EcmpApiService ecmpApiService;
    private IResourceBundleContext ctxt;
    private IPreSyncPreference preSyncPref;
    private RDBiometricsVerification bioVerification;
    private SingleFingerAuth singleFingerAuth;
    private RDAuthBiometrics rdAuthBiometrics;
    private LeftIrisAuth leftIrisAuth;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.ctxt = ctxt;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setSessionService(ISessionService iSessionService) {
        this.sessionService = iSessionService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void afterPropertiesSet() throws Exception {
        this.singleFingerAuth = new SingleFingerAuth(this.ctxt);
        this.rdAuthBiometrics = new RDAuthBiometrics(this.ctxt);
        this.leftIrisAuth = new LeftIrisAuth(this.ctxt);
        this.bioVerification = new RDBiometricsVerification(this.sessionService, this.enrollmentService, this.ecmpApiService, this.rdAuthBiometrics);
    }

    public void verifyRDBiometricsAndUpdateSignature(AuthParamType userType, DeviceType deviceType) throws BioVerificationException {
        this.bioVerification.verifyRDBiometricsAndUpdateSignature(userType, deviceType);
    }

    public void addBiometricsVerifiedListener(TriConsumer<RDCaptureType, Signature, CaptureAttempt> delegate) {
        this.bioVerification.addBiometricsVerifiedListener(delegate);
    }

    public SingleFingerAuth getSingleFingerAuth() {
        return this.singleFingerAuth;
    }

    public RDAuthBiometrics getRdAuthBiometrics() {
        return this.rdAuthBiometrics;
    }

    public LeftIrisAuth getLeftIrisAuth() {
        return this.leftIrisAuth;
    }

    public boolean isOperatorOnboarded() {
        return this.sessionService.isOperatorOnboarded();
    }

    public boolean doesBiometricsMatchesWithLVSData() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        if (authType != null) {
            if (authType.equalsIgnoreCase(AuthParamType.FINGER.toString())) {
                return this.singleFingerAuth.isValid();
            }
            if (authType.equalsIgnoreCase(AuthParamType.IRIS.toString())) {
                return this.leftIrisAuth.isValid();
            }
            if (authType.equalsIgnoreCase(AuthParamType.BOTH.toString())) {
                return this.singleFingerAuth.isValid() && this.leftIrisAuth.isValid();
            }
        }
        return false;
    }

    public void clear() {
        if (this.singleFingerAuth != null) {
            this.singleFingerAuth.clear();
        }
        if (this.leftIrisAuth != null) {
            this.leftIrisAuth.clear();
        }
        if (this.rdAuthBiometrics != null) {
            this.rdAuthBiometrics.clearAll();
        }
    }
}

