/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.biometricsauth;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.AuthRes;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.AuthResult;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyRequest;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyResponse;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.BioVerifyResult;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.Pid;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.PidType;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.xml.Result;
import in.gov.uidai.ec.ecmpapi.xml.operatorsync.BioMetricType1;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BioExceptionType;
import in.gov.uidai.ec.service.biometricsauth.BioVerificationException;
import in.gov.uidai.ec.service.biometricsauth.model.RDAuthBiometrics;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.TriConsumer;
import in.gov.uidai.ec.service.session.ISessionService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXB;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBiometricsVerification {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDBiometricsVerification.class);
    private static final String META_UDC = "UIDAI\\:SampleClient";
    private static final String TID = "registered";
    private static final String CLIENT_TYPE = "ECMP";
    private final ISessionService sessionService;
    private final EnrollmentService enrollmentService;
    private final EcmpApiService ecmpApiService;
    private final RDAuthBiometrics rdAuth;
    private final List<TriConsumer<RDCaptureType, Signature, CaptureAttempt>> biometricsVerifiedListeners = new ArrayList<TriConsumer<RDCaptureType, Signature, CaptureAttempt>>();

    public RDBiometricsVerification(ISessionService sessionService, EnrollmentService enrollmentService, EcmpApiService ecmpApiService, RDAuthBiometrics rdAuth) {
        this.sessionService = sessionService;
        this.enrollmentService = enrollmentService;
        this.ecmpApiService = ecmpApiService;
        this.rdAuth = rdAuth;
    }

    public void fireBiometricsVerifiedListener(RDCaptureType captureType, Signature signature, CaptureAttempt captureAttempt) {
        this.biometricsVerifiedListeners.forEach(listener -> listener.accept(captureType, signature, captureAttempt));
    }

    public void addBiometricsVerifiedListener(TriConsumer<RDCaptureType, Signature, CaptureAttempt> delegate) {
        this.biometricsVerifiedListeners.add(delegate);
    }

    public void verifyRDBiometricsAndUpdateSignature(AuthParamType userType, DeviceType deviceType) throws BioVerificationException {
        String capRdPid = this.rdAuth.getCapRdPid(userType, deviceType);
        if (capRdPid == null) {
            throw new BioVerificationException(BioExceptionType.BiometricsNotProvided);
        }
        String authUid = null;
        BioVerifyResponse bioVerifyResponse = null;
        try {
            switch (userType) {
                case RESIDENT: {
                    authUid = this.enrollmentService.getDemoPersonalDetails().getAadhaarNumber().getAadhaarNumber();
                    bioVerifyResponse = this.verifyBiometrics(PidType.RESIDENT, capRdPid, authUid);
                    break;
                }
                case OPERATOR: {
                    authUid = this.sessionService.getOperatorCredentials().getUid();
                    bioVerifyResponse = this.verifyBiometrics(PidType.OPERATOR, capRdPid, authUid);
                    break;
                }
                case HOF: {
                    authUid = this.enrollmentService.getReferences().getReferenceRelative().getAadhaarNumber();
                    bioVerifyResponse = this.verifyBiometrics(PidType.RESIDENT, capRdPid, authUid);
                }
            }
        }
        catch (IOException e) {
            throw new BioVerificationException(BioExceptionType.NetworkError, e.getMessage());
        }
        if (bioVerifyResponse == null) {
            throw new BioVerificationException(BioExceptionType.ServerError);
        }
        if (bioVerifyResponse.getResult().equals((Object)Result.SUCCESS)) {
            AuthRes authResponse;
            String authRes = ((BioVerifyResult)bioVerifyResponse.getAuthResult().get(0)).getAuthResponse();
            if (authRes != null && (authResponse = (AuthRes)JAXB.unmarshal((InputStream)new ByteArrayInputStream(Base64.decode((String)authRes)), AuthRes.class)).getRet() == AuthResult.Y) {
                Signature.AuthSignature authSignature = new Signature.AuthSignature();
                authSignature.setAuthResponseBase64(authRes);
                authSignature.setAuthTxn(authResponse.getTxn());
                authSignature.setAuthUid(authUid);
                Signature signature = new Signature();
                signature.setAuthSignature(authSignature);
                this.fireBiometricsVerifiedListener(new RDCaptureType(userType, deviceType), signature, this.rdAuth.getCapturedAttempt(userType, deviceType));
            }
        } else {
            String errorMessage = null;
            if (bioVerifyResponse.getAuthResult() != null && ((BioVerifyResult)bioVerifyResponse.getAuthResult().get(0)).getAuthResponse() != null) {
                String authRes = ((BioVerifyResult)bioVerifyResponse.getAuthResult().get(0)).getAuthResponse();
                AuthResult authResult = ((AuthRes)JAXB.unmarshal((InputStream)new ByteArrayInputStream(Base64.decode((String)authRes)), AuthRes.class)).getRet();
                if (authResult != AuthResult.Y) {
                    errorMessage = ((BioVerifyResult)bioVerifyResponse.getAuthResult().get(0)).getErrorMessage();
                    throw new BioVerificationException(BioExceptionType.AuthFailed, errorMessage);
                }
                throw new BioVerificationException(BioExceptionType.ServerError);
            }
            if (bioVerifyResponse.getErrorCode() != null) {
                if (bioVerifyResponse.getErrorCode().equals("CLIENT_ERROR")) {
                    switch (userType) {
                        case RESIDENT: 
                        case OPERATOR: 
                        case HOF: {
                            errorMessage = "Invalid " + userType.toString();
                            break;
                        }
                        default: {
                            errorMessage = "Invalid Biometrics.";
                            break;
                        }
                    }
                } else if (bioVerifyResponse.getErrorCode().equals("SERVER_ERROR")) {
                    throw new BioVerificationException(BioExceptionType.ServerError);
                }
            } else {
                errorMessage = "Error While Processing Bio Verify Request. Please try again.";
            }
            if (errorMessage != null) {
                throw new BioVerificationException(BioExceptionType.InvalidBiometrics, errorMessage);
            }
        }
    }

    private BioVerifyResponse verifyBiometrics(PidType pidType, String capRdPid, String uid) throws IOException {
        Pid pid = new Pid();
        pid.setUid(uid);
        pid.setPidType(pidType);
        pid.setOad(Base64.encode((byte[])capRdPid.getBytes()));
        pid.setUdc(META_UDC);
        pid.setTid(TID);
        pid.setModality(BioMetricType1.MULTI_FINGER_MODALITY);
        BioVerifyRequest bioverifyRequest = new BioVerifyRequest();
        bioverifyRequest.getPid().add(pid);
        bioverifyRequest.setClientType(CLIENT_TYPE);
        return this.ecmpApiService.verifyBiometrics(bioverifyRequest, true);
    }
}

