/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.biometricsauth.model;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.session.model.MsgKeysLogin;
import in.gov.uidai.qssitv.model.BiometricPosition;

public class LeftIrisAuth
extends ModelBase<LeftIrisAuth> {
    private CaptureAttempt captureAttempt;
    private BiometricPosition biometricPosition;
    private String authError;
    private boolean isAuthValid;

    public LeftIrisAuth(IResourceBundleContext rbCtx) {
        super(rbCtx);
        this.validate();
    }

    public void setCaptureAttempt(CaptureAttempt captureAttempt, BiometricPosition biometricPosition) {
        this.captureAttempt = captureAttempt;
        this.biometricPosition = biometricPosition;
    }

    public void setAuthValid(boolean authValid) {
        this.isAuthValid = authValid;
        this.validate();
        this.fireChangeEvent(this);
    }

    public CaptureAttempt getCaptureAttempt() {
        return this.captureAttempt;
    }

    public BiometricPosition getBiometricPosition() {
        return this.biometricPosition;
    }

    public String getAuthError() {
        return this.authError;
    }

    public void clear() {
        this.biometricPosition = null;
        this.captureAttempt = null;
        this.validate();
        this.fireChangeEvent(this);
    }

    private void validate() {
        MsgKeysLogin authErrorMsgKey = null;
        if (this.captureAttempt == null) {
            authErrorMsgKey = MsgKeysLogin.BIO_NOT_PROVIDED;
        } else if (!this.isAuthValid) {
            authErrorMsgKey = MsgKeysLogin.FAILED_BIO;
        }
        this.authError = this.getMessage((Object)authErrorMsgKey, new Object[0]);
        this.setValid(this.authError == null);
    }
}

