/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.biometricsauth.model;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCapturedData;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.session.model.MsgKeysLogin;
import java.util.HashMap;
import java.util.Map;

public class RDAuthBiometrics
extends ModelBase<RDAuthBiometrics> {
    private final Map<RDCaptureType, RDCapturedData> capturedAttempt = new HashMap<RDCaptureType, RDCapturedData>();
    private final Map<RDCaptureType, String> authError = new HashMap<RDCaptureType, String>();

    public RDAuthBiometrics(IResourceBundleContext rbCtx) {
        super(rbCtx);
    }

    public CaptureAttempt getCapturedAttempt(AuthParamType userType, DeviceType deviceType) {
        RDCapturedData rdCapturedData = this.capturedAttempt.get(new RDCaptureType(userType, deviceType));
        return rdCapturedData != null ? rdCapturedData.getCapturedAttempt() : null;
    }

    public String getCapRdPid(AuthParamType userType, DeviceType deviceType) {
        if (this.capturedAttempt.get(new RDCaptureType(userType, deviceType)) == null) {
            return null;
        }
        return this.capturedAttempt.get(new RDCaptureType(userType, deviceType)).getCapRdPid();
    }

    public String getAuthError(AuthParamType userType, DeviceType deviceType) {
        return this.authError.get(new RDCaptureType(userType, deviceType));
    }

    public void clear(AuthParamType userType, DeviceType deviceType) {
        this.capturedAttempt.put(new RDCaptureType(userType, deviceType), null);
        this.validate(userType, deviceType);
    }

    public void clearAll() {
        this.capturedAttempt.clear();
        this.authError.clear();
    }

    public void setCapturedAttempt(AuthParamType type, DeviceType deviceType, CaptureAttempt capturedAttempt, String capRdPid) {
        this.capturedAttempt.put(new RDCaptureType(type, deviceType), new RDCapturedData(capturedAttempt, capRdPid));
        this.validate(type, deviceType);
    }

    private void validate(AuthParamType userType, DeviceType deviceType) {
        MsgKeysLogin authErrorMsgKey = null;
        RDCaptureType rdCaptureType = new RDCaptureType(userType, deviceType);
        if (this.capturedAttempt.get(rdCaptureType) == null || this.capturedAttempt.get(rdCaptureType).getCapRdPid() == null || this.capturedAttempt.get(rdCaptureType).getCapturedAttempt() == null) {
            authErrorMsgKey = MsgKeysLogin.BIO_NOT_PROVIDED;
        }
        this.authError.put(rdCaptureType, this.getMessage((Object)authErrorMsgKey, new Object[0]));
        this.setValid(this.isCaptureValid(userType, deviceType));
    }

    public boolean isCaptureValid(AuthParamType userType, DeviceType deviceType) {
        RDCapturedData rdCapturedData = this.capturedAttempt.get(new RDCaptureType(userType, deviceType));
        return this.getAuthError(userType, deviceType) == null && rdCapturedData != null && rdCapturedData.getCapRdPid() != null && rdCapturedData.getCapturedAttempt() != null;
    }
}

