/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.document;

import in.gov.uidai.ec.oauthapi.json.mda.roiapi.LabelDetail;
import in.gov.uidai.ec.service.document.BoundingBox;
import in.gov.uidai.ec.service.document.DocumentFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Annotation {
    private String label;
    private String partLabel;
    private String displayName;
    private DocumentFields.DocumentFieldType fieldType;
    private BoundingBox boundingBox;
    private Integer pageIndex;
    private boolean isMandatory;

    private Annotation() {
    }

    public static List<Annotation> getAnnotations(List<LabelDetail> labelList) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        boolean totalLines = true;
        for (LabelDetail labelDetail : labelList) {
            Annotation annotation = new Annotation();
            annotation.label = labelDetail.getLabelName();
            annotation.partLabel = labelDetail.getPartLabelName();
            annotation.displayName = labelDetail.getPartLabelName();
            annotation.setMandatory(true);
            annotations.add(annotation);
        }
        return annotations;
    }

    private static String getDisplayName(String label, int labelLineNumber) {
        return label + " Line " + labelLineNumber;
    }

    public DocumentFields.DocumentFieldType getFieldType() {
        return this.fieldType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPartLabel() {
        return this.partLabel;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.isMandatory = mandatory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation that = (Annotation)o;
        return this.isMandatory == that.isMandatory && Objects.equals(this.label, that.label) && Objects.equals(this.partLabel, that.partLabel) && Objects.equals(this.displayName, that.displayName) && this.fieldType == that.fieldType && Objects.equals(this.boundingBox, that.boundingBox) && Objects.equals(this.pageIndex, that.pageIndex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label, this.partLabel, this.displayName, this.fieldType, this.boundingBox, this.pageIndex, this.isMandatory});
    }

    public String toString() {
        return "Annotation{label='" + this.label + '\'' + ", partLabel='" + this.partLabel + '\'' + ", displayName='" + this.displayName + '\'' + ", fieldType=" + (Object)((Object)this.fieldType) + ", boundingBox=" + this.boundingBox + ", pageIndex=" + this.pageIndex + ", isMandatory=" + this.isMandatory + '}';
    }
}

