/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.document;

import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.CitizenShipType;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ModeType;
import java.util.ArrayList;
import java.util.List;

public class Document {
    private final String documentId;
    private final String documentName;
    private final DocumentType docType;
    private final ModeType modeType;
    private final AgeGroup ageGroup;
    private CitizenShipType citizenShipType;
    private String foreignType;
    private int scanPages = 1;
    private boolean isVerifiable = false;
    private boolean digilockerAvailability = false;
    private List<String> captureFields = new ArrayList<String>();

    public Document(String documentId, String documentName, DocumentType docType, ModeType modeType, AgeGroup ageGroup, CitizenShipType citizenShipType, int scanPages, List<String> roiList) {
        this(documentId, documentName, docType, modeType, ageGroup, citizenShipType, scanPages);
        this.captureFields = roiList;
    }

    public Document(String documentId, String documentName, DocumentType docType, ModeType modeType, AgeGroup ageGroup, CitizenShipType citizenShipType, int scanPages) {
        this(documentId, documentName, docType, modeType, ageGroup, citizenShipType);
        this.scanPages = scanPages;
    }

    public Document(String documentId, String documentName, DocumentType docType, ModeType modeType, AgeGroup ageGroup, CitizenShipType citizenShipType) {
        this.documentId = documentId;
        this.documentName = documentName;
        this.docType = docType;
        this.modeType = modeType;
        this.ageGroup = ageGroup;
        this.citizenShipType = citizenShipType;
    }

    public Document(String documentId, String documentName, DocumentType docType, ModeType modeType, AgeGroup ageGroup, String foreignType, int scanPages) {
        this.documentId = documentId;
        this.documentName = documentName;
        this.docType = docType;
        this.modeType = modeType;
        this.ageGroup = ageGroup;
        this.foreignType = foreignType;
        this.scanPages = scanPages;
    }

    public Document(String documentId, String documentName, DocumentType docType, ModeType modeType, AgeGroup ageGroup, String foreignType, int scanPages, boolean digilockerAvailability, boolean isVerifiable) {
        this.documentId = documentId;
        this.documentName = documentName;
        this.docType = docType;
        this.modeType = modeType;
        this.ageGroup = ageGroup;
        this.foreignType = foreignType;
        this.scanPages = scanPages;
        this.digilockerAvailability = digilockerAvailability;
        this.isVerifiable = isVerifiable;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public DocumentType getDocType() {
        return this.docType;
    }

    public ModeType getModeType() {
        return this.modeType;
    }

    public AgeGroup getAgeGroup() {
        return this.ageGroup;
    }

    public String getForeignType() {
        return this.foreignType;
    }

    public CitizenShipType getCitizenShipType() {
        return this.citizenShipType;
    }

    public boolean belongsToCitizenShipType(CitizenShipType type) {
        return this.citizenShipType == CitizenShipType.NRC_AND_NON_NRC || this.citizenShipType == type;
    }

    public int getScanPages() {
        return this.scanPages;
    }

    public List<String> getRegionsOfInterest() {
        return this.captureFields;
    }

    public String toString() {
        return String.format("(%s, %s, %s, %s, %s, %s, %d, %b %b),", new Object[]{this.documentId, this.documentName, this.modeType, this.docType, this.ageGroup, this.citizenShipType, this.scanPages, this.digilockerAvailability, this.isVerifiable});
    }
}

