/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.document;

import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryList;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.NationalityType;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.ProofDetails;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.CitizenShipType;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.IDocumentService;
import in.gov.uidai.ec.service.document.ModeType;
import in.gov.uidai.ec.service.document.ProofData;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.VerifiableDocument;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.session.ISessionService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DocumentService
implements IDocumentService {
    private ISessionService sessionService;

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Override
    public Map<String, DigilockerDocument> getDigilockerList() {
        return null;
    }

    @Override
    public Map<String, VerifiableDocument> getVerifiableDocumentsList() {
        return null;
    }

    @Override
    public Map<String, ProofDetails> getMdaOnlineDocumentsMap() {
        return null;
    }

    @Override
    public List<ProofDocument> getIdentityProofs(ModeType modeType, AgeGroup ageGroup, boolean isNRI, boolean isDocBasedChildEnrollment, String foreignType) {
        List<ProofDocument> identityProof = isNRI ? this.getDocumentByName(this.getDocuments(DocumentType.POI, modeType, ageGroup), "Indian Passport") : this.getDocuments(DocumentType.POI, modeType, ageGroup);
        return identityProof;
    }

    @Override
    public List<ProofDocument> getAddressProofs(ModeType modeType, AgeGroup ageGroup, boolean isForeignAddress, boolean isDocBasedChildEnrollment, String foreignType) {
        return this.getDocuments(DocumentType.POA, modeType, ageGroup);
    }

    @Override
    public List<ProofDocument> getHOFSupportingDocs(ModeType modeType, AgeGroup ageGroup, boolean isNRI) {
        List<ProofDocument> identityProof = isNRI && ageGroup.equals((Object)AgeGroup.BELOW5) ? this.getDocumentByName(this.getDocuments(DocumentType.HOF, modeType, ageGroup), "Indian Passport") : this.getDocuments(DocumentType.HOF, modeType, ageGroup);
        return identityProof;
    }

    @Override
    public List<ProofDocument> getDobProofs(ModeType modeType, AgeGroup ageGroup, boolean isNRI, boolean isForeign, String foreignType) {
        List<ProofDocument> identityProof;
        ArrayList<ProofDocument> pobDocList = new ArrayList<ProofDocument>();
        if (isNRI && ageGroup.equals((Object)AgeGroup.BELOW5)) {
            pobDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POB, modeType, ageGroup), "Indian Passport"));
            pobDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POB, modeType, ageGroup), "Birth Certificate issued under the Registration of Births and Deaths Act"));
            identityProof = pobDocList;
        } else if (!isNRI && ageGroup.equals((Object)AgeGroup.BELOW5)) {
            pobDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POB, modeType, ageGroup), "Birth Certificate issued under the Registration of Births and Deaths Act"));
            identityProof = pobDocList;
        } else {
            identityProof = this.getDocuments(DocumentType.POB, modeType, ageGroup);
        }
        return identityProof;
    }

    @Override
    public List<ProofDocument> getRelationProofs(ModeType modeType, AgeGroup ageGroup, RelationshipType relationshipType, boolean isNRI, String foreignType) {
        return this.getDocuments(DocumentType.POR, modeType, ageGroup);
    }

    @Override
    public List<ProofDocument> getForeignProofs(ModeType modeType, AgeGroup ageGroup, String foreignType) {
        return this.getDocuments(DocumentType.POF, modeType, ageGroup);
    }

    @Override
    public Document getDocument(DocumentType documentType, String documentName) {
        return ProofData.documents.stream().filter(d -> d.getDocumentName().equals(documentName) && d.getDocType().equals((Object)documentType)).findFirst().orElse(null);
    }

    @Override
    public ProofDocument getDefaultSelect() {
        return new ProofDocument("", "Select");
    }

    @Override
    public NationalityType[] getNationalityTypes() {
        return null;
    }

    @Override
    public CountryList[] getCountryList() {
        return null;
    }

    private List<ProofDocument> getDocumentByName(List<ProofDocument> documents, String documentName) {
        return documents.stream().filter(p -> p.getDocName().equals(documentName)).collect(Collectors.toList());
    }

    private List<ProofDocument> getDocuments(DocumentType documentType, ModeType modeType, AgeGroup ageGroup) {
        Comparator docNameComparator = (o1, o2) -> o1.getDocName().compareToIgnoreCase(o2.getDocName());
        TreeSet uniqueDocuments = new TreeSet(docNameComparator);
        ProofData.documents.stream().filter(p -> p.getDocType().equals((Object)documentType) && this.belongsToEnrollmentType(modeType, (Document)p) && this.belongsToAgeGroup(ageGroup, (Document)p) && p.belongsToCitizenShipType(this.getCitizenShipType())).forEach(p -> uniqueDocuments.add(new ProofDocument(p.getDocumentId(), p.getDocumentName())));
        return new ArrayList<ProofDocument>(uniqueDocuments);
    }

    private CitizenShipType getCitizenShipType() {
        return this.sessionService.isNrcMandatory() ? CitizenShipType.NRC : CitizenShipType.NON_NRC;
    }

    private boolean belongsToEnrollmentType(ModeType modeType, Document p) {
        return p.getModeType().equals((Object)modeType) || p.getModeType().equals((Object)ModeType.NEW_AND_UPDATE);
    }

    private boolean belongsToAgeGroup(AgeGroup ageGroup, Document p) {
        if (ageGroup == AgeGroup.BETWEEN5TO18) {
            return p.getAgeGroup().equals((Object)AgeGroup.BETWEEN5TO18);
        }
        if (ageGroup == AgeGroup.ABOVE18) {
            return p.getAgeGroup().equals((Object)AgeGroup.ABOVE18);
        }
        if (ageGroup == AgeGroup.BELOW5) {
            return p.getAgeGroup().equals((Object)AgeGroup.BELOW5);
        }
        return p.getAgeGroup().equals((Object)AgeGroup.ABOVE18);
    }

    public int getPageCountForScan(String docName, DocumentType docType) {
        Document document = ProofData.documents.stream().filter(d -> d.getDocumentName().equals(docName) && d.getDocType().equals((Object)docType)).findFirst().orElse(null);
        if (document != null) {
            return document.getScanPages();
        }
        return 1;
    }
}

