/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.document;

import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.oauthapi.OauthGWService;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.brnapi.state.StateData;
import in.gov.uidai.ec.oauthapi.json.brnapi.state.StatesList;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryList;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryListResponse;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.NationalityType;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.NationalityTypeResponse;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.ProofDetails;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.ProofDocumentResponse;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.LabelDetail;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.OnlineRoiCacheService;
import in.gov.uidai.ec.protobuf.UcDocumentServiceProto;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.CitizenShipType;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.IDocumentService;
import in.gov.uidai.ec.service.document.ModeType;
import in.gov.uidai.ec.service.document.ProofData;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.VerifiableDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.ForeignDetail;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineDocumentService
implements IDocumentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineDocumentService.class);
    private ISessionService sessionService;
    private OauthGWService oauthGWApiService;
    private OnlineRoiCacheService onlineRoiCacheService;
    private NationalityType[] nationalityTypes;
    private CountryList[] countryLists;

    public void setOnlineRoiCacheService(OnlineRoiCacheService onlineRoiCacheService) {
        this.onlineRoiCacheService = onlineRoiCacheService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setOauthGWApiService(OauthGWService oauthGWApiService) {
        this.oauthGWApiService = oauthGWApiService;
    }

    public void setProofDocuments(String foreignType, String modeType, String ageGroup) throws OnlineGatewayException {
        LOGGER.info("Populating documents");
        if (ProofData.onlineDigilockerDocuments.isEmpty()) {
            this.populateDigilockerProofDocuments();
        }
        if (ProofData.onlineVerifiableDocuments.isEmpty()) {
            this.populateVerifiableProofDocuments();
        }
        if (!this.isDocumentPresent(foreignType, modeType, ageGroup)) {
            this.populateProofDocuments(foreignType, modeType, ageGroup);
        }
        LOGGER.info("Proof Documents populated successfully");
    }

    public void setBrnStates() throws OnlineGatewayException {
        LOGGER.info("Populating brn state list");
        if (StateData.onlineDocuments.size() == 0) {
            this.populateStateList();
        } else {
            LOGGER.info("Brn State List already fetched for online update");
        }
    }

    public boolean isDocumentPresent(String foreignType, String modeType, String ageGroup) {
        return ProofData.onlineDocuments.size() != 0 && !ProofData.onlineDocuments.stream().noneMatch(d -> d.getForeignType().equals(foreignType) && d.getAgeGroup().toString().equals(ageGroup) && d.getModeType().toString().equals(modeType));
    }

    public void setForeignNationalities() throws OnlineGatewayException {
        LOGGER.info("Populating foreign nationalities.");
        if (this.nationalityTypes == null || this.nationalityTypes.length == 0) {
            this.populateForeignTypes();
            LOGGER.info("Foreign Type List populated successfully");
        } else {
            LOGGER.info("Foreign Type List not populated / already present");
        }
        if (this.countryLists == null || this.countryLists.length == 0) {
            this.populateCountries();
            LOGGER.info("Country List populated successfully");
        } else {
            LOGGER.info("Country List not populated / already present");
        }
    }

    private void populateStateList() throws OnlineGatewayException {
        StatesList statesList = this.getBrnSates();
        if (statesList.isSuccess()) {
            StateData.onlineDocuments.addAll(statesList.getBrnStates());
            LOGGER.info("Brn State List populated successfully");
        } else {
            LOGGER.info("Brn State List not populated");
        }
    }

    private void populateForeignTypes() throws OnlineGatewayException {
        NationalityTypeResponse foreignTypes = this.getForeignTypes();
        if (foreignTypes.getData().getNationalityTypeList() == null || foreignTypes.getData().getNationalityTypeList().length == 0) {
            throw new OnlineGatewayException(ErrorCodes.UC_MDA_001.getReason(), ErrorCodes.UC_MDA_001.getReason(), ErrorCodes.UC_MDA_001.getErrorCode());
        }
        this.nationalityTypes = foreignTypes.getData().getNationalityTypeList();
    }

    private void populateCountries() throws OnlineGatewayException {
        CountryListResponse countryListResponse = this.getCountries();
        if (countryListResponse.getError() != null && countryListResponse.getError().length != 0) {
            throw new OnlineGatewayException(ErrorCodes.UC_MDA_002.getReason(), ErrorCodes.UC_MDA_002.getReason(), countryListResponse.getError()[0].getExtensions().getErrorCode());
        }
        if (countryListResponse.getData() == null || countryListResponse.getData().getCountryLists() == null || countryListResponse.getData().getCountryLists().length == 0) {
            throw new OnlineGatewayException(ErrorCodes.UC_MDA_002.getReason(), ErrorCodes.UC_MDA_002.getReason(), ErrorCodes.UC_MDA_002.getErrorCode());
        }
        this.countryLists = countryListResponse.getData().getCountryLists();
        Arrays.sort(this.countryLists);
    }

    @Override
    public NationalityType[] getNationalityTypes() {
        return this.nationalityTypes;
    }

    @Override
    public CountryList[] getCountryList() {
        if (this.countryLists == null || this.countryLists.length == 0) {
            try {
                this.populateCountries();
            }
            catch (OnlineGatewayException e) {
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
            }
        }
        return this.countryLists;
    }

    private void populateProofDocuments(String foreignType, String modeType, String ageGroup) throws OnlineGatewayException {
        ProofDocumentResponse proofDocumentResponse;
        if (foreignType.equalsIgnoreCase("INDIAN")) {
            proofDocumentResponse = this.getProofDocuments(ageGroup, foreignType, modeType);
            this.handleError(proofDocumentResponse);
            this.putDocuments(proofDocumentResponse, foreignType);
        } else {
            proofDocumentResponse = this.getForeignProofDocuments(foreignType, modeType, "POA", ageGroup);
            this.handleError(proofDocumentResponse);
            this.putDocuments(proofDocumentResponse, foreignType);
            proofDocumentResponse = this.getForeignProofDocuments(foreignType, modeType, "POI", ageGroup);
            this.handleError(proofDocumentResponse);
            this.putDocuments(proofDocumentResponse, foreignType);
            proofDocumentResponse = this.getForeignProofDocuments(foreignType, modeType, "POF", ageGroup);
            this.handleError(proofDocumentResponse);
            this.putDocuments(proofDocumentResponse, foreignType);
        }
        if (proofDocumentResponse.getData() == null) {
            throw new OnlineGatewayException(ErrorCodes.UC_MDA_003.getReason(), ErrorCodes.UC_MDA_003.getReason(), ErrorCodes.UC_MDA_003.getErrorCode());
        }
    }

    private void handleError(ProofDocumentResponse proofDocumentResponse) {
        if (proofDocumentResponse != null && proofDocumentResponse.getError() != null && proofDocumentResponse.getError().length != 0) {
            String errorMessage = proofDocumentResponse.getError()[0].getExtensions().getErrorDescription();
            String errorCode = proofDocumentResponse.getError()[0].getExtensions().getErrorCode();
            OnlineGatewayException exception = OnlineGatewayException.getClientException((String)errorCode, (String)errorMessage, (String)this.oauthGWApiService.getTransactionId(), (Exception)new Exception(errorMessage));
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), proofDocumentResponse.getError()[0].getExtensions().getErrorCode(), new String[0]);
            throw exception;
        }
        if (proofDocumentResponse != null && proofDocumentResponse.getData() == null) {
            throw new OnlineGatewayException(ErrorCodes.UC_MDA_003.getReason(), ErrorCodes.UC_MDA_003.getReason(), ErrorCodes.UC_MDA_003.getErrorCode());
        }
    }

    private void putDocuments(ProofDocumentResponse proofDocumentResponse, String foreignType) {
        ProofDetails[] proofDetails;
        for (ProofDetails proofDetail : proofDetails = proofDocumentResponse.getData().getProofDetails()) {
            ProofData.mdaOnlineDocumentsMap.put(proofDetail.getDocumentId(), proofDetail);
            for (int i = 0; i < proofDetail.getDocumentUseCase().length; ++i) {
                try {
                    if (proofDetail.getDocumentUseCase()[i].isActiveStatus()) {
                        ProofData.onlineDocuments.add(new Document(proofDetail.getDocumentId(), proofDetail.getDocumentName(), DocumentType.fromValue(proofDetail.getDocumentUseCase()[i].getDocType()), ModeType.valueOf(proofDetail.getDocumentUseCase()[i].getDocMode()), AgeGroup.valueOf(proofDetail.getDocumentUseCase()[i].getDocAgeGroup()), foreignType, Integer.parseInt(proofDetail.getNumOfPages()), proofDetail.isDigilockerAvailability(), proofDetail.isVerifiable()));
                        LOGGER.debug("Added document {} successfully", (Object)proofDetail.getDocumentId());
                        continue;
                    }
                    LOGGER.debug("Document {} is inactive", (Object)proofDetail.getDocumentId());
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error populating document : " + e.getMessage());
                    LOGGER.debug("Error populating document : " + e.getMessage());
                    TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_183.getErrorCode(), new String[0]);
                }
            }
        }
    }

    private void populateDigilockerProofDocuments() throws OnlineGatewayException {
        GrpcService.getInst().fetchDocumentDetails(this.oauthGWApiService.getGatewayPreference().getGrpcServicesUrl(), this.oauthGWApiService.getTransactionId(), response -> {
            LOGGER.info("Digilocker proof documents populated successfully");
            response.getDocumentDetailsList().forEach(documentDetail -> ProofData.onlineDigilockerDocuments.put(documentDetail.getDocumentCode(), new DigilockerDocument(documentDetail.getDocumentCode(), documentDetail.getIssuerType(), documentDetail.getFormFieldsList(), documentDetail.getSourceFormFieldList())));
        }, throwable -> LOGGER.info("Digilocker proof documents failed to populate"));
    }

    private void populateVerifiableProofDocuments() throws OnlineGatewayException {
        GrpcService.getInst().fetchAllVerifiableDocumentDetails(response -> {
            LOGGER.info("Verifiable proof documents populated successfully");
            response.getVerifyDocumentDetailsList().forEach(documentDetail -> ProofData.onlineVerifiableDocuments.put(documentDetail.getDocumentCode(), new VerifiableDocument(documentDetail.getDocumentCode(), documentDetail.getIssuerType(), documentDetail.getFormFieldsList(), documentDetail.getSourceFormFieldList())));
        }, throwable -> LOGGER.info("Verifiable proof documents failed to populate"));
    }

    @Override
    public Map<String, DigilockerDocument> getDigilockerList() {
        return ProofData.onlineDigilockerDocuments;
    }

    @Override
    public Map<String, VerifiableDocument> getVerifiableDocumentsList() {
        return ProofData.onlineVerifiableDocuments;
    }

    @Override
    public Map<String, ProofDetails> getMdaOnlineDocumentsMap() {
        return ProofData.mdaOnlineDocumentsMap;
    }

    public ProofDocumentResponse getProofDocuments(String ageGroup, String foreignType, String mode) throws OnlineGatewayException {
        return this.oauthGWApiService.proofDocumentRequestSubmit(String.format("{\"query\":\"query {proofDetails (ageGroups: %s, docNationalities: %s, enrolmentModes: %s){docId,docName,numPages,docUseCase {docType,docMode,docAgeGroup,activeStatus}, isVerifiable, digilockerAvailability}}\"}", ageGroup, foreignType, mode));
    }

    public ProofDocumentResponse getForeignProofDocuments(String foreignType, String mode, String type, String ageGroup) throws OnlineGatewayException {
        return this.oauthGWApiService.proofDocumentRequestSubmit(String.format("{\"query\":\"query {proofDetails(docNationalities: %s, enrolmentModes: %s, docTypes: %s, ageGroups: %s) {docId,docName,numPages,docUseCase {docType,docMode,docAgeGroup,activeStatus}}}\"}", foreignType, mode, type, ageGroup));
    }

    public StatesList getBrnSates() throws OnlineGatewayException {
        return this.oauthGWApiService.brnStateListSubmit();
    }

    private NationalityTypeResponse getForeignTypes() throws OnlineGatewayException {
        return this.oauthGWApiService.getNationalityTypeList("{\"query\":\"query {nationalityTypeList {nationalityTypeCode, nationalityTypeName}}\"}");
    }

    private CountryListResponse getCountries() throws OnlineGatewayException {
        return this.oauthGWApiService.getCountries("{\"query\":\"query {countryList {active, countryCode, countryName}}\"}");
    }

    public List<LabelDetail> getRoiLables(String docType, String docId) throws OnlineGatewayException {
        return this.onlineRoiCacheService.getRoiLables(docType, docId);
    }

    @Override
    public List<ProofDocument> getIdentityProofs(ModeType modeType, AgeGroup ageGroup, boolean isNRI, boolean isDocBasedChildEnrollment, String foreignType) {
        List<ProofDocument> identityProof = isNRI ? this.getDocumentByName(this.getDocuments(DocumentType.POI, modeType, ageGroup, foreignType), "Indian Passport") : (isDocBasedChildEnrollment && ageGroup.equals((Object)AgeGroup.BELOW5) ? this.getDocumentByName(this.getDocuments(DocumentType.POI, modeType, ageGroup, foreignType), "Superintendent/ Warden/Matron /Head of Institution of recognised shelter homes/ orphanages") : this.getDocuments(DocumentType.POI, modeType, ageGroup, foreignType));
        return identityProof;
    }

    @Override
    public List<ProofDocument> getAddressProofs(ModeType modeType, AgeGroup ageGroup, boolean isForeignAddress, boolean isDocBasedChildEnrollment, String foreignType) {
        List<ProofDocument> addressProof;
        ArrayList<ProofDocument> poaDocList = new ArrayList<ProofDocument>();
        if (isForeignAddress) {
            poaDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POA, modeType, ageGroup, foreignType), "Indian Passport"));
            addressProof = poaDocList;
        } else {
            addressProof = isDocBasedChildEnrollment && ageGroup.equals((Object)AgeGroup.BELOW5) ? this.getDocumentByName(this.getDocuments(DocumentType.POA, modeType, ageGroup, foreignType), "Superintendent/ Warden/Matron /Head of Institution of recognised shelter homes/ orphanages") : this.getDocuments(DocumentType.POA, modeType, ageGroup, foreignType);
        }
        return addressProof;
    }

    @Override
    public List<ProofDocument> getHOFSupportingDocs(ModeType modeType, AgeGroup ageGroup, boolean isNRI) {
        return this.getDocuments(DocumentType.HOF, modeType, ageGroup, "");
    }

    @Override
    public List<ProofDocument> getDobProofs(ModeType modeType, AgeGroup ageGroup, boolean isNRI, boolean isForeignAddress, String foreignType) {
        List<ProofDocument> identityProof;
        ArrayList<ProofDocument> pobDocList = new ArrayList<ProofDocument>();
        if (isNRI) {
            pobDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POB, modeType, ageGroup, foreignType), "Indian Passport"));
            if (!isForeignAddress) {
                pobDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POB, modeType, ageGroup, foreignType), "Birth Certificate issued under the Registration of Births and Deaths Act"));
            }
            identityProof = pobDocList;
        } else if (ageGroup.equals((Object)AgeGroup.BELOW5)) {
            pobDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POB, modeType, ageGroup, foreignType), "Birth Certificate issued under the Registration of Births and Deaths Act"));
            identityProof = pobDocList;
        } else {
            identityProof = this.getDocuments(DocumentType.POB, modeType, ageGroup, foreignType);
        }
        return identityProof;
    }

    @Override
    public List<ProofDocument> getRelationProofs(ModeType modeType, AgeGroup ageGroup, RelationshipType relationshipType, boolean isNRI, String foreignType) {
        ArrayList<ProofDocument> relationProof;
        ArrayList<ProofDocument> porDocList = new ArrayList<ProofDocument>();
        if (relationshipType == RelationshipType.LEGAL_GUARDIAN) {
            porDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POR, modeType, ageGroup, foreignType), "Document to prove legal guardianship"));
            relationProof = porDocList;
        } else if (isNRI) {
            porDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POR, modeType, ageGroup, foreignType), "Indian Passport"));
            relationProof = porDocList;
        } else {
            porDocList.addAll(this.getDocumentByName(this.getDocuments(DocumentType.POR, modeType, ageGroup, foreignType), "Birth Certificate issued under the Registration of Births and Deaths Act"));
            relationProof = porDocList;
        }
        return relationProof;
    }

    @Override
    public List<ProofDocument> getForeignProofs(ModeType modeType, AgeGroup ageGroup, String foreignType) {
        return this.getDocuments(DocumentType.POF, modeType, ageGroup, foreignType);
    }

    @Override
    public Document getDocument(DocumentType documentType, String documentName) {
        return ProofData.onlineDocuments.stream().filter(d -> d.getDocumentName().equals(documentName) && d.getDocType().equals((Object)documentType)).findFirst().orElse(null);
    }

    @Override
    public ProofDocument getDefaultSelect() {
        return new ProofDocument("", "Select");
    }

    private List<ProofDocument> getDocumentByName(List<ProofDocument> documents, String documentName) {
        return documents.stream().filter(p -> p.getDocName().contains(documentName)).collect(Collectors.toList());
    }

    private List<ProofDocument> getDocuments(DocumentType documentType, ModeType modeType, AgeGroup ageGroup, String foreignType) {
        Comparator docNameComparator = (o1, o2) -> o1.getDocName().compareToIgnoreCase(o2.getDocName());
        TreeSet uniqueDocuments = new TreeSet(docNameComparator);
        ProofData.onlineDocuments.stream().filter(p -> p.getDocType().equals((Object)documentType) && this.belongsToEnrollmentType(modeType, (Document)p) && this.belongsToAgeGroup(ageGroup, (Document)p) && p.getForeignType().equals(foreignType)).forEach(p -> uniqueDocuments.add(new ProofDocument(p.getDocumentId(), p.getDocumentName())));
        return new ArrayList<ProofDocument>(uniqueDocuments);
    }

    private CitizenShipType getCitizenShipType() {
        return this.sessionService.isNrcMandatory() ? CitizenShipType.NRC : CitizenShipType.NON_NRC;
    }

    private boolean belongsToEnrollmentType(ModeType modeType, Document p) {
        return p.getModeType().equals((Object)modeType) || p.getModeType().equals((Object)ModeType.NEW_AND_UPDATE);
    }

    private boolean belongsToAgeGroup(AgeGroup ageGroup, Document p) {
        if (ageGroup == AgeGroup.BETWEEN5TO18) {
            return p.getAgeGroup().equals((Object)AgeGroup.BETWEEN5TO18);
        }
        if (ageGroup == AgeGroup.ABOVE18) {
            return p.getAgeGroup().equals((Object)AgeGroup.ABOVE18);
        }
        if (ageGroup == AgeGroup.BELOW5) {
            return p.getAgeGroup().equals((Object)AgeGroup.BELOW5);
        }
        return p.getAgeGroup().equals((Object)AgeGroup.ABOVE18);
    }

    public int getPageCountForScan(String docName, DocumentType docType, boolean isForeignOrNRi, ForeignDetail foreignDetail) {
        Document document = ProofData.onlineDocuments.stream().filter(d -> d.getDocumentName().equals(docName) && d.getDocType().equals((Object)docType)).findFirst().orElse(null);
        if (document != null) {
            switch (docType) {
                case POF: {
                    if (foreignDetail == null || !foreignDetail.isValidPOF()) break;
                    return document.getScanPages() * 2;
                }
                case POI: {
                    if (foreignDetail == null || !foreignDetail.isValidPOI()) break;
                    return document.getScanPages() * 2;
                }
            }
            return document.getScanPages();
        }
        if (docType == DocumentType.ENROL_FORM) {
            return isForeignOrNRi ? 2 : 1;
        }
        return 1;
    }

    public void prepareBroadCastList(EnrollmentService enrollmentService) throws OnlineGatewayException {
        try {
            boolean isNri = enrollmentService.isNRIEnrolment();
            boolean isAdult = !enrollmentService.isChildEnrollment() && !enrollmentService.isMinorEnrollment();
            boolean isUpdate = enrollmentService.isUpdateUC();
            String uid = isUpdate ? enrollmentService.getResidentUid() : "";
            String foreignType = enrollmentService.isForeignResident() ? enrollmentService.getDemoResidentialStatus().getForeignType().getName() : "";
            UcDocumentServiceProto.PreferredDocRequest preferredDocRequest = UcDocumentServiceProto.PreferredDocRequest.newBuilder().setUid(uid).setIsNri(isNri).setIsAdult(isAdult).setForeignerType(foreignType).setIsUpdate(isUpdate).build();
            GrpcService.getInst().getPreferredDoc(preferredDocRequest, response -> {
                if (response != null && !response.getPOBListList().isEmpty()) {
                    enrollmentService.getDocManager().getBroadCastMessages().addAll((Collection<String>)response.getPOBListList());
                    LOGGER.info("POB list received.");
                } else {
                    LOGGER.info("No recommended document provided");
                }
            }, throwable -> LOGGER.error("Error while fetching preferred documents {}", throwable));
        }
        catch (Exception e) {
            enrollmentService.getDocManager().getBroadCastMessages().clear();
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_118, (String)enrollmentService.getTransactionId(), (Exception)e);
        }
    }
}

