/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.document.digilocker;

import com.google.common.base.Strings;
import in.gov.uidai.ec.protobuf.DocumentMessage;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.VerifiableDocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValuesDocumentModel {
    private final Map<String, Integer> check;
    private final Map<String, String> formFieldsValues;
    private final Map<String, String> regexValues;
    private final boolean isDigilockerDocument;
    private DigilockerDocument digilockerDocument;
    private VerifiableDocument verifiableDocument;
    private boolean isAllFieldsValid;
    private String selectedState;

    public ValuesDocumentModel(VerifiableDocument verifiableDocument) {
        this.isDigilockerDocument = false;
        this.check = new HashMap<String, Integer>();
        this.formFieldsValues = new HashMap<String, String>();
        this.regexValues = new HashMap<String, String>();
        this.verifiableDocument = verifiableDocument;
        this.isAllFieldsValid = false;
        verifiableDocument.getFormfields().forEach(formField -> {
            this.check.put(formField.getKey(), 0);
            this.formFieldsValues.put(formField.getKey(), "");
            this.regexValues.put(formField.getKey(), formField.getRegex());
        });
    }

    public ValuesDocumentModel(DigilockerDocument digilockerDocument) {
        this.isDigilockerDocument = true;
        this.check = new HashMap<String, Integer>();
        this.formFieldsValues = new HashMap<String, String>();
        this.regexValues = new HashMap<String, String>();
        this.digilockerDocument = digilockerDocument;
        this.isAllFieldsValid = false;
        if (digilockerDocument.getIssuerType().equals("CENTRAL")) {
            this.initialiseFormFields();
        } else if (digilockerDocument.getIssuerType().equals("STATE")) {
            this.initialiseSourceFormfields();
        }
    }

    public boolean isDigilockerDocument() {
        return this.isDigilockerDocument;
    }

    public DigilockerDocument getDigilockerDocument() {
        return this.digilockerDocument;
    }

    public boolean isAllFieldsValid() {
        return this.isAllFieldsValid;
    }

    public String getSelectedState() {
        return this.selectedState;
    }

    public Map<String, String> getFormFieldsValues() {
        return this.formFieldsValues;
    }

    public void setSelectedState(String selectedState, List<DocumentMessage.SourceFormFields> stateFormFields) {
        this.selectedState = selectedState;
        this.check.clear();
        this.formFieldsValues.put("state", selectedState);
        stateFormFields.stream().filter(stateFormField -> stateFormField.getSource().equalsIgnoreCase(selectedState)).flatMap(stateFormField -> stateFormField.getFormFieldsList().stream()).forEach(formField -> {
            this.check.put(formField.getKey(), 0);
            this.formFieldsValues.put(formField.getKey(), "");
            this.regexValues.put(formField.getKey(), formField.getRegex());
        });
    }

    public String getTitle() {
        return "<html>" + (this.isDigilockerDocument ? this.digilockerDocument.getDocumentName() : this.verifiableDocument.getDocumentName()) + "</html>";
    }

    private void initialiseFormFields() {
        this.digilockerDocument.getFormfields().forEach(formField -> {
            this.check.put(formField.getKey(), 0);
            this.formFieldsValues.put(formField.getKey(), "");
            this.regexValues.put(formField.getKey(), formField.getRegex());
        });
    }

    private void initialiseSourceFormfields() {
        this.digilockerDocument.getFormfields().forEach(formField -> {
            this.check.put(formField.getKey(), 0);
            this.formFieldsValues.put(formField.getKey(), "");
            this.regexValues.put(formField.getKey(), formField.getRegex());
        });
    }

    public VerifiableDocument getVerifiableDocument() {
        return this.verifiableDocument;
    }

    public String validate(String value, String key) {
        Pattern pattern;
        Matcher matcher;
        String errorMsgKey = null;
        if (this.formFieldsValues.isEmpty() || value.isEmpty()) {
            errorMsgKey = "mandatory";
        } else if (this.regexValues.containsKey(key) && !Strings.isNullOrEmpty((String)this.regexValues.get(key)) && !(matcher = (pattern = Pattern.compile(this.regexValues.get(key))).matcher(value)).matches()) {
            errorMsgKey = "invalid";
        }
        if (errorMsgKey != null) {
            this.check.replace(key, 0);
            this.formFieldsValues.replace(key, "");
        } else {
            this.check.replace(key, 1);
            this.formFieldsValues.replace(key, value);
        }
        this.isAllFieldsValid = !this.check.containsValue(0);
        return errorMsgKey;
    }
}

