/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrol;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EID {
    private static final Logger LOGGER = LoggerFactory.getLogger(EID.class);
    private static final DecimalFormat NUM_FORMAT4 = new DecimalFormat("0000");
    private static final DecimalFormat NUM_FORMAT5 = new DecimalFormat("00000");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat DISPLAY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy/HH/mm/ss");
    public static final int EID_LENGTH = 14;
    public static final int EID_DATE_LENGTH = 28;
    private int agencyCode;
    private int stationId;
    private int sequenceNum;
    private long timestamp;
    private long timestampInMs;

    public EID(int eac, int sid, int seq) {
        this.agencyCode = Math.abs(eac % 10000);
        this.stationId = Math.abs(sid % 100000);
        this.sequenceNum = Math.abs(seq % 100000);
        this.setTimestamp(System.currentTimeMillis() / 1000L);
    }

    private void setTimestamp(long timestampValue) {
        this.timestamp = timestampValue;
        this.timestampInMs = timestampValue * 1000L;
    }

    public String getEnrolNumDecorated() {
        return NUM_FORMAT4.format(this.agencyCode) + "/" + NUM_FORMAT5.format(this.stationId) + "/" + NUM_FORMAT5.format(this.sequenceNum);
    }

    public String getEnrolNum() {
        return NUM_FORMAT4.format(this.agencyCode) + NUM_FORMAT5.format(this.stationId) + NUM_FORMAT5.format(this.sequenceNum);
    }

    public String getEnrolDate() {
        return DATE_FORMAT.format(new Date(this.timestampInMs));
    }

    public String hashValue() {
        String result = Long.toString(this.agencyCode, 36) + "." + Long.toString(this.stationId, 36) + "-" + Long.toString(this.sequenceNum, 36) + "-" + Long.toString(this.timestamp, 36);
        return result.toLowerCase();
    }

    public String toString() {
        return this.getEnrolNum() + this.getEnrolDate();
    }

    public String toStringDecorated() {
        return this.getEnrolNumDecorated() + ":" + this.getEnrolDateDecorated();
    }

    private String getEnrolDateDecorated() {
        return DISPLAY_DATE_FORMAT.format(new Date(this.timestampInMs));
    }

    public static synchronized EID valueOf(String eidStr) {
        if (eidStr.length() < 28) {
            return null;
        }
        String regIdStr = eidStr.substring(0, 4);
        String agencyIdStr = eidStr.substring(4, 9);
        String seqStr = eidStr.substring(9, 14);
        String dateStr = eidStr.substring(14);
        try {
            EID eid = new EID(Integer.parseInt(regIdStr), Integer.parseInt(agencyIdStr), Integer.parseInt(seqStr));
            eid.setTimestamp(DATE_FORMAT.parse(dateStr).getTime() / 1000L);
            return eid;
        }
        catch (Exception exep) {
            LOGGER.error("invalid EID format", (Throwable)exep);
            return null;
        }
    }

    public static EID valueOfDisplay(String eidStr) {
        int seq;
        int sId;
        int eacId;
        String[] parts = eidStr.split(" ");
        if (parts.length < 2) {
            return null;
        }
        String[] enrolNum = parts[0].split("-");
        String[] enrolTime = parts[1].split("/");
        if (enrolNum.length < 3 || enrolTime.length < 6) {
            return null;
        }
        try {
            eacId = Integer.parseInt(enrolNum[0]);
            sId = Integer.parseInt(enrolNum[1]);
            seq = Integer.parseInt(enrolNum[2]);
        }
        catch (Exception exep) {
            return null;
        }
        EID eid = new EID(eacId, sId, seq);
        try {
            eid.setTimestamp(DISPLAY_DATE_FORMAT.parse(parts[1]).getTime() / 1000L);
        }
        catch (ParseException e) {
            return null;
        }
        return eid;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNum;
    }
}

