/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrol;

import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.DerbyDbException;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.packet.ActorType;
import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.IEnrolVerifyDAO;
import in.gov.uidai.ec.service.packet.PacketDemoVerify;
import in.gov.uidai.ec.service.packet.PacketStatus;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.PacketSummary;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import in.gov.uidai.ec.service.packet.UenrolSummary;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentPacketManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrollmentPacketManager.class);
    private EnrollmentService enrollmentService;
    private IRegistrationService registrationService;
    private IPreSyncPreference preSyncPref;
    private IEnrolVerifyDAO enrolVerifyDAO;
    private File autoSyncRootFolder;
    private File rootFolder;
    private IOucDataStore oucDataStore;

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public final void setEnrolVerifyDAO(IEnrolVerifyDAO enrolVerifyDAO) {
        this.enrolVerifyDAO = enrolVerifyDAO;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setAutoSyncRootFolder(File root) {
        this.autoSyncRootFolder = root;
    }

    public File getAutoSyncPacketLocation(EID enrolId) throws ClientException, IOException {
        File canonicalFile;
        File file = new File(this.autoSyncRootFolder, enrolId.toString());
        if (!file.exists()) {
            LOGGER.error("File does not exists: ");
        }
        if (!(canonicalFile = file.getCanonicalFile()).getPath().startsWith(this.rootFolder.getCanonicalPath())) {
            LOGGER.error("Attempt to manipulate file path");
        }
        return file;
    }

    public void setRootFolder(File root) {
        this.rootFolder = root;
        if (this.rootFolder.mkdirs()) {
            LOGGER.info("Directory created");
        } else {
            LOGGER.info("Directory not created");
        }
        LOGGER.debug("packet root folder: " + root.getAbsolutePath());
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    @Deprecated
    public File getPacketLocation(EID enrolId) throws ClientException, IOException {
        File canonicalFile;
        String fileName = enrolId.hashValue();
        char fc = Character.toLowerCase(fileName.charAt(fileName.length() - 1));
        String filePath = fc >= 'a' && fc <= 'd' ? "abcd" : (fc >= 'e' && fc <= 'h' ? "efgh" : (fc >= 'i' && fc <= 'l' ? "ijkl" : (fc >= 'm' && fc <= 'p' ? "mnop" : (fc >= 'q' && fc <= 't' ? "qrst" : (fc >= 'u' && fc <= 'x' ? "uvwx" : "yz09")))));
        File finalFile = new File(this.rootFolder, filePath + File.separator + fileName);
        if (!finalFile.exists()) {
            LOGGER.error("File does not exists: ");
        }
        if (!(canonicalFile = finalFile.getCanonicalFile()).getPath().startsWith(this.rootFolder.getCanonicalPath())) {
            LOGGER.error("Attempt to manipulate file path");
        }
        return finalFile;
    }

    public void updatePacketDetailsInDb(Date packetCreatedDate) throws IOException, StationInfoStoreException, DerbyDbException {
        ChargesInfo chargesInfo = this.oucDataStore.getChargesInfo();
        EID enrolId = this.enrollmentService.getEnrolId();
        PacketSummary packetSummary = new PacketSummary();
        packetSummary.setEnrolId(enrolId.toString());
        packetSummary.setPacketCreationDate(this.enrollmentService.getEndTime());
        packetSummary.setRegistrarId(this.registrationService.getRegistrarId());
        packetSummary.setLangCode(this.enrollmentService.getEnrollmentLangCode());
        packetSummary.setMandatoryBiometricUpdate(this.enrollmentService.isMandatoryBiometricUpdate() ? "Yes" : "No");
        float amountChargedForUpdateEnrolment = this.enrollmentService.isMandatoryBiometricUpdate() && this.enrollmentService.getMandatoryBiometricCheckResponse().getFreeUpdate().equalsIgnoreCase("No") ? chargesInfo.getAmountChargedForBiometricUpdate() : (this.enrollmentService.isMandatoryBiometricUpdate() || !this.enrollmentService.isUpdateEnrollment() ? 0.0f : (this.enrollmentService.isBiometricUpdate() ? chargesInfo.getAmountChargedForBiometricUpdate() : (this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? chargesInfo.getAmountChargedForDemographicUpdate() : chargesInfo.getAmountChargedForDemographicUpdate())));
        float gst = chargesInfo.getGstApplied();
        packetSummary.setGstApplied(gst);
        float totalAmountCharged = amountChargedForUpdateEnrolment + amountChargedForUpdateEnrolment * gst / 100.0f;
        LOGGER.info("IF demographic update ::: " + this.enrollmentService.isUpdateEnrollment() + " If Document only update ::: " + this.enrollmentService.isDocumentUpdate() + " If Mandatory Biometric Update ::: " + this.enrollmentService.isMandatoryBiometricUpdate() + " If OffLine Document Update ::: " + this.enrollmentService.isOffLineDocumentUpdate() + " If Bio update ::: " + this.enrollmentService.isBiometricUpdate());
        if (this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isMandatoryBiometricUpdate() || this.enrollmentService.isOffLineDocumentUpdate() || this.enrollmentService.isBiometricUpdate()) {
            packetSummary.setAmountChargedForUpdateEnrolment(amountChargedForUpdateEnrolment);
        } else {
            packetSummary.setAmountChargedForNewEnrolment(chargesInfo.getAmountChargedForNewEnrolment());
        }
        packetSummary.setTotalAmountCharged(totalAmountCharged);
        packetSummary.setStatus(PacketStatusType.APPROVED.toIntValue());
        PacketStatus packetStatus = new PacketStatus();
        packetStatus.setEnrolId(enrolId.toString());
        packetStatus.setStatus(PacketStatusType.APPROVED.toIntValue());
        packetStatus.setStatusEntryDate(packetCreatedDate.getTime());
        References references = this.enrollmentService.getReferences();
        ReferenceIntroducer referenceIntroducer = references.getReferenceIntroducer();
        if (referenceIntroducer.isMandatory()) {
            packetStatus.setActorType(ActorType.INTRODUCER.toIntValue());
            packetStatus.setActorId(referenceIntroducer.getAadhaarNumber());
            packetStatus.setActorName(referenceIntroducer.getName());
            packetSummary.setReviewerStatus(PacketStatusType.APPROVED.toIntValue());
            if (this.enrollmentService.getConfirmerDetails().getIntroducer().getBiometrics() != null) {
                packetSummary.setIntroStatus(PacketStatusType.INTRO_APPROVED.toIntValue());
            } else {
                packetSummary.setIntroStatus(PacketStatusType.APPROVED.toIntValue());
            }
        } else {
            packetSummary.setReviewerStatus(PacketStatusType.APPROVED.toIntValue());
            packetStatus.setActorType(ActorType.REVIEWER.toIntValue());
        }
        if (this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isDocumentUpdate() && !this.enrollmentService.isOffLineDocumentUpdate()) {
            packetSummary.setPktType(PacketType.UPDATE.toIntValue());
        } else if (this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            packetSummary.setPktType(PacketType.DOCUPDATE.toIntValue());
        } else {
            packetSummary.setPktType(PacketType.NEW.toIntValue());
        }
        Contact contact = this.enrollmentService.getDemoContactDetails();
        packetSummary.setMobile(contact.getMobile().number());
        Address address = contact.getAddress();
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        this.updateAddressDetails(personalDetail, packetSummary, address);
        packetSummary.setTinNum(personalDetail.getNpr().getNprNumber());
        packetSummary.setOpId(this.enrollmentService.getConfirmerDetails().getOperator().getUserId());
        packetSummary.setOpName(this.enrollmentService.getConfirmerDetails().getOperator().getFullName());
        ResidentialStatus residentialStatus = this.enrollmentService.getDemoResidentialStatus();
        packetSummary.setIsNRI(residentialStatus.isNriResidentAsString());
        packetSummary.setAppointmentId(this.enrollmentService.getAppointmentId());
        PacketDemoVerify dv = new PacketDemoVerify();
        dv.setEnrolId(enrolId.toString());
        if (references.getHofDoc().isMandatory()) {
            dv.setVerifyType(PacketVerifyType.HOF.toIntValue());
        } else if (references.getReferenceIntroducer().isMandatory()) {
            dv.setVerifyType(PacketVerifyType.INTRODUCER.toIntValue());
        } else {
            dv.setVerifyType(PacketVerifyType.POI_POA.toIntValue());
        }
        if (references.getHofDoc().isMandatory() || references.getReferenceIntroducer().isMandatory()) {
            dv.setVerifierName(referenceIntroducer.getName());
            dv.setVerifierId(referenceIntroducer.getAadhaarNumber());
        }
        UserDetails supervisorDetails = this.enrollmentService.getConfirmerDetails().getSupervisor();
        String bioException = this.generateBioExceptionPattern();
        if (this.enrollmentService.isUpdateEnrollment()) {
            UenrolSummary uenrolSummary = new UenrolSummary();
            uenrolSummary.setEnrolId(enrolId.toString());
            uenrolSummary.setBioException(bioException);
            uenrolSummary.setPreviousUid(this.enrollmentService.getDemographics().getPersonalDetail().getAadhaarNumber().getAadhaarNumber());
            uenrolSummary.setSupervisorId(supervisorDetails != null ? supervisorDetails.getUserId() : null);
            this.enrolVerifyDAO.addUpdate(packetSummary, packetStatus, uenrolSummary, dv);
        } else {
            EnrolSummary enrolSum = new EnrolSummary();
            enrolSum.setEnrolId(enrolId.toString());
            enrolSum.setBioException(bioException);
            enrolSum.setSupervisorId(supervisorDetails != null ? supervisorDetails.getUserId() : null);
            this.enrolVerifyDAO.addCreate(packetSummary, packetStatus, enrolSum, dv);
        }
    }

    private void updateAddressDetails(PersonalDetail personalDetail, PacketSummary packetSummary, Address address) {
        packetSummary.setResidentName(personalDetail.getName().english());
        packetSummary.setAddrBuilding(address.getBuilding());
        packetSummary.setAddrStreet(address.getStreet());
        packetSummary.setAddrLocality(address.getLocality());
        packetSummary.setAddrLandmark(address.getLandmark());
        packetSummary.setAddrDistrict(address.getDistrict());
        packetSummary.setAddrSubdistrict(address.getSubDistrict());
        packetSummary.setAddrState(address.getState());
        packetSummary.setAddrCountry(address.getCountryCode());
        packetSummary.setAddrVtc(address.getVTC());
        packetSummary.setAddrPincode(address.getPinCodeValue());
    }

    public String generateBioExceptionPattern() {
        int bioExcpPattern = 4095;
        ArrayList<BiometricPosition> bioExcpList = new ArrayList<BiometricPosition>();
        bioExcpList.addAll(this.enrollmentService.getBiometricsException().getExceptionDetail().getMissingFingers());
        bioExcpList.addAll(this.enrollmentService.getBiometricsException().getExceptionDetail().getMissingEyes());
        for (BiometricPosition bioPos : bioExcpList) {
            switch (bioPos) {
                case RIGHT_IRIS: {
                    bioExcpPattern &= 0x7FF;
                    break;
                }
                case LEFT_IRIS: {
                    bioExcpPattern &= 0xBFF;
                    break;
                }
                case RIGHT_THUMB: {
                    bioExcpPattern &= 0xDFF;
                    break;
                }
                case RIGHT_INDEX: {
                    bioExcpPattern &= 0xEFF;
                    break;
                }
                case RIGHT_MIDDLE: {
                    bioExcpPattern &= 0xF7F;
                    break;
                }
                case RIGHT_RING: {
                    bioExcpPattern &= 0xFBF;
                    break;
                }
                case RIGHT_LITTLE: {
                    bioExcpPattern &= 0xFDF;
                    break;
                }
                case LEFT_THUMB: {
                    bioExcpPattern &= 0xFEF;
                    break;
                }
                case LEFT_INDEX: {
                    bioExcpPattern &= 0xFF7;
                    break;
                }
                case LEFT_MIDDLE: {
                    bioExcpPattern &= 0xFFB;
                    break;
                }
                case LEFT_RING: {
                    bioExcpPattern &= 0xFFD;
                    break;
                }
                case LEFT_LITTLE: {
                    bioExcpPattern &= 0xFFE;
                }
            }
        }
        StringBuilder binaryPattern = new StringBuilder(Integer.toBinaryString(bioExcpPattern));
        int paddingSize = 12 - binaryPattern.length();
        for (int i = 0; i < paddingSize; ++i) {
            binaryPattern.insert(0, "0");
        }
        if (this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isChild()) {
            binaryPattern = new StringBuilder("222222222222");
        }
        return binaryPattern.toString();
    }
}

