/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrol.dynaddr;

import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.enrol.dynaddr.AddressField;
import in.gov.uidai.ec.service.enrol.dynaddr.AddressLabel;
import in.gov.uidai.ec.service.enrol.dynaddr.DynamicAddressLayout;
import in.gov.uidai.ec.service.enrol.dynaddr.IDynaddrPreference;
import in.gov.uidai.ec.service.enrol.dynaddr.IDynaddrTemplateManager;
import in.gov.uidai.ec.service.enrol.dynaddr.PrintAddressField;
import in.gov.uidai.ec.service.enrol.dynaddr.PrintAddressLayout;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DynaddrTemplateManager
implements IPreferenceStoreAware,
InitializingBean,
IDynaddrTemplateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynaddrTemplateManager.class);
    public static final String TPL_ROOT_PATH = "res/dynaddr";
    public static final String TPL_LIST_FILE = "templates.list";
    private IDynaddrPreference addrPref;
    private IPreferenceStore prefStore;
    private Map<String, DynamicAddressLayout> layoutMap;
    private IResourceBundleContext rbCtxt;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
        LOGGER.debug("set");
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
        LOGGER.debug("preferences store set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        InputStream listInput;
        this.layoutMap = new HashMap<String, DynamicAddressLayout>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((listInput = cl.getResourceAsStream("res/dynaddr/templates.list")) == null) {
            LOGGER.debug("list of dynamic address templates not found");
            return;
        }
        List<String> tplList = null;
        try {
            tplList = this.readTemplatesList(listInput);
            LOGGER.debug("list of dynamic address templates loaded");
        }
        catch (Exception exep) {
            LOGGER.warn("error loading template list", (Throwable)exep);
            return;
        }
        finally {
            listInput.close();
        }
        for (String tplFile : tplList) {
            try {
                DynamicAddressLayout dal = this.readTemplate(tplFile);
                if (dal == null) {
                    LOGGER.warn("error loading template file: " + tplFile);
                    continue;
                }
                this.layoutMap.put(dal.getId(), dal);
                LOGGER.debug("loaded dynamic address template: " + dal.getId());
            }
            catch (Exception exep) {
                LOGGER.warn("error loading template file: " + tplFile, (Throwable)exep);
                return;
            }
        }
    }

    public void setPreference(IDynaddrPreference pref) {
        this.addrPref = pref;
        LOGGER.debug("preferences set");
    }

    @Override
    public Properties listAll() {
        Properties result = new Properties();
        Set<String> idSet = this.layoutMap.keySet();
        for (String id : idSet) {
            String name = this.layoutMap.get(id).getDisplayName();
            result.put(id, name);
        }
        return result;
    }

    @Override
    public DynamicAddressLayout getCurrentLayout() {
        String id = this.addrPref.getAddressLayout("default");
        return this.layoutMap.get(id);
    }

    @Override
    public void setCurrentLayout(String id) {
        this.addrPref.setAddressLayout(id);
        if (this.prefStore != null) {
            this.prefStore.save();
        }
    }

    @Override
    public byte[] getCurrentPrintLayout() {
        DynamicAddressLayout dal = this.getCurrentLayout();
        return this.getPrintLayout(dal);
    }

    private List<String> readTemplatesList(InputStream input) throws IOException {
        String oneLine;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((oneLine = reader.readLine()) != null) {
            if ((oneLine = oneLine.trim()).length() == 0 || oneLine.charAt(0) == '#') continue;
            result.add("res/dynaddr/" + oneLine);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicAddressLayout readTemplate(String fileName) throws IOException {
        InputStream tplInput;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((tplInput = cl.getResourceAsStream(fileName)) == null) {
            LOGGER.debug("dynamic address template file [" + fileName + "] not found");
            return null;
        }
        try {
            DynamicAddressLayout result;
            DynamicAddressLayout dynamicAddressLayout = result = (DynamicAddressLayout)JAXB.unmarshal((InputStream)tplInput, DynamicAddressLayout.class);
            return dynamicAddressLayout;
        }
        finally {
            tplInput.close();
        }
    }

    private byte[] getPrintLayout(DynamicAddressLayout dal) {
        AddressField lpincode;
        AddressField pincode;
        AddressField lpo;
        AddressField po;
        AddressField lstate;
        AddressField state;
        AddressField ldistrict;
        AddressField district;
        AddressField lsubdist;
        AddressField subdist;
        AddressField lvtc;
        AddressField vtc;
        AddressField llocality;
        AddressField locality;
        AddressField llandmark;
        AddressField landmark;
        AddressField lstreet;
        AddressField street;
        AddressField lhouse;
        PrintAddressLayout pal = new PrintAddressLayout();
        AddressField house = dal.getHouse();
        if (house != null) {
            pal.setBuilding(this.convert(house, false));
        }
        if ((lhouse = dal.getHouseLocal()) != null) {
            pal.setBuildingLocal(this.convert(lhouse, true));
        }
        if ((street = dal.getStreet()) != null) {
            pal.setStreet(this.convert(street, false));
        }
        if ((lstreet = dal.getStreetLocal()) != null) {
            pal.setStreetLocal(this.convert(lstreet, true));
        }
        if ((landmark = dal.getLandmark()) != null) {
            pal.setLandmark(this.convert(landmark, false));
        }
        if ((llandmark = dal.getLandmarkLocal()) != null) {
            pal.setLandmarkLocal(this.convert(llandmark, true));
        }
        if ((locality = dal.getLocality()) != null) {
            pal.setLocality(this.convert(locality, false));
        }
        if ((llocality = dal.getLocalityLocal()) != null) {
            pal.setLocalityLocal(this.convert(llocality, true));
        }
        if ((vtc = dal.getVtc()) != null) {
            pal.setVtc(this.convert(vtc, false));
        }
        if ((lvtc = dal.getVtcLocal()) != null) {
            pal.setVtcLocal(this.convert(lvtc, true));
        }
        if ((subdist = dal.getSubDistrict()) != null) {
            pal.setSubDistrict(this.convert(subdist, false));
        }
        if ((lsubdist = dal.getSubDistrictLocal()) != null) {
            pal.setSubDistrictLocal(this.convert(lsubdist, true));
        }
        if ((district = dal.getDistrict()) != null) {
            pal.setDistrict(this.convert(district, false));
        }
        if ((ldistrict = dal.getDistrictLocal()) != null) {
            pal.setDistrictLocal(this.convert(ldistrict, true));
        }
        if ((state = dal.getState()) != null) {
            pal.setState(this.convert(state, false));
        }
        if ((lstate = dal.getStateLocal()) != null) {
            pal.setStateLocal(this.convert(lstate, true));
        }
        if ((po = dal.getPo()) != null) {
            pal.setPo(this.convert(po, false));
        }
        if ((lpo = dal.getPoLocal()) != null) {
            pal.setPoLocal(this.convert(lpo, true));
        }
        if ((pincode = dal.getPincode()) != null) {
            pal.setPincode(this.convert(pincode, false));
        }
        if ((lpincode = dal.getPincodeLocal()) != null) {
            pal.setPincodeLocal(this.convert(lpincode, true));
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            JAXB.marshal((Object)pal, (OutputStream)buffer);
            buffer.flush();
            buffer.close();
            return buffer.toByteArray();
        }
        catch (Exception exep) {
            LOGGER.error("while generating print address layout XML", (Throwable)exep);
            return new byte[0];
        }
    }

    private PrintAddressField convert(AddressField field, boolean local) {
        int colStart;
        PrintAddressField result = new PrintAddressField();
        String label = this.getLabelText(field, local);
        if (StringUtils.isNotBlank((String)label)) {
            result.setLabel(label);
        }
        result.setRow(field.getRow());
        int colEnd = colStart = field.getCol();
        if (local) {
            if ((colStart += 2) < 3) {
                colStart = 3;
            }
            if (colStart > 4) {
                colStart = 4;
            }
            colEnd = colStart;
        } else {
            if (colStart < 1) {
                colStart = 1;
            }
            if (colStart > 2) {
                colStart = 2;
            }
            colEnd = colStart;
        }
        if (field.isColspan() && (colStart == 1 || colStart == 3)) {
            colEnd = colStart + 1;
        }
        result.setColStart(colStart);
        result.setColEnd(colEnd);
        if (local) {
            String localeStr = this.rbCtxt.getLocale().toString().toLowerCase();
            String langCode = UidLocaleUtils.getLangCodeFrmLocaleStr((String)localeStr);
            result.setLangCode(langCode);
        }
        return result;
    }

    private String getLabelText(AddressField field, boolean local) {
        AddressLabel label = field.getLabel();
        if (label == null || !label.isPrintable()) {
            return null;
        }
        String id = label.getId();
        String altId = label.getAltId();
        if (StringUtils.isNotBlank((String)id)) {
            String text = null;
            text = local ? this.rbCtxt.getLocaleMessage((Object)id, new Object[0]) : this.rbCtxt.getMessage((Object)id, new Object[0]);
            if (StringUtils.startsWith((String)text, (String)"!") && StringUtils.endsWith((String)text, (String)"!") && !StringUtils.isBlank((String)altId)) {
                text = local ? this.rbCtxt.getLocaleMessage((Object)altId, new Object[0]) : this.rbCtxt.getMessage((Object)altId, new Object[0]);
            }
            return text;
        }
        return label.getValue();
    }
}

