/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment;

import java.awt.image.BufferedImage;

class AutoCrop {
    private static final int PRECISION = 5;
    private static final int THRESHOLD = 128;
    private final BufferedImage srcImg;

    AutoCrop(BufferedImage img) {
        this.srcImg = img;
    }

    BufferedImage crop() {
        int width = this.srcImg.getWidth();
        int height = this.srcImg.getHeight();
        int minx = width - 1;
        int maxx = 0;
        int miny = height - 1;
        int maxy = 0;
        for (int i = 0; i < width; i += 5) {
            for (int j = 0; j < height; j += 5) {
                int cgray = 0;
                int pixelcount = 0;
                for (int ii = i; ii < i + 5; ++ii) {
                    for (int jj = j; jj < j + 5; ++jj) {
                        if (ii >= width || jj >= height) continue;
                        int rgb = this.srcImg.getRGB(i, j);
                        cgray += this.getGrayScale(rgb);
                        ++pixelcount;
                    }
                }
                int gray = cgray / pixelcount;
                if (gray >= 128) continue;
                minx = Math.min(minx, i);
                maxx = Math.max(maxx, i);
                miny = Math.min(miny, j);
                maxy = Math.max(maxy, j);
            }
        }
        minx = Math.max(minx - 5, 0);
        maxx = Math.min(maxx + 5, width);
        miny = Math.max(miny - 5, 0);
        maxy = Math.min(maxy + 5, height);
        return this.srcImg.getSubimage(minx, miny, maxx - minx, maxy - miny);
    }

    private int getGrayScale(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
    }
}

