/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.service.enrollment.AutoCrop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JComponent;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CapturedImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapturedImageConverter.class);

    private CapturedImageConverter() {
    }

    public static Image toRenderableImage(CapturedImage cimage) {
        if (cimage == null) {
            return null;
        }
        byte[] data = cimage.getImageData();
        if (ArrayUtils.isEmpty((byte[])data)) {
            LOGGER.debug("no data in captured image");
            return null;
        }
        LOGGER.debug("image data size: " + data.length);
        if (StringUtils.isBlank((String)cimage.getEncoding())) {
            LOGGER.debug("processing raw image - " + cimage.getWidth() + "x" + cimage.getHeight());
            BufferedImage image = new BufferedImage(cimage.getWidth(), cimage.getHeight(), 10);
            DataBuffer dataBuf = image.getRaster().getDataBuffer();
            for (int i = 0; i < data.length - 4; ++i) {
                int pix = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8;
                dataBuf.setElem(i, pix);
            }
            return image;
        }
        LOGGER.debug("processing non-raw image");
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            Iterator<ImageReader> imgrs = ImageIO.getImageReaders(iis);
            if (!imgrs.hasNext()) {
                return null;
            }
            ImageReader imgr = imgrs.next();
            imgr.setInput(iis, true, true);
            BufferedImage img = imgr.read(0);
            imgr.dispose();
            if (img == null) {
                LOGGER.debug("could not decode for format " + cimage.getEncoding());
            }
            return img;
        }
        catch (Exception e) {
            LOGGER.debug("", (Throwable)e);
            return null;
        }
    }

    public static Image toRenderableImage(CapturedImage cimage, JComponent renderer, boolean autocrop) {
        Image srcImg = CapturedImageConverter.toRenderableImage(cimage);
        if (srcImg == null) {
            return null;
        }
        if (autocrop && srcImg instanceof BufferedImage) {
            AutoCrop ac = new AutoCrop((BufferedImage)srcImg);
            srcImg = ac.crop();
        }
        int srcWidth = srcImg.getWidth(renderer);
        int srcHeight = srcImg.getHeight(renderer);
        int tgtWidth = renderer.getWidth();
        int tgtHeight = renderer.getHeight();
        double widthRatio = (double)tgtWidth * 1.0 / ((double)srcWidth * 1.0);
        double heightRatio = (double)tgtHeight * 1.0 / ((double)srcHeight * 1.0);
        double scale = Math.min(widthRatio, heightRatio);
        BufferedImage result = new BufferedImage((int)((double)srcWidth * scale), (int)((double)srcHeight * scale), 5);
        Graphics2D g2 = (Graphics2D)result.getGraphics();
        g2.drawImage(srcImg, AffineTransform.getScaleInstance(scale, scale), renderer);
        return result;
    }

    public static byte[] toRenderableData(CapturedImage cimage, String format) {
        Image img = CapturedImageConverter.toRenderableImage(cimage);
        if (img == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)((Object)img), format, buffer);
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (Exception exep) {
            return new byte[0];
        }
    }

    public static Image toTemporaryImage(Image srcImg, JComponent renderer) {
        int srcWidth = srcImg.getWidth(renderer);
        int srcHeight = srcImg.getHeight(renderer);
        int tgtWidth = renderer.getWidth();
        int tgtHeight = renderer.getHeight();
        double widthRatio = (double)tgtWidth * 1.0 / ((double)srcWidth * 1.0);
        double heightRatio = (double)tgtHeight * 1.0 / ((double)srcHeight * 1.0);
        double scale = Math.min(widthRatio, heightRatio);
        return srcImg.getScaledInstance((int)((double)srcWidth * scale), (int)((double)srcHeight * scale), 2);
    }
}

