/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.EcmpRequest;
import in.gov.uidai.ec.ecmpapi.json.mandatorybiometriccheck.MandatoryBiometricCheckRequest;
import in.gov.uidai.ec.ecmpapi.json.mandatorybiometriccheck.MandatoryBiometricCheckResponse;
import in.gov.uidai.ec.ecmpapi.json.onlineqc.EnrollmentUploadResponse;
import in.gov.uidai.ec.ecmpapi.json.onlineqc.OnlineEnrollmentRequest;
import in.gov.uidai.ec.ecmpapi.json.statuscheck.Id;
import in.gov.uidai.ec.ecmpapi.json.statuscheck.UidStatusCheckRequest;
import in.gov.uidai.ec.ecmpapi.json.statuscheck.UidStatusCheckResponse;
import in.gov.uidai.ec.icas.text.EnrollmentResourceBundleContext;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.oauthapi.OauthGWService;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.LabelDetail;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.IStandardViewLoadListener;
import in.gov.uidai.ec.service.appointment.model.IAppointment;
import in.gov.uidai.ec.service.document.DocumentService;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.OnlineDocumentService;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.ValuesDocumentModel;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrolStep;
import in.gov.uidai.ec.service.enrollment.EnrolStepInfo;
import in.gov.uidai.ec.service.enrollment.EnrolStepUtil;
import in.gov.uidai.ec.service.enrollment.EnrolmentIDGenerator;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Appointment;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.Brn;
import in.gov.uidai.ec.service.enrollment.model.ConfirmerDetails;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.EnrollmentState;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.FingerPrint;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.enrollment.model.Iris;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.Photograph;
import in.gov.uidai.ec.service.enrollment.model.PinCodeDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.service.isd.IISDService;
import in.gov.uidai.ec.service.mbu.MbuStatus;
import in.gov.uidai.ec.service.operatordisclosure.MissingEIDFile;
import in.gov.uidai.ec.service.pac.PacDetail;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostOfficeType;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.IOAuthSessionService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.session.OAuthSessionService;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.ui.biologin.AuthWrapper25Request;
import in.gov.uidai.ec.ui.biologin.AuthWrapperRequest;
import in.gov.uidai.ec.ui.biologin.BioAuthResponse;
import in.gov.uidai.ec.ui.biologin.LogoutResponse;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth16Request;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth16Response;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth25Request;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentService
implements IStandardViewLoadListener {
    private IResourceBundleContext resourceBundleContext;
    private EnrollmentResourceBundleContext enrollmentResourceBundleContext;
    private ISessionService sessionService;
    private IISDService isdService;
    private IAppointment appointment;
    private DocumentService documentService;
    private EcmpApiService ecmpApiService;
    private IPreSyncPreference preSyncPreference;
    private EnrollmentState enrollmentState;
    private EnrolmentIDGenerator enrolIdGenerator;
    private List<Consumer> pinCodeLoadedListeners = new ArrayList<Consumer>();
    private List<Consumer> poCodeLoadedListeners = new ArrayList<Consumer>();
    private List<Consumer> viewLoadCompleteListeners = new ArrayList<Consumer>();
    private List<Consumer<Integer>> tabTransitionListeners = new ArrayList<Consumer<Integer>>();
    private List<Consumer<Boolean>> tabDisableListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<String>> newUpdateFlowListeners = new ArrayList<Consumer<String>>();
    private List<Consumer<OperatorDetails>> displayOperatorDetails = new ArrayList<Consumer<OperatorDetails>>();
    private Map<DocumentType, String> xmlData = new HashMap<DocumentType, String>();
    private IRegistrationService registrationService;
    private String clientLangCode;
    private StringBuilder updatedBitValues;
    private IOAuthSessionService oAuthSessionService;
    private OauthGWService oauthGwApiService;
    private Consumer<String> bioLoginFailureListener;
    private Runnable countScreenListener;
    private Runnable residentUpdateInfoSuccessListener;
    private Runnable grievanceStatusListener;
    private Runnable operatorConfirmationListener;
    private Runnable docSuccessListener;
    private Runnable foreignTypeListener;
    private CountDownLatch consentCountDownLatch;
    private OnlineDocumentService onlineDocumentService;
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrollmentService.class);
    private DigilockerDocument digilockerDocuments;
    private String documentFetchType;
    private ValuesDocumentModel valuesDocumentModel;
    private PacDetail pacDetail;
    private MbuStatus mbuStatus;
    private Boolean isExceptionPhotoUploaded = false;
    private boolean documentUpdate;
    ObjectMapper objectMapper = new ObjectMapper();
    public MissingEIDFile missingEIDFile;
    MandatoryBiometricCheckResponse mandatoryBiometricCheckResponse;
    UidStatusCheckResponse uidStatusCheckResponse;

    public void setEnrolIdGenerator(EnrolmentIDGenerator gen) {
        this.enrolIdGenerator = gen;
    }

    public void addBiometricUpdateChangeListener(Consumer<Boolean> delegate) {
        this.enrollmentState.addBiometricUpdateChangeListener(delegate);
    }

    public void setOauthGwApiService(OauthGWService oauthGwApiService) {
        this.oauthGwApiService = oauthGwApiService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void addOnPinCodeLoadedListeners(Consumer delegate) {
        this.pinCodeLoadedListeners.add(delegate);
    }

    public void addOnPOListLoadedListeners(Consumer delegate) {
        this.poCodeLoadedListeners.add(delegate);
    }

    public void addOnViewLoadCompleteListeners(Consumer delegate) {
        this.viewLoadCompleteListeners.add(delegate);
    }

    public void addOnTabTransitionListeners(Consumer delegate) {
        this.tabTransitionListeners.add(delegate);
    }

    public void addResidentChildListeners(Consumer<Boolean> delegate) {
        this.enrollmentState.addResidentChildEnrollmentChangeListeners(delegate);
    }

    public void addResidentMinorListeners(Consumer<Boolean> delegate) {
        this.enrollmentState.addResidentChildEnrollmentChangeListeners(delegate);
    }

    public void addResidentAdultListeners(Consumer<Boolean> delegate) {
        this.enrollmentState.addResidentChildEnrollmentChangeListeners(delegate);
    }

    public void addDisableTabListeners(Consumer<Boolean> delegate) {
        this.tabDisableListeners.add(delegate);
    }

    public void firePincodeLoaded() {
        this.pinCodeLoadedListeners.forEach(listener -> listener.accept(null));
    }

    public void firePOCodeLoaded() {
        this.poCodeLoadedListeners.forEach(listener -> listener.accept(null));
    }

    @Override
    public void fireViewLoadComplete() {
        this.viewLoadCompleteListeners.forEach(listener -> listener.accept(null));
    }

    public void fireTabTransition(Integer fromStep) {
        this.tabTransitionListeners.forEach(listener -> listener.accept(fromStep));
    }

    public void fireDisableAllTabs() {
        this.tabDisableListeners.forEach(listener -> listener.accept(true));
    }

    public IResourceBundleContext getResourceBundleContext() {
        return this.resourceBundleContext;
    }

    public void setResourceBundleContext(IResourceBundleContext resourceBundleContext) {
        this.resourceBundleContext = resourceBundleContext;
    }

    public void setEnrollmentResourceBundleContext(EnrollmentResourceBundleContext resourceBundleContext) {
        this.enrollmentResourceBundleContext = resourceBundleContext;
    }

    public ISessionService getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public boolean isLanguageUpdated() {
        return false;
    }

    public IISDService getIsdService() {
        return this.isdService;
    }

    public void setIsdService(IISDService isdService) {
        this.isdService = isdService;
    }

    public void setAppointment(IAppointment appointment) {
        this.appointment = appointment;
        if (this.isUpdateEnrollment()) {
            this.enrollmentState.setUpdateType(UpdateType.APPOINTMENT_UPDATE);
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public IPreSyncPreference getPreSyncPreference() {
        return this.preSyncPreference;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPreference = pref;
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getFaceTrailMap() {
        return this.enrollmentState.getFaceTrailMap();
    }

    public void initiateNewEnrollment() {
        Address lastSavedAddress = null;
        if (this.enrollmentState != null && this.getDemographics() != null) {
            lastSavedAddress = this.getDemoContactDetails().getAddress();
        }
        this.reset();
        this.enrollmentState = new EnrollmentState(this.enrolIdGenerator, this);
        this.enrollmentState.init(false, false, false, false);
        this.setSid("");
        if (lastSavedAddress != null && lastSavedAddress.isMandatory() && lastSavedAddress.isValid()) {
            this.getDemoContactDetails().setLastSavedAddress(lastSavedAddress);
        } else {
            this.getDemoContactDetails().setLastSavedAddress(null);
        }
        this.setEnrollmentLocale(this.clientLangCode);
    }

    public void initiateUpdateEnrollment(boolean onlineUpdate, boolean docUpdate, boolean isOffLineDocumentUpdate) {
        this.reset();
        this.enrollmentState = new EnrollmentState(this.enrolIdGenerator, this);
        this.enrollmentState.init(true, onlineUpdate, docUpdate, isOffLineDocumentUpdate);
        this.setEnrollmentLocale(this.clientLangCode);
    }

    private void clearAllListeners() {
        this.pinCodeLoadedListeners = new ArrayList<Consumer>();
        this.poCodeLoadedListeners = new ArrayList<Consumer>();
        this.tabTransitionListeners = new ArrayList<Consumer<Integer>>();
        this.viewLoadCompleteListeners = new ArrayList<Consumer>();
        this.tabDisableListeners = new ArrayList<Consumer<Boolean>>();
    }

    private void reset() {
        this.updatedBitValues = new StringBuilder("0000000000000000");
        this.clearAllListeners();
        this.appointment = null;
    }

    public EID getEnrolId() {
        return this.enrollmentState != null ? this.enrollmentState.getEnrolId() : null;
    }

    public void setClientLangCode(String langCode) {
        this.clientLangCode = langCode;
    }

    public Demographics getDemographics() {
        return this.enrollmentState.getDemographics();
    }

    public PersonalDetail getDemoPersonalDetails() {
        return this.enrollmentState.getDemographics().getPersonalDetail();
    }

    public Contact getDemoContactDetails() {
        return this.enrollmentState.getDemographics().getContact();
    }

    public ResidentialStatus getDemoResidentialStatus() {
        return this.enrollmentState.getDemographics().getResidentialStatus();
    }

    public PacDetail getPacDetail() {
        return this.pacDetail;
    }

    public void setPacDetail(PacDetail pacDetail) {
        this.pacDetail = pacDetail;
    }

    public Brn getBrnDetails() {
        return this.getDemographics().getBrnDetails();
    }

    public References getReferences() {
        return this.enrollmentState.getReferences();
    }

    public BiometricsException getBiometricsException() {
        return this.enrollmentState.getBiometricsException();
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getBiometricsTrailMap() {
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> captureTrail = this.isUpdateEnrollment() && !this.isRDBasedUpdate() ? this.enrollmentState.getBiometricsTrailMapForUpdate() : (this.isRDBasedUpdate() ? this.enrollmentState.getRDBiometricsTrailMap() : this.enrollmentState.getBiometricsTrailMap());
        return captureTrail;
    }

    public Map<CaptureModality, BiometricsCaptureTrail> getBiometricsExceptionTrailMap() {
        return this.enrollmentState.getBiometricsExceptionTrailMap();
    }

    public boolean getIsExceptionPhotoUploaded() {
        return this.isExceptionPhotoUploaded;
    }

    public void setIsExceptionPhotoUploaded(boolean isExceptionPhotoUploaded) {
        this.isExceptionPhotoUploaded = isExceptionPhotoUploaded;
    }

    public FingerPrint getFingerPrint() {
        return this.enrollmentState.getFingerPrint();
    }

    public Iris getIris() {
        return this.enrollmentState.getIris();
    }

    public boolean isChildEnrollment() {
        return this.enrollmentState.isChildEnrollment();
    }

    public void setChildEnrollment(boolean childEnrollment) {
        this.enrollmentState.setChildEnrollment(childEnrollment);
    }

    public boolean isAdultEnrollment() {
        return this.enrollmentState.isAdultEnrollment();
    }

    public void setAdultEnrollment(boolean adultEnrollment) {
        this.enrollmentState.setAdultEnrollment(adultEnrollment);
    }

    public boolean isMinorEnrollment() {
        return this.enrollmentState.isMinorEnrollment();
    }

    public void setMinorEnrollment(boolean minorEnrollment) {
        this.enrollmentState.setMinorEnrollment(minorEnrollment);
    }

    public boolean isBiometricUpdate() {
        return this.enrollmentState.isBiometricUpdate() || this.enrollmentState.isMandatoryBiometricUpdate();
    }

    public void setBiometricUpdate(boolean biometricUpdate) {
        this.enrollmentState.setBiometricUpdate(biometricUpdate);
    }

    public boolean isMandatoryBiometricUpdate() {
        return this.enrollmentState.isMandatoryBiometricUpdate();
    }

    public void setMandatoryBiometricUpdate(boolean mandatoryBiometricUpdate) {
        this.enrollmentState.setMandatoryBiometricUpdate(mandatoryBiometricUpdate);
    }

    public MbuStatus getMbuStatus() {
        return this.mbuStatus;
    }

    public void setMbuStatus(MbuStatus mbuStatus) {
        this.mbuStatus = mbuStatus;
    }

    public ConfirmerDetails getConfirmerDetails() {
        return this.enrollmentState.getConfirmerDetails();
    }

    public void recordTabChanged(int fromTabIndex, int toTabIndex) {
        EnrolStep fromStep = EnrolStepUtil.getEnrolStep(fromTabIndex);
        EnrolStep toStep = EnrolStepUtil.getEnrolStep(toTabIndex);
        EnrolStepInfo esi = new EnrolStepInfo(fromStep, toStep);
        this.enrollmentState.getEnrolSteps().add(esi);
    }

    public List<EnrolStepInfo> getEnrolSteps() {
        return this.enrollmentState.getEnrolSteps();
    }

    public long getStartTime() {
        return this.enrollmentState.getStartTime();
    }

    public long getEndTime() {
        return this.enrollmentState.getEndTime();
    }

    public String getAppointmentId() {
        return this.appointment != null ? this.appointment.getAppointmentId() : null;
    }

    public void setIsNRIEnrolment(boolean isNRI) {
        this.enrollmentState.setIsNRIEnrolment(isNRI);
    }

    public boolean isNRIEnrolment() {
        return this.enrollmentState != null && this.enrollmentState.isNRIEnrolment();
    }

    public boolean isDocumentUpdate() {
        return this.enrollmentState != null && this.enrollmentState.isDocUpdate();
    }

    public boolean isOffLineDocumentUpdate() {
        return this.enrollmentState != null && this.enrollmentState.isOffLineDocUpdate();
    }

    public String getNPRNumber() {
        return this.getDemoPersonalDetails().getNpr().getNprNumber();
    }

    public DocumentsManager getDocManager() {
        return this.enrollmentState.getDocMan();
    }

    public EnrollmentUploadResponse uploadEnrollmentData(OnlineEnrollmentRequest onlineEnrollmentRequest) throws IOException {
        String sessionKey = new String(Base64.getEncoder().encode(this.sessionService.getSessionKey()));
        return this.ecmpApiService.uploadEnrollmentData(onlineEnrollmentRequest, sessionKey);
    }

    public void addOnDocSuccessListener(Runnable delegate) {
        this.docSuccessListener = delegate;
    }

    public void addForeignTypeListener(Runnable delegate) {
        this.foreignTypeListener = delegate;
    }

    public void fireForeignTypeSuccess() {
        this.foreignTypeListener.run();
    }

    public String getDemographicsOverride() {
        return this.enrollmentState.getDemographicsOverride();
    }

    public Photograph getPhotograph() {
        return this.enrollmentState.getPhotograph();
    }

    public Map<DocumentType, String> getXmlData() {
        return this.xmlData;
    }

    public MandatoryBiometricCheckResponse getMandatoryBiometricCheckResponse() {
        return this.mandatoryBiometricCheckResponse;
    }

    public EID generateEid() {
        this.enrollmentState.generateEnrolmentId();
        String numberofEid = "";
        try {
            String data = this.enrollmentState.getEnrolId().toString();
            this.missingEIDFile = new MissingEIDFile("./data/stationData.txt");
            if (this.missingEIDFile.exists()) {
                numberofEid = new String(this.missingEIDFile.readWithRecover());
                LOGGER.info("EID==" + numberofEid);
                data = numberofEid + "," + data;
                byte[] inMemoryConfig = data.getBytes(StandardCharsets.UTF_8);
                this.missingEIDFile = new MissingEIDFile("./data/stationData.txt");
                this.missingEIDFile.write(inMemoryConfig);
            } else {
                byte[] inMemoryConfig = data.getBytes(StandardCharsets.UTF_8);
                this.missingEIDFile = new MissingEIDFile("./data/stationData.txt");
                this.missingEIDFile.write(inMemoryConfig);
            }
        }
        catch (Exception e) {
            LOGGER.error("error while writing missing EID: {}", (Object)e.getMessage());
        }
        return this.enrollmentState.getEnrolId();
    }

    public MandatoryBiometricCheckResponse performMandatoryBiometricCheck(String idType, String aadhaarNumber) throws IOException {
        MandatoryBiometricCheckResponse mandatoryBiometricCheckResponse;
        this.mandatoryBiometricCheckResponse = new MandatoryBiometricCheckResponse();
        this.mandatoryBiometricCheckResponse = mandatoryBiometricCheckResponse = this.ecmpApiService.doMandatoryBiometricCheck((EcmpRequest)new MandatoryBiometricCheckRequest(idType, aadhaarNumber));
        return mandatoryBiometricCheckResponse;
    }

    public UidStatusCheckResponse performMandatoryCountCheck(Id id) throws IOException {
        UidStatusCheckResponse uidStatusCheckResponse;
        this.uidStatusCheckResponse = new UidStatusCheckResponse();
        this.uidStatusCheckResponse = uidStatusCheckResponse = this.ecmpApiService.doUpdateContCheck((EcmpRequest)new UidStatusCheckRequest(id));
        return uidStatusCheckResponse;
    }

    public ReferenceRelative getRelativeDetails() {
        return this.enrollmentState.getReferences().getReferenceRelative();
    }

    public boolean isUpdateEnrollment() {
        return this.enrollmentState.isUpdateEnrollment();
    }

    public void setHofEnrollment(boolean isHof) {
        this.enrollmentState.setHofEnrollment(isHof);
    }

    public void setDocumentBasedEnrollment(boolean isDocBased) {
        this.enrollmentState.setDocumentBasedEnrollment(isDocBased);
    }

    public boolean isDocumentBasedEnrollment() {
        return this.enrollmentState.isDocumentBasedEnrollment();
    }

    public boolean isOnlineUpdate() {
        return this.enrollmentState != null && this.enrollmentState.isOnlineUpdate();
    }

    public void setOnlineUpdate(boolean onlineUpdate) {
        this.enrollmentState.setOnlineUpdate(onlineUpdate);
        this.enrollmentState.setRDBasedUpdate(onlineUpdate);
        this.enrollmentState.setPhotographCaptureEnabled(!onlineUpdate);
        this.enrollmentState.setAppointmentBasedFlow(onlineUpdate);
        this.enrollmentState.setSupervisorCaptureRequired(!onlineUpdate);
        this.enrollmentState.setBiometricUpdateAllowed(!onlineUpdate);
        this.enrollmentState.setPACValidationRequired(onlineUpdate);
        this.enrollmentState.setLanguageOnlyUpdate(onlineUpdate);
        this.enrollmentState.setFindAadhaar(onlineUpdate);
        this.setSid("");
    }

    public void setPACValidationRequired(boolean required) {
        this.enrollmentState.setPACValidationRequired(required);
    }

    public boolean isRDBasedUpdate() {
        return this.enrollmentState.isRDBasedUpdate();
    }

    public boolean isPhotographCaptureEnabled() {
        return this.enrollmentState.isPhotographCaptureEnabled();
    }

    public boolean isAppointmentBasedFlow() {
        return this.enrollmentState.isAppointmentBasedFlow();
    }

    public boolean isSupervisorCaptureRequired() {
        return this.enrollmentState.isSupervisorCaptureRequired();
    }

    public boolean isSupervisorAuthRequired() {
        return !Strings.isNullOrEmpty((String)this.enrollmentState.getGrievanceId()) || this.enrollmentState.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied();
    }

    public boolean isPACValidationRequired() {
        return this.enrollmentState.isPACValidationRequired();
    }

    public boolean isBiometricUpdateAllowed() {
        return this.enrollmentState.isBiometricUpdateAllowed();
    }

    public UpdateType getUpdateType() {
        return this.enrollmentState.getUpdateType();
    }

    public boolean isLanguageOnlyUpdate() {
        return this.enrollmentState.isLanguageOnlyUpdate();
    }

    public boolean isFindAadhaar() {
        return this.enrollmentState.isFindAadhaar();
    }

    public boolean isSessionInitialed() {
        return this.enrollmentState != null;
    }

    public boolean isNameFieldEnable() {
        return this.enrollmentState.isNameFieldEnable();
    }

    public boolean isAadhaarFieldEnable() {
        return this.enrollmentState.isAadhaarFieldEnable();
    }

    public boolean isChildEnrolmentEnable() {
        return this.enrollmentState.isChildEnrolmentEnable();
    }

    public boolean isUpdateBioMetricEnable() {
        return this.enrollmentState.isUpdateBioMetricEnable();
    }

    public boolean isMandatoryBioMetricEnable() {
        return this.enrollmentState.isMandatoryBioMetricEnable();
    }

    public void updateTabState(int tabId, boolean tabEnabled) {
        this.enrollmentState.updateTabState(tabId, tabEnabled);
    }

    public boolean isTabEnabled(int tabId) {
        return this.enrollmentState.isTabEnabled(tabId);
    }

    public void setEnrollmentLocale(String clientLangCode) {
        Locale locale = UidLocaleUtils.getLocaleFromLangCode((int)Integer.parseInt(clientLangCode));
        this.enrollmentState.setEnrollmentLocale(locale);
        this.enrollmentResourceBundleContext.setLocale(locale);
    }

    public String getEnrollmentLangCode() {
        return this.enrollmentState.getLangCode();
    }

    public void resetDocumentsFromModel() {
        this.enrollmentState.getDocMan().reset();
    }

    public StringBuilder getUpdatedBitValues() {
        return this.updatedBitValues;
    }

    public void setUpdatedBitValues(StringBuilder updatedBitValues) {
        this.updatedBitValues = updatedBitValues;
    }

    public void setUpdateType(boolean isNewEnrollmentUc) {
        this.enrollmentState.setUpdateType(isNewEnrollmentUc ? UpdateType.UC_ENROLLMENT : UpdateType.UC_UPDATE);
    }

    public boolean isNewEnrollmentUC() {
        return this.enrollmentState.getUpdateType().equals((Object)UpdateType.UC_ENROLLMENT);
    }

    public boolean isHofEnrollment() {
        return this.enrollmentState.isHofEnrollment();
    }

    public void setForeignResident(boolean isForeignResident) {
        this.enrollmentState.setForeignResident(isForeignResident);
    }

    public boolean isForeignResident() {
        return this.enrollmentState != null && this.enrollmentState.isForeignResident();
    }

    public boolean isDemoUpdate() {
        return this.enrollmentState.isDemoUpdate();
    }

    public boolean isMobileOnlyUpdate() {
        return this.enrollmentState.isDemoUpdate() && !this.getFieldsUpdateCount().getName().hasToBeUpdated() && !this.getFieldsUpdateCount().getAddress().hasToBeUpdated() && !this.getFieldsUpdateCount().getDob().hasToBeUpdated() && !this.getFieldsUpdateCount().getEmail().hasToBeUpdated() && !this.getFieldsUpdateCount().getGender().hasToBeUpdated() && !this.getFieldsUpdateCount().getLanguage().hasToBeUpdated() && this.getFieldsUpdateCount().getMobile().hasToBeUpdated();
    }

    public FieldsUpdateCount getFieldsUpdateCount() {
        return this.enrollmentState.getFieldsUpdateCount();
    }

    public String getSid() {
        return this.enrollmentState.getsId();
    }

    public void setGrievanceId(String grievanceId) {
        this.enrollmentState.setGrievanceId(grievanceId);
    }

    public String getGrievanceId() {
        return this.enrollmentState.getGrievanceId();
    }

    public void setLinkedEid(String eid) {
        this.enrollmentState.setLinkedEid(eid);
    }

    public String getLinkedEid() {
        return this.enrollmentState.getLinkedEid();
    }

    public String getSupervisorAuthUrl() {
        return this.enrollmentState.getSupervisorAuthUrl();
    }

    public void setSupervisorAuthUrl(String supervisorAuthUrl) {
        this.enrollmentState.setSupervisorAuthUrl(supervisorAuthUrl);
    }

    public void initiateUCOnline() {
        this.enrollmentState = new EnrollmentState(this);
        this.setEnrollmentLocale(this.clientLangCode);
    }

    public void initiateNewSession(OperatorDetails operatorDetails) {
        this.oAuthSessionService = new OAuthSessionService(operatorDetails);
        this.updateOperatorDetails(this.oAuthSessionService.getOperatorDetails());
    }

    public OauthGWService getOauthGwApiService() {
        return this.oauthGwApiService;
    }

    public void addOnBioLoginFailureListener(Consumer<String> delegate) {
        this.bioLoginFailureListener = delegate;
    }

    public void countScreenListener(Runnable delegate) {
        this.countScreenListener = delegate;
    }

    public void residentUpdateInfoSuccessListener(Runnable delegate) {
        this.residentUpdateInfoSuccessListener = delegate;
    }

    public void grievanceStatusListener(Runnable delegate) {
        this.grievanceStatusListener = delegate;
    }

    public void operatorConfirmationListener(Runnable delegate) {
        this.operatorConfirmationListener = delegate;
    }

    public BioAuthResponse bioRDAuth(AuthWrapper25Request bioverifyRequest, boolean isOperator) {
        return this.oauthGwApiService.verifyBiometricsUC(bioverifyRequest, isOperator);
    }

    public LogoutResponse operatorLogout() {
        return this.oauthGwApiService.operatorLogout();
    }

    public void clearOperatorDetails() {
        OperatorDetails operatorDetails = new OperatorDetails();
        operatorDetails.setOpName("");
        operatorDetails.setOperatorId("");
        this.updateOperatorDetails(operatorDetails);
    }

    public BioAuthResponse bioAuth(AuthWrapperRequest req, boolean isOperator) {
        return this.oauthGwApiService.doBioAuth(req, isOperator);
    }

    public void fireBioLoginFailure() {
        if (this.bioLoginFailureListener != null) {
            this.bioLoginFailureListener.accept(null);
        }
    }

    public BioAuth16Response bioRDAuthConfirmEnrol(BioAuth25Request req) {
        req.setTxnId(this.oauthGwApiService.getTransactionId());
        Boolean biometricsException = this.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied();
        Boolean bothIrisException = this.getBiometricsException().getExceptionDetail().isBothEyesExceptionApplied();
        Boolean allFingersException = this.getBiometricsException().getExceptionDetail().isRightSlapExceptionApplied() && this.getBiometricsException().getExceptionDetail().isLeftSlapExceptionApplied() && this.getBiometricsException().getExceptionDetail().isBothThumbsExceptionApplied();
        return this.oauthGwApiService.doRDBioAuthConfirmEnrol(req, this.getSid(), this.getRefId(), biometricsException, bothIrisException, allFingersException);
    }

    public void fetchRegionsOfInterest(DocumentType docType, String docId) throws OnlineGatewayException {
        List<LabelDetail> rois = this.onlineDocumentService.getRoiLables(docType.value(), docId);
        this.enrollmentState.setRoiLabelList(docType, rois);
    }

    public void resetRoiEnabled() {
        this.enrollmentState.resetRoiLabelList();
    }

    public String getRefId() {
        return this.enrollmentState.getRefId();
    }

    public BioAuth16Response bioAuthConfirmEnrol(BioAuth16Request req) {
        req.setTxnId(this.oauthGwApiService.getTransactionId());
        Boolean biometricsException = this.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied();
        Boolean bothIrisException = this.getBiometricsException().getExceptionDetail().isBothEyesExceptionApplied();
        Boolean allFingersException = this.getBiometricsException().getExceptionDetail().isRightSlapExceptionApplied() && this.getBiometricsException().getExceptionDetail().isLeftSlapExceptionApplied() && this.getBiometricsException().getExceptionDetail().isBothThumbsExceptionApplied();
        return this.oauthGwApiService.doBioAuthConfirmEnrol(req, this.getSid(), this.getRefId(), biometricsException, bothIrisException, allFingersException);
    }

    public IOAuthSessionService getOAuthSessionService() {
        return this.oAuthSessionService;
    }

    public String getAckSlip() {
        return this.enrollmentState.getAcknowledgementSlip();
    }

    public void setAckSlip(String ackSlip) {
        this.enrollmentState.setAcknowledgementSlip(ackSlip);
    }

    public byte[] getAckSlipBytes() {
        return this.enrollmentState.getAcknowledgementSlipBytes();
    }

    public void setAckSlipBytes(byte[] ackSlip) {
        this.enrollmentState.setAcknowledgementSlipBytes(ackSlip);
    }

    public String getResidentUid() {
        return this.enrollmentState.getResidentUid();
    }

    public void setSid(String sId) {
        this.enrollmentState.setsId(sId);
        this.updateNewSid(sId);
    }

    private void updateNewSid(String sid) {
        this.newUpdateFlowListeners.forEach(listener -> listener.accept(sid));
    }

    public void updateOperatorDetails(OperatorDetails operatorDetails) {
        this.displayOperatorDetails.forEach(listner -> listner.accept(operatorDetails));
    }

    public void initiateUcEnrollment(boolean isPacValid) {
        this.reset();
        this.enrollmentState = new EnrollmentState(this);
        this.enrollmentState.initUC(true, isPacValid);
        this.setSid("");
        this.setEnrollmentLocale(this.clientLangCode);
    }

    public void initiateUcUpdate(String residentUid, boolean isPacValid) {
        this.reset();
        this.enrollmentState = new EnrollmentState(residentUid, this);
        this.enrollmentState.initUC(false, isPacValid);
        this.setSid("");
        this.setEnrollmentLocale(this.clientLangCode);
    }

    public void setDemoUpdate(boolean demoUpdate) {
        this.enrollmentState.setDemoUpdate(demoUpdate);
    }

    public void setDocumentUpdate(boolean documentUpdate) {
        this.enrollmentState.setDocUpdate(documentUpdate);
    }

    public void setRDBasedUpdate(boolean isRDBased) {
        this.enrollmentState.setRDBasedUpdate(isRDBased);
    }

    public void countScreenSuccess() {
        this.countScreenListener.run();
    }

    public void residentUpdateInfoSuccess() {
        this.residentUpdateInfoSuccessListener.run();
    }

    public void grievanceStatusSuccess() {
        this.grievanceStatusListener.run();
    }

    public void operatorConfirmationSucess() {
        this.operatorConfirmationListener.run();
    }

    public void setRefId(String refId) {
        this.enrollmentState.setRefId(refId);
    }

    public boolean getIsPobRequired() {
        return this.enrollmentState.getIsPobRequired();
    }

    public void setConsentCountDownLatch(CountDownLatch consentCountDownLatch) {
        this.consentCountDownLatch = consentCountDownLatch;
    }

    public CountDownLatch getConsentCountDownLatch() {
        return this.consentCountDownLatch;
    }

    public void setHofUid(String uid) {
        this.enrollmentState.setHofUid(uid);
    }

    public String getHofUid() {
        return this.enrollmentState.getHofUid();
    }

    public void updateDemographicsDataInEnrolment(UcDemographicServiceProto.ProfileDataResponse profileData, IPinCodeService pinCodeService) {
        Demographics demoGraphics = this.getDemographics();
        Contact contact = demoGraphics.getContact();
        this.setEnrollmentLocale(profileData.getLanguageCode());
        boolean doesProfileHasIndianAddress = Strings.isNullOrEmpty((String)profileData.getAddress().getAddressL1());
        boolean demographicsPopulateRequired = this.isUpdateUC();
        boolean addressPopulateRequired = this.isUpdateUC() || this.isHofEnrollment();
        boolean isContactPopulateRequired = this.isUpdateUC();
        if (this.isHofEnrollment() && this.doesNriHaveForeignAddress() == doesProfileHasIndianAddress) {
            LOGGER.warn("HOF address type is not matching with resident selected address type");
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_ADDS_001, (String)this.getTransactionId(), (Exception)new Exception());
        }
        if (this.isUpdateUC()) {
            this.setIsNRIEnrolment(profileData.getIsNRI());
            this.setNriHaveForeignAddress(!doesProfileHasIndianAddress);
            this.setForeignResident(profileData.getIsResidentForeigner());
        }
        if (demographicsPopulateRequired) {
            PersonalDetail personalDetail = demoGraphics.getPersonalDetail();
            personalDetail.setFullName(profileData.getName());
            personalDetail.setFullNameLocal(profileData.getLocalName());
            personalDetail.setAadhaarNumber(profileData.getUid());
            personalDetail.getApplicantGender().setExistingGender(profileData.getGender());
            personalDetail.getApplicantConfirmGender().setExistingGender(profileData.getGender());
            String[] ymd = profileData.getDob().split("-");
            personalDetail.getAgeDob().setExistingDob(ymd[2], ymd[1], ymd[0]);
        }
        if (isContactPopulateRequired) {
            this.setContactInfo(profileData, contact);
        }
        if (addressPopulateRequired) {
            if (doesProfileHasIndianAddress) {
                this.setIndianAddress(profileData, demoGraphics, pinCodeService);
            } else {
                ForeignNRI foreignNRI = demoGraphics.getContact().getForeignNriAddress();
                foreignNRI.setExistingAddressOne(profileData.getAddress().getAddressL1());
                foreignNRI.setExistingAddressTwo(profileData.getAddress().getAddressL2());
                foreignNRI.setExistingLocalAddressOne(profileData.getAddress().getLocalAddressL1());
                foreignNRI.setExistingLocalAddressTwo(profileData.getAddress().getLocalAddressL2());
                String[] line3Pincode = profileData.getAddress().getAddressL3().split(",");
                String[] localLine3Pincode = profileData.getAddress().getLocalAddressL3().split(",");
                if (line3Pincode.length > 0) {
                    foreignNRI.setExistingAddressThree(line3Pincode[0]);
                }
                if (localLine3Pincode.length > 0) {
                    foreignNRI.setExistingLocalAddressThree(localLine3Pincode[0]);
                }
                if (line3Pincode.length > 1) {
                    foreignNRI.setExistingZipcode(line3Pincode[1]);
                }
                foreignNRI.setExistingCountry(new Country(profileData.getAddress().getCountry(), profileData.getAddress().getCountry()));
            }
        }
        if (this.isHofEnrollment()) {
            Address address = contact.getAddress();
            address.setExistingCareOfName(profileData.getName());
            address.setExistingCareOfNameLocal(profileData.getLocalName());
            this.setHofName(profileData.getName());
            this.setHofNameLocal(profileData.getLocalName());
        }
    }

    private void setIndianAddress(UcDemographicServiceProto.ProfileDataResponse profileData, Demographics demoGraphics, IPinCodeService pinCodeService) {
        Address address = demoGraphics.getContact().getAddress();
        if (StringUtils.isNotBlank((String)profileData.getAddress().getCareOf())) {
            String careof = profileData.getAddress().getCareOf().replaceAll("(?i)(C|D|S|W)\\/O *:?", "").trim();
            String localCareof = profileData.getAddress().getLocalCo().replaceAll("(?i)(C|D|S|W)\\/O *:?", "").trim();
            address.setExistingCareOfName(careof);
            address.setExistingCareOfNameLocal(localCareof);
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getHouse()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalHouse())) {
            address.setExistingBuilding(profileData.getAddress().getHouse());
            address.setExistingBuildingLocal(profileData.getAddress().getLocalHouse());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getStreet()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalStreet())) {
            address.setExistingStreet(profileData.getAddress().getStreet());
            address.setExistingStreetLocal(profileData.getAddress().getLocalStreet());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getLandmark()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalLandmark())) {
            address.setExistingLandmark(profileData.getAddress().getLandmark());
            address.setExistingLandmarkLocal(profileData.getAddress().getLocalLandmark());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getLocality()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalLocality())) {
            address.setExistingLocality(profileData.getAddress().getLocality());
            address.setExistingLocalityLocal(profileData.getAddress().getLocalLocality());
        }
        PinCodeDetail pinCodeDetail = address.getPinCodeDetail();
        if (StringUtils.isNotBlank((String)profileData.getAddress().getStateCode()) && StringUtils.isNotBlank((String)profileData.getAddress().getState()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalState())) {
            pinCodeDetail.getState().setExistingAddressCode(profileData.getAddress().getStateCode());
            pinCodeDetail.getState().setExistingAddressValue(profileData.getAddress().getState());
            pinCodeDetail.getState().setExistingAddressValueLocal(profileData.getAddress().getLocalState());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getDistrictCode()) && StringUtils.isNotBlank((String)profileData.getAddress().getDistrict()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalDistrict())) {
            pinCodeDetail.getDistrict().setExistingAddressCode(profileData.getAddress().getDistrictCode());
            pinCodeDetail.getDistrict().setExistingAddressValue(profileData.getAddress().getDistrict());
            pinCodeDetail.getDistrict().setExistingAddressValueLocal(profileData.getAddress().getLocalDistrict());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getSubDistrict())) {
            pinCodeDetail.getSubDistrict().setExistingAddressCode(profileData.getAddress().getSubDistrictCode());
            pinCodeDetail.getSubDistrict().setExistingAddressValue(profileData.getAddress().getSubDistrict());
            pinCodeDetail.getSubDistrict().setExistingAddressValueLocal(profileData.getAddress().getLocalSubDistrict());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getVillageCode()) && StringUtils.isNotBlank((String)profileData.getAddress().getVtc()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalVtc())) {
            pinCodeDetail.getVtc().setExistingAddressCode(profileData.getAddress().getVillageCode());
            pinCodeDetail.getVtc().setExistingAddressValue(profileData.getAddress().getVtc());
            pinCodeDetail.getVtc().setExistingAddressValueLocal(profileData.getAddress().getLocalVtc());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getPincode())) {
            pinCodeDetail.getPinCode().setExistingAddressCode(profileData.getAddress().getPincode());
            pinCodeDetail.getPinCode().setExistingAddressValue(profileData.getAddress().getPincode());
            pinCodeDetail.getPinCode().setExistingAddressValueLocal(profileData.getAddress().getPincode());
            pinCodeDetail.setExistingPoPinCode(profileData.getAddress().getPincode());
        }
        if (StringUtils.isNotBlank((String)profileData.getAddress().getPo()) && StringUtils.isNotBlank((String)profileData.getAddress().getLocalPo())) {
            pinCodeDetail.setExistingPoName(profileData.getAddress().getPo());
            pinCodeDetail.setExistingDefaultPoName(profileData.getAddress().getPo());
            pinCodeDetail.setExistingPoNameLocal(profileData.getAddress().getLocalPo());
            PostOffice postOffice = pinCodeService.findPostOffice(profileData.getAddress().getPincode(), profileData.getAddress().getVillageCode(), profileData.getAddress().getPo());
            pinCodeDetail.setExistingPoType(postOffice != null ? postOffice.getType() : PostOfficeType.SUB_OFFICE);
        } else if (this.isHofEnrollment()) {
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_ADDS_003, (String)this.getTransactionId(), (Exception)new Exception());
        }
    }

    private void setContactInfo(UcDemographicServiceProto.ProfileDataResponse profileData, Contact contact) {
        if (StringUtils.isNotBlank((String)profileData.getMobile())) {
            contact.getMobile().setExistingNumber(profileData.getMobile());
            contact.getMobile().setIsdCode("+91");
        }
        if (StringUtils.isNotBlank((String)profileData.getEmail())) {
            contact.getEmail().setExistingEmail(profileData.getEmail());
        }
    }

    public Integer getNextScannedDocumentId() {
        return this.enrollmentState.getNextScannedDocumentId();
    }

    public List<LabelDetail> getRoiList(DocumentType documentType) {
        return this.enrollmentState.getRoiLabelList(documentType);
    }

    public boolean isRoiEnabled(DocumentType documentType) {
        List<LabelDetail> roiList = this.enrollmentState.getRoiLabelList(documentType);
        return roiList != null && roiList.size() > 0;
    }

    public void setPobRequired(boolean isPobRequired) {
        this.enrollmentState.setIsPobRequired(isPobRequired);
        this.getDemoPersonalDetails().getAgeDob().setVerifiedUC(isPobRequired);
    }

    public void populateProofDocuments(String foreignType, String modeType, String ageGroup) throws OnlineGatewayException {
        this.onlineDocumentService.setProofDocuments(foreignType, modeType, ageGroup);
        this.onlineDocumentService.prepareBroadCastList(this);
    }

    public boolean isDocumentPresent(String foreignType, String modeType, String ageGroup) {
        return this.onlineDocumentService.isDocumentPresent(foreignType, modeType, ageGroup);
    }

    public void populateBrnStates() throws OnlineGatewayException {
        this.onlineDocumentService.setBrnStates();
    }

    public void populateNationalities() throws OnlineGatewayException {
        this.onlineDocumentService.setForeignNationalities();
    }

    public void newSidListener(Consumer<String> newSidCosumer) {
        if (newSidCosumer == null) {
            return;
        }
        this.newUpdateFlowListeners.add(newSidCosumer);
    }

    public void displayOperatorDetails(Consumer<OperatorDetails> opDetails) {
        if (opDetails == null) {
            return;
        }
        this.displayOperatorDetails.add(opDetails);
    }

    public void clearEnrollmentState() {
        this.enrollmentState = null;
    }

    public boolean isEnrolmentStateNull() {
        return this.enrollmentState == null;
    }

    public void cancelProcess(String sid) {
        this.oauthGwApiService.cancelCall(sid);
    }

    public void fireDocUploadSuccess() {
        this.docSuccessListener.run();
    }

    public OnlineDocumentService getOnlineDocumentService() {
        return this.onlineDocumentService;
    }

    public void setOnlineDocumentService(OnlineDocumentService onlineDocumentService) {
        this.onlineDocumentService = onlineDocumentService;
    }

    public DigilockerDocument getDigilockerDocuments() {
        return this.digilockerDocuments;
    }

    public void setDigilockerDocuments(DigilockerDocument digilockerDocuments) {
        this.digilockerDocuments = digilockerDocuments;
    }

    public String getDocumentFetchType() {
        return this.documentFetchType;
    }

    public void setDocumentFetchType(String documentFetchType) {
        this.documentFetchType = documentFetchType;
    }

    public ValuesDocumentModel getValuesDocumentModel() {
        return this.valuesDocumentModel;
    }

    public void setValuesDocumentModel(ValuesDocumentModel valuesDocumentModel) {
        this.valuesDocumentModel = valuesDocumentModel;
    }

    public String getTransactionId() {
        return this.oauthGwApiService.getTransactionId();
    }

    public boolean isUniversalClientTrnx() {
        return this.enrollmentState != null && (this.enrollmentState.getUpdateType().equals((Object)UpdateType.UC_ENROLLMENT) || this.enrollmentState.getUpdateType().equals((Object)UpdateType.UC_UPDATE));
    }

    public boolean isUpdateUC() {
        return this.enrollmentState.getUpdateType().equals((Object)UpdateType.UC_UPDATE);
    }

    public boolean doesNriHaveForeignAddress() {
        return this.enrollmentState.isNriHaveForeignAddress();
    }

    public boolean isAadhaarActive() {
        return this.isUpdateUC() && this.enrollmentState.isAadhaarActive();
    }

    public void setAadhaarActive(boolean aadhaarActive) {
        this.enrollmentState.setAadhaarActive(aadhaarActive);
    }

    public void setNriHaveForeignAddress(boolean nriHaveForeignAddress) {
        this.enrollmentState.setNriHaveForeignAddress(nriHaveForeignAddress);
        this.enrollmentState.getDemographics().getContact().getForeignNriAddress().setMandatory(nriHaveForeignAddress);
    }

    public String getHofName() {
        return this.enrollmentState.getHofName();
    }

    public void setHofName(String hofName) {
        this.enrollmentState.setHofName(hofName);
    }

    public String getHofNameLocal() {
        return this.enrollmentState.getHofNameLocal();
    }

    public void setHofNameLocal(String hofNameLocal) {
        this.enrollmentState.setHofNameLocal(hofNameLocal);
    }

    public Appointment getAppointment() {
        return this.enrollmentState.getAppointment();
    }

    public void clearMemory() {
        if (this.enrollmentState != null) {
            if (this.getPhotograph() != null) {
                this.getPhotograph().getPhoto().clearAttempts();
            }
            if (this.getFingerPrint() != null) {
                this.getFingerPrint().reset();
            }
            if (this.getIris() != null) {
                this.getIris().reset();
            }
            this.getDocManager().resetUC();
        }
    }

    public boolean isHofConsentGoingOn() {
        return this.enrollmentState.isHofConsentGoingOn();
    }

    public void setHofConsentGoingOn(boolean hofConsentGoingOn) {
        this.enrollmentState.setHofConsentGoingOn(hofConsentGoingOn);
    }
}

