/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment;

import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrollment.IEnrolmentIDGenerator;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolmentIDGenerator
implements IEnrolmentIDGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrolmentIDGenerator.class);
    private IRegistrationService registrationService;

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @Override
    public synchronized EID generate() {
        LOGGER.debug("generate EID method called");
        EID eid = new EID(Integer.parseInt(this.registrationService.getAgencyId()), Integer.parseInt(this.registrationService.getStationId()), (int)this.registrationService.getNextEnrolIDSequence());
        LOGGER.info("EnrolmentIDGenerator : generate - EID " + eid);
        return eid;
    }

    @Override
    public long getCurrentSequenceValue() {
        return this.registrationService.getCurrentEnrolIDSequence();
    }
}

