/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import org.apache.commons.lang.StringUtils;

public class AadhaarNo
extends EnrolmentModelBase<AadhaarNo> {
    private String aadhaarNumber = "";
    private String aadhaarNumberError;

    AadhaarNo(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.setValid(!enrollmentService.isUpdateEnrollment());
        this.setMandatory(enrollmentService.isUpdateEnrollment());
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getFormattedAadhaarNumber() {
        return this.aadhaarNumber.substring(0, 4) + "-" + this.aadhaarNumber.substring(4, 8) + "-" + this.aadhaarNumber.substring(8);
    }

    public String getAadhaarNumberError() {
        return this.aadhaarNumberError;
    }

    private void validate() {
        this.validateAadhaarNumber();
        this.setValid(this.aadhaarNumberError == null);
    }

    private void validateAadhaarNumber() {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (this.isMandatory()) {
            if (StringUtils.isBlank((String)this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.aadhaarNumber.startsWith("0") || this.aadhaarNumber.startsWith("1")) {
                aadhaarErrorMsgKey = MsgKeysILV.ZERO;
            } else if (!Verhoeff.validate((String)this.aadhaarNumber)) {
                aadhaarErrorMsgKey = MsgKeysILV.UID;
            }
        }
        this.aadhaarNumberError = this.getMessage((Object)aadhaarErrorMsgKey, new Object[0]);
    }
}

