/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.PinCodeDetail;
import in.gov.uidai.ec.service.enrollment.model.PinCodeElement;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostOfficeType;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class Address
extends EnrolmentModelBase<Address> {
    private static final String COUNTRY_CODE = "356";
    private static final String COUNTRY_NAME = "India";
    private final PinCodeDetail pinCodeDetail = new PinCodeDetail();
    private String careOfName = "";
    private String existingCareOfName = "";
    private String careOfNameLocal = "";
    private String existingCareOfNameLocal = "";
    private boolean nameTransliterationMismatch;
    private String building = "";
    private String existingBuilding = "";
    private String buildingLocal = "";
    private String existingBuildingLocal = "";
    private String street = "";
    private String existingStreet = "";
    private String streetLocal = "";
    private String existingStreetLocal = "";
    private String landmark = "";
    private String existingLandmark = "";
    private String landmarkLocal = "";
    private String existingLandmarkLocal = "";
    private String locality = "";
    private String existingLocality = "";
    private String localityLocal = "";
    private String existingLocalityLocal = "";
    private String buildingLabel = "";
    private String buildingLabelLocal = "";
    private String streetLabel = "";
    private String streetLabelLocal = "";
    private String landmarkLabel = "";
    private String landmarkLabelLocal = "";
    private String localityLabel = "";
    private String localityLabelLocal = "";
    private String careOfNameError;
    private String careOfNameLocalError;
    private String buildingError;
    private String buildingLocalError;
    private String streetError;
    private String streetLocalError;
    private String landmarkError;
    private String landmarkLocalError;
    private String localityError;
    private String localityLocalError;
    private String postOfficeError;
    private String postOfficeLocalError;
    private String defaultPostOfficeError;
    private String defaultPostOfficeLocalError;

    Address(EnrollmentService enrollmentService) {
        super(enrollmentService);
        if (enrollmentService.isUniversalClientTrnx()) {
            super.setMandatory(enrollmentService.isNewEnrollmentUC() && !enrollmentService.doesNriHaveForeignAddress() || enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated());
        } else {
            super.setMandatory(!enrollmentService.isUpdateEnrollment());
        }
        this.validate();
    }

    public String getCareOf() {
        return "C/O";
    }

    public String getCareOfLocal() {
        return this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.careof", new Object[0]);
    }

    public String getCareOfName() {
        return this.careOfName;
    }

    public void setCareOfName(String careOfName) {
        this.careOfName = StringUtils.trim((String)careOfName);
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.careOfName, this.careOfNameLocal);
        this.validate();
        super.fireChangeEvent(this);
    }

    public String getCareOfNameForDisplay() {
        return StringUtils.isNotBlank((String)this.careOfName) ? this.careOfName : this.existingCareOfName;
    }

    public String getCareOfNameLocal() {
        return this.careOfNameLocal;
    }

    public void setCareOfNameLocal(String careOfNameLocal) {
        this.careOfNameLocal = StringUtils.trim((String)careOfNameLocal);
        this.nameTransliterationMismatch = super.isTransliterationDiffValid(this.careOfName, this.careOfNameLocal);
        this.validate();
        super.fireChangeEvent(this);
    }

    public boolean hasTransliterationMismatchForName() {
        return this.nameTransliterationMismatch;
    }

    public String getCareOfNameLocaleForDisplay() {
        if (StringUtils.isNotBlank((String)this.careOfNameLocal)) {
            return this.careOfNameLocal;
        }
        return this.existingCareOfNameLocal;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
        this.validate();
        super.fireChangeEvent(this);
    }

    public String getBuildingLocal() {
        return this.buildingLocal;
    }

    public void setBuildingLocal(String buildingLocal) {
        this.buildingLocal = buildingLocal;
        this.validate();
        super.fireChangeEvent(this);
    }

    public String getDisplayBuilding() {
        return StringUtils.isNotBlank((String)this.building) ? this.building : this.existingBuilding;
    }

    public String getDisplayBuildingLocal() {
        return StringUtils.isNotBlank((String)this.buildingLocal) ? this.buildingLocal : this.existingBuildingLocal;
    }

    public String getBuildingLabel() {
        return this.buildingLabel;
    }

    public void setBuildingLabel(String buildingLabel) {
        this.buildingLabel = buildingLabel;
        super.fireChangeEvent(this);
    }

    public String getBuildingLabelLocal() {
        return this.buildingLabelLocal;
    }

    public void setBuildingLabelLocal(String buildingLabelLocal) {
        this.buildingLabelLocal = buildingLabelLocal;
        this.fireChangeEvent(this);
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getStreetLocal() {
        return this.streetLocal;
    }

    public void setStreetLocal(String streetLocal) {
        this.streetLocal = streetLocal;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getDisplayStreet() {
        return StringUtils.isNotBlank((String)this.street) ? this.street : this.existingStreet;
    }

    public String getDisplayStreetLocal() {
        return StringUtils.isNotBlank((String)this.streetLocal) ? this.streetLocal : this.existingStreetLocal;
    }

    public String getStreetLabel() {
        return this.streetLabel;
    }

    public void setStreetLabel(String streetLabel) {
        this.streetLabel = streetLabel;
        this.fireChangeEvent(this);
    }

    public String getStreetLabelLocal() {
        return this.streetLabelLocal;
    }

    public void setStreetLabelLocal(String streetLabelLocal) {
        this.streetLabelLocal = streetLabelLocal;
        this.fireChangeEvent(this);
    }

    public String getLandmark() {
        return this.landmark;
    }

    public void setLandmark(String landmark) {
        this.landmark = landmark;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getLandmarkLocal() {
        return this.landmarkLocal;
    }

    public void setLandmarkLocal(String landmarkLocal) {
        this.landmarkLocal = landmarkLocal;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getLandmarkLabel() {
        return this.landmarkLabel;
    }

    public void setLandmarkLabel(String landmarkLabel) {
        this.landmarkLabel = landmarkLabel;
        this.fireChangeEvent(this);
    }

    public String getDisplayLandmark() {
        return StringUtils.isNotBlank((String)this.landmark) ? this.landmark : this.existingLandmark;
    }

    public String getDisplayLandmarkLocal() {
        return StringUtils.isNotBlank((String)this.landmarkLocal) ? this.landmarkLocal : this.existingLandmarkLocal;
    }

    public String getLandmarkLabelLocal() {
        return this.landmarkLabelLocal;
    }

    public void setLandmarkLabelLocal(String landmarkLabelLocal) {
        this.landmarkLabelLocal = landmarkLabelLocal;
        this.fireChangeEvent(this);
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getLocalityLocal() {
        return this.localityLocal;
    }

    public void setLocalityLocal(String localityLocal) {
        this.localityLocal = localityLocal;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getDisplayLocality() {
        return StringUtils.isNotBlank((String)this.locality) ? this.locality : this.existingLocality;
    }

    public String getDisplayLocalityLocal() {
        return StringUtils.isNotBlank((String)this.localityLocal) ? this.localityLocal : this.existingLocalityLocal;
    }

    public String getLocalityLabel() {
        return this.localityLabel;
    }

    public void setLocalityLabel(String localityLabel) {
        this.localityLabel = localityLabel;
        this.fireChangeEvent(this);
    }

    public String getLocalityLabelLocal() {
        return this.localityLabelLocal;
    }

    public void setLocalityLabelLocal(String localityLabelLocal) {
        this.localityLabelLocal = localityLabelLocal;
        this.fireChangeEvent(this);
    }

    public String getPoName() {
        return this.pinCodeDetail.getPoNameEnglish();
    }

    public String getExistingPoName() {
        return this.pinCodeDetail.getExistingPoNameEnglish();
    }

    public String getPoNameLocal() {
        return this.pinCodeDetail.getPoNameLocal();
    }

    public String getExistingPoNameLocal() {
        return this.pinCodeDetail.getExistingPoNameLocal();
    }

    public String getDisplayPoName() {
        return this.pinCodeDetail.getPoNameForDisplay();
    }

    public String getDisplayPoNameLocal() {
        return this.pinCodeDetail.getPoNameLocalForDisplay();
    }

    public String getDefaultPoName() {
        return this.pinCodeDetail.getDefaultPoName();
    }

    public PostOfficeType getPoType() {
        return this.pinCodeDetail.getPoType();
    }

    public String getPoPinCode() {
        return this.pinCodeDetail.getPoPinCode();
    }

    public String getDistrictLocal() {
        return this.pinCodeDetail.getDistrict().getAddressValueLocal();
    }

    public void setDistrictLocal(String districtLocal) {
        this.pinCodeDetail.getDistrict().setAddressValueLocal(districtLocal);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingDistrictLocal() {
        return this.pinCodeDetail.getDistrict().getExistingAddressValueLocal();
    }

    public String getDisplayDistrictLocal() {
        return this.pinCodeDetail.getDistrict().getDisplayValueLocal();
    }

    public String getDistrictLocalError() {
        return this.pinCodeDetail.getDistrict().getAddressValueLocalError();
    }

    public String getSubDistrictLocal() {
        return this.pinCodeDetail.getSubDistrict().getAddressValueLocal();
    }

    public void setSubDistrictLocal(String subDistrictLocal) {
        this.pinCodeDetail.getSubDistrict().setAddressValueLocal(subDistrictLocal);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingSubDistrictLocal() {
        return this.pinCodeDetail.getSubDistrict().getExistingAddressValueLocal();
    }

    public String getDisplaySubDistrictLocal() {
        return this.pinCodeDetail.getSubDistrict().getDisplayValueLocal();
    }

    public PinCodeDetail getPinCodeDetail() {
        return this.pinCodeDetail;
    }

    public void setPinCodeDetail(PinCodeDetail pinCodeDetail) {
        this.pinCodeDetail.setPoName(pinCodeDetail.getDefaultPoName());
    }

    public String getSubDistrictLocalError() {
        return this.pinCodeDetail.getSubDistrict().getAddressValueLocalError();
    }

    public String getState() {
        return this.pinCodeDetail.getState().getAddressValue();
    }

    public void setState(PostalAddressElement state) {
        this.pinCodeDetail.getState().setAddressValue(state);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingState() {
        return this.pinCodeDetail.getState().getExistingAddressValue();
    }

    public String getStateCode() {
        return this.pinCodeDetail.getState().getAddressCode();
    }

    public String getStateLocal() {
        return this.pinCodeDetail.getState().getAddressValueLocal();
    }

    public void setStateLocal(String stateLocal) {
        this.pinCodeDetail.getState().setAddressValueLocal(stateLocal);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingStateLocal() {
        return this.pinCodeDetail.getState().getExistingAddressValueLocal();
    }

    public String getDisplayState() {
        return this.pinCodeDetail.getState().getDisplayValueEnglish();
    }

    public String getDisplayStateLocal() {
        return this.pinCodeDetail.getState().getDisplayValueLocal();
    }

    public String getStateLocalError() {
        return this.pinCodeDetail.getState().getAddressValueLocalError();
    }

    public String getVTC() {
        return this.pinCodeDetail.getVtc().getAddressValue();
    }

    public void setVTC(PostalAddressElement vtc) {
        this.pinCodeDetail.getVtc().setAddressValue(vtc);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingVTC() {
        return this.pinCodeDetail.getVtc().getExistingAddressValue();
    }

    public String getVTCCode() {
        return this.pinCodeDetail.getVtc().getAddressCode();
    }

    public String getVTCLocal() {
        return this.pinCodeDetail.getVtc().getAddressValueLocal();
    }

    public void setVTCLocal(String vtcLocal) {
        this.pinCodeDetail.getVtc().setAddressValueLocal(vtcLocal);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingVTCLocal() {
        return this.pinCodeDetail.getVtc().getExistingAddressValueLocal();
    }

    public String getDisplayVTC() {
        return this.pinCodeDetail.getVtc().getDisplayValueEnglish();
    }

    public String getDisplayVTCLocal() {
        return this.pinCodeDetail.getVtc().getDisplayValueLocal();
    }

    public String getVTCLocalError() {
        return this.pinCodeDetail.getVtc().getAddressValueLocalError();
    }

    public String getPinCode() {
        return this.pinCodeDetail.getPinCode().getAddressCode();
    }

    public void setPinCode(PostalAddressElement pinCode) {
        this.pinCodeDetail.getPinCode().setAddressValue(pinCode);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getPinCodeValue() {
        return this.pinCodeDetail.getPinCode().getAddressValue();
    }

    public String getExistingPinCodeValue() {
        return this.pinCodeDetail.getPinCode().getExistingAddressValue();
    }

    public String getPinCodeLocal() {
        return this.pinCodeDetail.getPinCode().getAddressValueLocal();
    }

    public void setPinCodeLocal(String pinCodeLocal) {
        this.pinCodeDetail.getPinCode().setAddressValueLocal(pinCodeLocal);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getDisplayPinCodeValue() {
        return this.pinCodeDetail.getPinCode().getDisplayValueEnglish();
    }

    public String getDisplayPinCodeLocal() {
        return this.pinCodeDetail.getPinCode().getDisplayValueLocal();
    }

    public String getExistingDistrict() {
        return this.pinCodeDetail.getDistrict().getExistingAddressValue();
    }

    public String getDisplayDistrict() {
        return this.pinCodeDetail.getDistrict().getDisplayValueEnglish();
    }

    public String getDistrict() {
        return this.pinCodeDetail.getDistrict().getAddressValue();
    }

    public void setDistrict(PostalAddressElement district) {
        this.pinCodeDetail.getDistrict().setAddressValue(district);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getDistrictCode() {
        return this.pinCodeDetail.getDistrict().getAddressCode();
    }

    public String getSubDistrict() {
        return this.pinCodeDetail.getSubDistrict().getAddressValue();
    }

    public void setSubDistrict(PostalAddressElement subDistrict) {
        this.pinCodeDetail.getSubDistrict().setAddressValue(subDistrict);
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getExistingSubDistrict() {
        return this.pinCodeDetail.getSubDistrict().getExistingAddressValue();
    }

    public String getDisplaySubDistrict() {
        return this.pinCodeDetail.getSubDistrict().getDisplayValueEnglish();
    }

    public String getSubDistrictCode() {
        return this.pinCodeDetail.getSubDistrict().getAddressCode();
    }

    public String getCountryCode() {
        return COUNTRY_CODE;
    }

    public String getCountryName() {
        return COUNTRY_NAME;
    }

    public void setAddressType(String addressType) {
    }

    public String getCareOfNameError() {
        return this.careOfNameError;
    }

    public String getCareOfNameLocalError() {
        return this.careOfNameLocalError;
    }

    public String getBuildingError() {
        return this.buildingError;
    }

    public String getBuildingLocalError() {
        return this.buildingLocalError;
    }

    public String getStreetError() {
        return this.streetError;
    }

    public String getStreetLocalError() {
        return this.streetLocalError;
    }

    public String getLandmarkError() {
        return this.landmarkError;
    }

    public String getLandmarkLocalError() {
        return this.landmarkLocalError;
    }

    public String getLocalityError() {
        return this.localityError;
    }

    public String getLocalityLocalError() {
        return this.localityLocalError;
    }

    public String getPostOfficeError() {
        return this.postOfficeError;
    }

    public String getPostOfficeLocalError() {
        return this.postOfficeLocalError;
    }

    public String getDefaultPostOfficeError() {
        return this.defaultPostOfficeError;
    }

    public String getDefaultPostOfficeLocalError() {
        return this.defaultPostOfficeLocalError;
    }

    public String getLocationCode() {
        StringBuilder locationCode = new StringBuilder();
        if (this.getPinCode() != null && this.getDistrict() != null && this.getSubDistrict() != null) {
            locationCode.append(this.pinCodeDetail.getState().getAddressCode()).append(this.pinCodeDetail.getDistrict().getAddressCode()).append(this.pinCodeDetail.getSubDistrict().getAddressCode()).append(this.pinCodeDetail.getVtc().getAddressCode()).append(this.pinCodeDetail.getPinCode().getAddressCode());
        }
        return locationCode.toString();
    }

    public String getFormattedAddress(boolean isLocalised) {
        StringBuilder formattedAddress = new StringBuilder();
        if (isLocalised) {
            this.formatAddress(formattedAddress, this.buildingLocal, this.streetLocal, this.landmarkLocal, this.localityLocal);
            formattedAddress.append(this.getVTCLocal()).append(", ").append(this.getPoNameLocal()).append(", ").append(this.getSubDistrictLocal()).append(", ").append(this.getDistrictLocal()).append(", ").append(this.getStateLocal()).append(", ").append(this.getPinCodeValue());
        } else {
            this.formatAddress(formattedAddress, this.building, this.street, this.landmark, this.locality);
            formattedAddress.append(this.getVTC()).append(", ").append(this.getPoName()).append(", ").append(this.getSubDistrict()).append(", ").append(this.getDistrict()).append(", ").append(this.getState()).append(", ").append(this.getPinCodeValue());
        }
        return formattedAddress.toString();
    }

    public String getExistingFormattedAddress(boolean isLocalised) {
        StringBuilder formattedAddress = new StringBuilder();
        if (isLocalised) {
            this.formatAddress(formattedAddress, this.existingBuildingLocal, this.existingStreetLocal, this.existingLandmarkLocal, this.existingLocalityLocal);
            formattedAddress.append(this.getExistingVTCLocal()).append(", ").append(this.getExistingPoNameLocal()).append(", ").append(this.getExistingSubDistrictLocal()).append(", ").append(this.getExistingDistrictLocal()).append(", ").append(this.getExistingStateLocal()).append(", ").append(this.getExistingPinCodeValue());
        } else {
            this.formatAddress(formattedAddress, this.existingBuilding, this.existingStreet, this.existingLandmark, this.existingLocality);
            formattedAddress.append(this.getExistingVTC()).append(", ").append(this.getExistingPoName()).append(", ").append(this.getExistingSubDistrict()).append(", ").append(this.getExistingDistrict()).append(", ").append(this.getExistingState()).append(", ").append(this.getExistingPinCodeValue());
        }
        return formattedAddress.toString();
    }

    private void formatAddress(StringBuilder formattedAddress, String building, String street, String landmark, String locality) {
        if (StringUtils.isNotBlank((String)building)) {
            formattedAddress.append(building).append(", ");
        }
        if (StringUtils.isNotBlank((String)street)) {
            formattedAddress.append(street).append(", ");
        }
        if (StringUtils.isNotBlank((String)landmark)) {
            formattedAddress.append("(").append(landmark).append(") ");
        }
        if (StringUtils.isNotBlank((String)locality)) {
            formattedAddress.append(locality).append(", ");
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.validate();
        this.fireChangeEvent(this);
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        super.setUpdatedBit(updated, BitIdentifierSelection.ADDRESSBIT.getBitIndentifier());
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    public void setPostalAddress(PostalAddress postalAddress) {
        if (postalAddress == null) {
            postalAddress = new PostalAddress();
        }
        this.setDistrict(postalAddress.getDistrict());
        this.setSubDistrict(postalAddress.getSubDistrict());
        this.setState(postalAddress.getState());
        this.setPinCode(postalAddress.getPinCode());
        this.setVTC(postalAddress.getVtc());
        this.fireChangeEvent(this);
    }

    public void setPostOffice(PostOffice postOffice) {
        if (postOffice == null) {
            postOffice = new PostOffice();
        }
        this.pinCodeDetail.setPoName(postOffice.getName());
        this.pinCodeDetail.setPoNameLocal(postOffice.getLocaleName());
        this.pinCodeDetail.setPoPinCode(postOffice.getPincode());
        this.pinCodeDetail.setPoType(postOffice.getType());
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setDefaultPo(String defaultPo) {
        this.pinCodeDetail.setDefaultPoName(defaultPo);
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setPostOfficeLocal(String postOfficeLocal) {
        this.pinCodeDetail.setPoNameLocal(postOfficeLocal);
        this.validate();
        this.fireChangeEvent(this);
    }

    public void setExistingCareOfName(String existingCareOfName) {
        this.existingCareOfName = existingCareOfName;
    }

    public void setExistingCareOfNameLocal(String existingCareOfNameLocal) {
        this.existingCareOfNameLocal = existingCareOfNameLocal;
    }

    public void setExistingBuilding(String existingBuilding) {
        this.existingBuilding = existingBuilding;
    }

    public void setExistingBuildingLocal(String existingBuildingLocal) {
        this.existingBuildingLocal = existingBuildingLocal;
    }

    public void setExistingStreet(String existingStreet) {
        this.existingStreet = existingStreet;
    }

    public void setExistingStreetLocal(String existingStreetLocal) {
        this.existingStreetLocal = existingStreetLocal;
    }

    public void setExistingLandmark(String existingLandmark) {
        this.existingLandmark = existingLandmark;
    }

    public void setExistingLandmarkLocal(String existingLandmarkLocal) {
        this.existingLandmarkLocal = existingLandmarkLocal;
    }

    public void setExistingLocality(String existingLocality) {
        this.existingLocality = existingLocality;
    }

    public void setExistingLocalityLocal(String existingLocalityLocal) {
        this.existingLocalityLocal = existingLocalityLocal;
    }

    private void validate() {
        this.validateCareOfName();
        this.validateBuilding();
        this.validateStreet();
        this.validateLandmark();
        this.validateLocality();
        this.validateVTC();
        this.validatePostOffice();
        this.validateDefaultPostOffice();
        this.validatePinCode();
        this.validateDistrict();
        this.validateSubDistrict();
        this.validateState();
        this.validateAddressChange();
        this.reEvaluateAddressValidity();
    }

    private void validateAddressChange() {
        if (this.isMandatory() && this.enrollmentService.isUpdateEnrollment() && this.getFormattedAddress(false).equals(this.getExistingFormattedAddress(false)) && this.getFormattedAddress(true).equals(this.getExistingFormattedAddress(true)) && this.careOfName.equals(this.existingCareOfName) && this.careOfNameLocal.equals(this.existingCareOfNameLocal)) {
            MsgKeysILV errorMsgKey = MsgKeysILV.ADDR_SAME_OR_EMPTY;
            this.careOfNameError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.careOfNameLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.buildingError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.buildingLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.streetError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.streetLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.landmarkError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.landmarkLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.localityError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.localityLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.postOfficeError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.postOfficeLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
            this.pinCodeDetail.getPinCode().setAddressValueError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getVtc().setAddressValueError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getSubDistrict().setAddressValueError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getDistrict().setAddressValueError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getState().setAddressValueError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getPinCode().setAddressValueLocalError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getVtc().setAddressValueLocalError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getSubDistrict().setAddressValueLocalError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getDistrict().setAddressValueLocalError(this.getMessage((Object)errorMsgKey, new Object[0]));
            this.pinCodeDetail.getState().setAddressValueLocalError(this.getMessage((Object)errorMsgKey, new Object[0]));
        }
    }

    private void validateCareOfName() {
        this.validateCareOfNameEnglish();
        this.validateCareOfNameLocal();
        this.reEvaluateAddressValidity();
    }

    private void validateCareOfNameEnglish() {
        MsgKeysILV errorMsgKey = null;
        if (this.isMandatory() && !this.careOfName.equals("") && StringUtils.isBlank((String)this.careOfName)) {
            errorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.careOfNameError = this.getMessage((Object)errorMsgKey, new Object[0]);
    }

    private void validateCareOfNameLocal() {
        MsgKeysILV errorMsgKey = null;
        if (this.isMandatory() && !this.careOfName.equals("") && StringUtils.isBlank((String)this.careOfNameLocal)) {
            errorMsgKey = MsgKeysILV.MANDATORY;
        }
        this.careOfNameLocalError = this.getMessage((Object)errorMsgKey, new Object[0]);
    }

    private void validateBuilding() {
        this.validateMandatoryIfBothElement(this.building, this.buildingLocal, (englishError, localError) -> {
            this.buildingError = englishError;
            this.buildingLocalError = localError;
        });
        this.reEvaluateAddressValidity();
    }

    private void validateStreet() {
        this.validateMandatoryIfBothElement(this.street, this.streetLocal, (englishError, localError) -> {
            this.streetError = englishError;
            this.streetLocalError = localError;
        });
        this.reEvaluateAddressValidity();
    }

    private void validateLandmark() {
        this.validateMandatoryIfBothElement(this.landmark, this.landmarkLocal, (englishError, localError) -> {
            this.landmarkError = englishError;
            this.landmarkLocalError = localError;
        });
        this.reEvaluateAddressValidity();
    }

    private void validateLocality() {
        this.validateMandatoryIfBothElement(this.locality, this.localityLocal, (englishError, localError) -> {
            this.localityError = englishError;
            this.localityLocalError = localError;
        });
        this.reEvaluateAddressValidity();
    }

    private void validateVTC() {
        PinCodeElement vtc = this.pinCodeDetail.getVtc();
        this.validateMandatoryElement(vtc.getAddressValue(), vtc.getAddressValueLocal(), (englishError, localError) -> {
            vtc.setAddressValueError((String)englishError);
            vtc.setAddressValueLocalError((String)localError);
        });
        this.reEvaluateAddressValidity();
    }

    private void validatePostOffice() {
        this.validateMandatoryElement(this.getPoName(), this.getPoNameLocal(), (englishError, localError) -> {
            this.postOfficeError = englishError;
            this.postOfficeLocalError = localError;
        });
        this.reEvaluateAddressValidity();
    }

    private void validateDefaultPostOffice() {
        this.validateMandatoryElement(this.getDefaultPoName(), this.getDefaultPoName(), (englishError, localError) -> {
            this.defaultPostOfficeError = englishError;
            this.defaultPostOfficeLocalError = localError;
        });
        this.reEvaluateAddressValidity();
    }

    private void validateDistrict() {
        PinCodeElement district = this.pinCodeDetail.getDistrict();
        this.validateMandatoryElement(this.getDistrict(), this.getDistrictLocal(), (englishError, localError) -> {
            district.setAddressValueError((String)englishError);
            district.setAddressValueLocalError((String)localError);
        });
        this.reEvaluateAddressValidity();
    }

    private void validateSubDistrict() {
        PinCodeElement subDistrict = this.pinCodeDetail.getSubDistrict();
        this.validateMandatoryElement(this.getDistrict(), this.getDistrictLocal(), (englishError, localError) -> {
            subDistrict.setAddressValueError((String)englishError);
            subDistrict.setAddressValueLocalError((String)localError);
        });
        this.reEvaluateAddressValidity();
    }

    private void validatePinCode() {
        PinCodeElement pinCode = this.pinCodeDetail.getPinCode();
        this.validateMandatoryElement(pinCode.getAddressValue(), pinCode.getAddressValueLocal(), (englishError, localError) -> {
            pinCode.setAddressValueError((String)englishError);
            pinCode.setAddressValueLocalError((String)localError);
        });
        this.reEvaluateAddressValidity();
    }

    private void validateState() {
        PinCodeElement state = this.pinCodeDetail.getState();
        this.validateMandatoryElement(state.getAddressValue(), state.getAddressValueLocal(), (englishError, localError) -> {
            state.setAddressValueError((String)englishError);
            state.setAddressValueLocalError((String)localError);
        });
        this.reEvaluateAddressValidity();
    }

    private void validateMandatoryIfBothElement(String englishField, String localField, BiConsumer<String, String> delegate) {
        MsgKeysILV errorEnglishMsgKey = null;
        MsgKeysILV errorLocalMsgKey = null;
        if (StringUtils.isBlank((String)englishField) && !StringUtils.isBlank((String)localField)) {
            errorEnglishMsgKey = MsgKeysILV.MANDATORY_IF;
        }
        if (StringUtils.isBlank((String)localField) && !StringUtils.isBlank((String)englishField)) {
            errorLocalMsgKey = MsgKeysILV.MANDATORY_IF;
        }
        delegate.accept(this.getMessage((Object)errorEnglishMsgKey, new Object[0]), this.getMessage((Object)errorLocalMsgKey, new Object[0]));
    }

    private void validateMandatoryElement(String englishField, String localField, BiConsumer<String, String> delegate) {
        MsgKeysILV errorEnglishMsgKey = null;
        MsgKeysILV errorLocalMsgKey = null;
        if (this.isMandatory()) {
            if (StringUtils.isBlank((String)englishField) || StringUtils.equals((String)englishField, (String)"Select")) {
                errorEnglishMsgKey = MsgKeysILV.MANDATORY;
            }
            if (StringUtils.isBlank((String)localField)) {
                errorLocalMsgKey = MsgKeysILV.MANDATORY;
            }
        }
        delegate.accept(this.getMessage((Object)errorEnglishMsgKey, new Object[0]), this.getMessage((Object)errorLocalMsgKey, new Object[0]));
    }

    private void reEvaluateAddressValidity() {
        this.validateAddressChange();
        if (this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated()) {
            this.setValid(this.allFieldvalid() && this.valueChanged());
        } else {
            this.setValid(this.allFieldvalid());
        }
    }

    private boolean allFieldvalid() {
        return this.careOfNameError == null && this.careOfNameLocalError == null && this.buildingError == null && this.buildingLocalError == null && this.streetError == null && this.streetLocalError == null && this.landmarkError == null && this.landmarkLocalError == null && this.localityError == null && this.localityLocalError == null && this.postOfficeError == null && this.postOfficeLocalError == null && this.defaultPostOfficeError == null && this.defaultPostOfficeLocalError == null && this.pinCodeDetail.isValid();
    }

    public void reset() {
        this.setCareOfName("");
        this.setCareOfNameLocal("");
        this.setBuilding("");
        this.setBuildingLocal("");
        this.setStreet("");
        this.setStreetLocal("");
        this.setLandmark("");
        this.setLandmarkLocal("");
        this.setLocality("");
        this.setLocalityLocal("");
        this.pinCodeDetail.reset();
        this.setBuildingLabel("");
        this.setBuildingLabelLocal("");
        this.setStreetLabel("");
        this.setStreetLabelLocal("");
        this.setLandmarkLabel("");
        this.setLandmarkLabelLocal("");
        this.setLocalityLabel("");
        this.setLocalityLabelLocal("");
        this.careOfNameError = "";
        this.careOfNameLocalError = "";
        this.buildingError = "";
        this.buildingLocalError = "";
        this.streetError = "";
        this.streetLocalError = "";
        this.landmarkError = "";
        this.landmarkLocalError = "";
        this.localityError = "";
        this.localityLocalError = "";
        this.postOfficeError = "";
        this.postOfficeLocalError = "";
        super.fireChangeEvent(this);
    }

    public void setToExistingAddress() {
        this.setCareOfName(this.existingCareOfName);
        this.setCareOfNameLocal(this.existingCareOfNameLocal);
        this.setBuilding(this.existingBuilding);
        this.setBuildingLocal(this.existingBuildingLocal);
        this.setStreet(this.existingStreet);
        this.setStreetLocal(this.existingStreetLocal);
        this.setLandmark(this.existingLandmark);
        this.setLandmarkLocal(this.existingLandmarkLocal);
        this.setLocality(this.existingLocality);
        this.setLocalityLocal(this.existingLocalityLocal);
        this.pinCodeDetail.setToExistingPinCode();
        this.validate();
    }

    public boolean valueChanged() {
        return !this.careOfName.equals(this.existingCareOfName) || !this.building.equals(this.existingBuilding) || !this.street.equals(this.existingStreet) || !this.landmark.equals(this.existingLandmark) || !this.locality.equals(this.existingLocality) || this.pinCodeDetail.addressValueChanged();
    }
}

