/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysEnrol;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import in.gov.uidai.ec.service.packetgenerator.xml.StatusType;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class AgeDob
extends EnrolmentModelBase<AgeDob> {
    public static final int CHILD_MAX_AGE = 5;
    private static final int MAX_AGE = 120;
    private static final int AGE_WARNING_AT = 100;
    private static final int MINOR_MAX_AGE = 18;
    private int age = -1;
    private int day = -1;
    private int existingDay = -1;
    private int month = -1;
    private int existingMonth = -1;
    private int year = -1;
    private int existingYear = -1;
    private boolean isDobSelected;
    private boolean isVerified;
    private String ageDobLocal;
    private String ageError;
    private String dayError;
    private String monthError;
    private String yearError;
    private String ageWarning;
    private String ageCheckError;

    AgeDob(EnrollmentService enrollmentService) {
        super(enrollmentService);
        if (enrollmentService.isUniversalClientTrnx()) {
            this.setMandatory(enrollmentService.isNewEnrollmentUC() || enrollmentService.getFieldsUpdateCount().getDob().hasToBeUpdated());
        } else {
            super.setMandatory(!enrollmentService.isUpdateEnrollment());
        }
        if (enrollmentService.isUpdateEnrollment()) {
            this.isDobSelected = true;
            enrollmentService.addResidentChildListeners(this::onChildUpdateChange);
        }
        this.validate();
    }

    private void onChildUpdateChange(Boolean childUpdate) {
        this.validate();
    }

    public Integer getAge() {
        if (this.isDobSelected()) {
            return this.deriveAgeFromDob();
        }
        return this.age;
    }

    public void setAge(String age) {
        if (!this.isDobSelected()) {
            GregorianCalendar cal = new GregorianCalendar();
            this.age = this.parseIntField(age);
            this.validate();
            if (this.isValid()) {
                this.day = 1;
                this.month = 1;
                this.year = cal.get(1) - this.age;
            } else {
                this.reset();
            }
            super.fireChangeEvent(this);
        }
    }

    public Integer getDay() {
        if (this.enrollmentService.isNewEnrollmentUC()) {
            return this.day;
        }
        if (this.enrollmentService.isOnlineUpdate()) {
            return this.isUpdated() ? this.day : this.existingDay;
        }
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public Integer getDayForDisplay() {
        return this.day > 0 ? this.day : this.existingDay;
    }

    public Integer getMonth() {
        if (this.enrollmentService.isNewEnrollmentUC()) {
            return this.month;
        }
        if (this.enrollmentService.isOnlineUpdate()) {
            return this.isUpdated() ? this.month : this.existingMonth;
        }
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public Integer getMonthForDisplay() {
        return this.month > 0 ? this.month : this.existingMonth;
    }

    public Integer getYear() {
        if (this.enrollmentService.isNewEnrollmentUC()) {
            return this.year;
        }
        if (this.enrollmentService.isOnlineUpdate()) {
            return this.isUpdated() ? this.year : this.existingYear;
        }
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Integer getYearForDisplay() {
        return this.year > 0 ? this.year : this.existingYear;
    }

    public boolean isDobSelected() {
        return this.isDobSelected;
    }

    public void setDobSelected(boolean isDobSelected) {
        if (this.isDobSelected == isDobSelected) {
            return;
        }
        this.isDobSelected = isDobSelected;
        this.reset();
        this.validate();
    }

    public boolean isEmpty() {
        if (this.isDobSelected()) {
            return this.day == -1 || this.month == -1 || this.year == -1;
        }
        return this.age == -1;
    }

    public boolean isChild() {
        if (this.isMandatory() && this.isValid()) {
            return this.getAge() >= 0 && this.getAge() < 5;
        }
        return this.enrollmentService.isChildEnrollment();
    }

    public boolean isMinor() {
        if (this.isMandatory() && this.isValid()) {
            return this.getAge() >= 5 && this.getAge() < 18;
        }
        return this.enrollmentService.isMinorEnrollment();
    }

    public boolean isAdult() {
        if (this.isMandatory() && this.isValid()) {
            return this.getAge() >= 18 && this.getAge() < 120;
        }
        return this.enrollmentService.isAdultEnrollment();
    }

    public boolean isOnlineChild() {
        return AgeDob.getAge(new Date(), this.existingYear, this.existingMonth, this.existingDay) >= 0 && AgeDob.getAge(new Date(), this.existingYear, this.existingMonth, this.existingDay) < 5;
    }

    public boolean isOnlineMinor() {
        return AgeDob.getAge(new Date(), this.existingYear, this.existingMonth, this.existingDay) >= 5 && AgeDob.getAge(new Date(), this.existingYear, this.existingMonth, this.existingDay) < 18;
    }

    public boolean isOnlineAdult() {
        return this.getAge() >= 18 && this.getAge() < 120;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public void setVerified(boolean verified) {
        this.isVerified = verified;
        super.fireChangeEvent(this);
    }

    public void setVerifiedUC(boolean verified) {
        this.isVerified = verified;
    }

    public String getAgeDobFormatted() {
        if (!this.isValid()) {
            return "";
        }
        GregorianCalendar dobOfResident = new GregorianCalendar(this.getYear(), this.getMonth() - 1, this.getDay());
        return ECMPDateFormatHelper.getDateStr(dobOfResident.getTime(), ECMPDateFormats.STANDARD_DATE_FORMAT);
    }

    public String getAgeDobFormattedUC() {
        if (!this.isValid()) {
            return "";
        }
        GregorianCalendar dobOfResident = new GregorianCalendar(this.getYear(), this.getMonth() - 1, this.getDay());
        return ECMPDateFormatHelper.getDateStr(dobOfResident.getTime(), ECMPDateFormats.STANDARD_DATE_FORMAT1);
    }

    public String getAgeDobFormattedUCReverse() {
        if (!this.isValid()) {
            return "";
        }
        GregorianCalendar dobOfResident = new GregorianCalendar(this.getYear(), this.getMonth() - 1, this.getDay());
        return ECMPDateFormatHelper.getDateStr(dobOfResident.getTime(), ECMPDateFormats.SHORT_DELIM_DATE_FORMAT);
    }

    public String getAgeDobLocal() {
        return this.ageDobLocal;
    }

    public void setAgeDobLocal(String ageDobLocal) {
        this.ageDobLocal = ageDobLocal;
    }

    public String getAgeError() {
        return this.ageError;
    }

    public String getAgeCheckError() {
        return this.ageCheckError;
    }

    public String getDayError() {
        if (this.dayError == null) {
            return this.ageCheckError;
        }
        return this.dayError;
    }

    public String getMonthError() {
        if (this.monthError == null) {
            return this.ageCheckError;
        }
        return this.monthError;
    }

    public String getYearError() {
        if (this.yearError == null) {
            return this.ageCheckError;
        }
        return this.yearError;
    }

    public boolean hasAgeWarning() {
        return this.ageWarning != null;
    }

    public String getAgeWarning() {
        return this.ageWarning;
    }

    public StatusType getStatus() {
        if (!this.isDobSelected()) {
            return StatusType.APPROXIMATE;
        }
        if (this.isVerified()) {
            return StatusType.VERIFIED;
        }
        return StatusType.DECLARED;
    }

    public String toString() {
        if (this.isValid() && this.day > 0 && this.month > 0 && this.year > 0) {
            return this.day + " " + this.month + " " + this.year;
        }
        return "";
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        super.setUpdatedBit(updated, BitIdentifierSelection.DOBBIT.getBitIndentifier());
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    public void setDob(String day, String month, String year) {
        if (this.isDobSelected()) {
            this.day = this.parseIntField(day);
            this.month = this.parseIntField(month);
            this.year = this.parseIntField(year);
            this.validate();
            super.fireChangeEvent(this);
        }
    }

    public void setDob(String dob) {
        if (StringUtils.isNotBlank((String)dob) && dob.length() == 10) {
            this.setDob(dob.substring(0, 2), dob.substring(3, 5), dob.substring(6, 10));
        }
    }

    private void validate() {
        this.validateDOBFields();
        this.validateAgeField();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.validateAgeFieldForUC();
            this.validateAge();
        }
        super.setValid(this.ageError == null && this.dayError == null && this.monthError == null && this.yearError == null && this.ageCheckError == null);
        this.ageWarning = this.getAge() >= 100 && this.getAge() < 120 ? this.getMessage((Object)MsgKeysEnrol.AGE_WARNING, new Object[0]) : null;
    }

    private void validateAge() {
        MsgKeysILV errorMsg = null;
        if (this.enrollmentService.isUpdateUC()) {
            return;
        }
        if (this.enrollmentService.isChildEnrollment() && this.getAge() >= 5) {
            errorMsg = MsgKeysILV.CHILD;
        } else if (this.enrollmentService.isMinorEnrollment() && (this.getAge() < 5 || this.getAge() > 17)) {
            errorMsg = MsgKeysILV.MINOR;
        } else if (!this.enrollmentService.isChildEnrollment() && !this.enrollmentService.isMinorEnrollment() && this.getAge() <= 17) {
            errorMsg = MsgKeysILV.ADULT;
        }
        this.ageCheckError = this.getMessage((Object)errorMsg, new Object[0]);
    }

    private void validateAgeField() {
        boolean ageSelected;
        MsgKeysILV ageErrorMsgKey = null;
        boolean bl = ageSelected = !this.isDobSelected();
        if (this.isMandatory() && ageSelected && this.age < 0) {
            ageErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && ageSelected && (this.age == 0 || this.age >= 18) && this.enrollmentService.getSessionService().isAgeValidationEnabled() && !this.enrollmentService.isUpdateEnrollment()) {
            ageErrorMsgKey = MsgKeysILV.EIGHTEEN;
        } else if (this.isMandatory() && ageSelected && (this.age == 0 || this.age >= 120)) {
            ageErrorMsgKey = MsgKeysILV.DOB;
        } else if (this.isMandatory() && this.isDobSelected() && this.getDay() > 0 && this.getMonth() > 0 && this.getYear() > 0 && this.deriveAgeFromDob() >= 18 && this.enrollmentService.getSessionService().isAgeValidationEnabled() && !this.enrollmentService.isUpdateEnrollment()) {
            ageErrorMsgKey = MsgKeysILV.EIGHTEEN;
        } else if (this.isMandatory() && this.isDobSelected() && this.getDay() > 0 && this.getMonth() > 0 && this.getYear() > 0 && this.deriveAgeFromDob() >= 120) {
            ageErrorMsgKey = MsgKeysILV.DOB;
        }
        this.ageError = this.getMessage((Object)ageErrorMsgKey, new Object[0]);
    }

    private void validateAgeFieldForUC() {
        boolean ageSelected;
        MsgKeysILV ageErrorMsgKey = null;
        boolean bl = ageSelected = !this.isDobSelected();
        if (this.isMandatory() && ageSelected && this.age < 0) {
            ageErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (this.isMandatory() && ageSelected && (this.age == 0 || this.age >= 120)) {
            ageErrorMsgKey = MsgKeysILV.DOB;
        } else if (this.isMandatory() && this.isDobSelected() && this.getDay() > 0 && this.getMonth() > 0 && this.getYear() > 0 && this.deriveAgeFromDob() >= 120) {
            ageErrorMsgKey = MsgKeysILV.DOB;
        }
        this.ageError = this.getMessage((Object)ageErrorMsgKey, new Object[0]);
    }

    private void validateDOBFields() {
        this.validateDay();
        this.validateMonth();
        this.validateYear();
    }

    private boolean isDateNotChanged() {
        return this.day == this.existingDay && this.month == this.existingMonth && this.year == this.existingYear;
    }

    private void validateDay() {
        MsgKeysILV dayErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            if (this.day < 0) {
                dayErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.day == 0 || this.day > 31 || this.month == 2 && this.day > 29) {
                dayErrorMsgKey = MsgKeysILV.DOB_DAY;
            } else if (this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11) {
                if (this.day > 30) {
                    dayErrorMsgKey = MsgKeysILV.DOB_DAY;
                }
            } else if (this.month == 2 && !this.checkIfLeapYear(this.year) && this.day > 28) {
                dayErrorMsgKey = MsgKeysILV.DOB_DAY;
            } else if (this.isDateNotChanged()) {
                dayErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.dayError = this.getMessage((Object)dayErrorMsgKey, new Object[0]);
    }

    private void validateMonth() {
        MsgKeysILV monthErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            if (this.month < 0) {
                monthErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.month == 0 || this.month > 12) {
                monthErrorMsgKey = MsgKeysILV.DOB_MONTH;
            } else if (this.isDateNotChanged()) {
                monthErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.monthError = this.getMessage((Object)monthErrorMsgKey, new Object[0]);
    }

    private void validateYear() {
        MsgKeysILV yearErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            GregorianCalendar cal = new GregorianCalendar(this.year, this.month - 1, this.day);
            if (this.year < 0) {
                yearErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.year == 0) {
                yearErrorMsgKey = MsgKeysILV.DOB_YEAR;
            } else if (cal.getTime().after(new Date())) {
                yearErrorMsgKey = MsgKeysILV.DOB;
            } else if (this.year == 0 || this.deriveAgeFromDob() < 0 || this.deriveAgeFromDob() >= 120) {
                yearErrorMsgKey = MsgKeysILV.DOB;
            } else if (this.enrollmentService.isChildEnrollment() && this.deriveAgeFromDob() >= 5) {
                yearErrorMsgKey = MsgKeysILV.DOB_CHILD;
            } else if (this.isDateNotChanged()) {
                yearErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.yearError = this.getMessage((Object)yearErrorMsgKey, new Object[0]);
    }

    private boolean checkIfLeapYear(int year) {
        if (year <= 0) {
            return false;
        }
        if (year % 400 == 0) {
            return true;
        }
        if (year % 100 == 0) {
            return false;
        }
        return year % 4 == 0;
    }

    private int deriveAgeFromDob() {
        GregorianCalendar dob = new GregorianCalendar(this.year, this.month - 1, this.day);
        Calendar enrolDate = Calendar.getInstance();
        int age = enrolDate.get(1) - dob.get(1);
        if (enrolDate.get(2) + 1 < dob.get(2) + 1) {
            --age;
        }
        if (enrolDate.get(2) + 1 == dob.get(2) + 1 && enrolDate.get(5) < dob.get(5)) {
            --age;
        }
        return age;
    }

    public AgeGroup getAgeGroup() {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (this.enrollmentService.isHofEnrollment() && !this.enrollmentService.isChildEnrollment() && !this.enrollmentService.isMinorEnrollment()) {
                return AgeGroup.ABOVE18;
            }
            if (this.enrollmentService.isChildEnrollment()) {
                return AgeGroup.BELOW5;
            }
            if (this.enrollmentService.isMinorEnrollment()) {
                return AgeGroup.BETWEEN5TO18;
            }
            if (this.enrollmentService.isForeignResident()) {
                return AgeGroup.ABOVE18;
            }
            return AgeGroup.ABOVE18;
        }
        if (this.isMinor()) {
            return AgeGroup.BETWEEN5TO18;
        }
        if (this.isChild()) {
            return AgeGroup.BELOW5;
        }
        return AgeGroup.ABOVE18;
    }

    public static int getAge(Date referenceDate, int dobYear, int dobMonth, int dobDay) {
        int years = 0;
        GregorianCalendar dob = new GregorianCalendar(dobYear, dobMonth - 1, dobDay);
        Calendar dateOfIssue = Calendar.getInstance();
        dateOfIssue.setTime(referenceDate);
        int yy = 0;
        while (dob.before(dateOfIssue)) {
            dob.add(1, 1);
            ++yy;
        }
        years = yy - 1;
        return years;
    }

    public AgeGroup getOnlineAgeGroup() {
        if (this.isOnlineMinor()) {
            return AgeGroup.BETWEEN5TO18;
        }
        if (this.isOnlineChild()) {
            return AgeGroup.BELOW5;
        }
        return AgeGroup.ABOVE18;
    }

    private int parseIntField(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setExistingDob(String existingDay, String existingMonth, String existingYear) {
        this.existingDay = this.parseIntField(existingDay);
        this.existingMonth = this.parseIntField(existingMonth);
        this.existingYear = this.parseIntField(existingYear);
        if (this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getDob().hasToBeUpdated()) {
            this.resetToExistingDate();
        }
    }

    public void resetToExistingDate() {
        this.day = this.existingDay;
        this.month = this.existingMonth;
        this.year = this.existingYear;
        if (this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getDob().hasToBeUpdated()) {
            this.validate();
        }
    }

    private void reset() {
        this.age = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
    }
}

