/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;

public class ApplicantConfirmGender
extends EnrolmentModelBase<ApplicantConfirmGender> {
    private Gender gender = Gender.NOT_GIVEN;
    private Gender existingGender = Gender.NOT_GIVEN;
    private String genderLocal = "";
    private String genderError;

    ApplicantConfirmGender(EnrollmentService enrollmentService) {
        super(enrollmentService);
        if (enrollmentService.isUniversalClientTrnx()) {
            this.setMandatory(enrollmentService.isNewEnrollmentUC() || enrollmentService.getFieldsUpdateCount().getGender().hasToBeUpdated());
        } else {
            super.setMandatory(!enrollmentService.isUpdateEnrollment());
        }
        this.validate();
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.validate();
        super.fireChangeEvent(this);
    }

    public String englishError() {
        return this.genderError;
    }

    public void setGenderLocal(String genderLocal) {
        this.genderLocal = genderLocal;
    }

    public Gender getExistingGender() {
        return this.existingGender;
    }

    public void setExistingGender(String existingGender) {
        this.existingGender = Gender.fromString(existingGender);
    }

    public Gender getDisplayGender() {
        return this.gender != Gender.NOT_GIVEN ? this.gender : this.existingGender;
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    private void validate() {
        MsgKeysILV genderErrorMsgKey = null;
        if (this.isMandatory()) {
            if (this.gender == Gender.NOT_GIVEN) {
                genderErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.gender == this.existingGender) {
                genderErrorMsgKey = MsgKeysILV.GENDER_SAME;
            } else if (this.gender != this.enrollmentService.getDemoPersonalDetails().getApplicantGender().getGender()) {
                genderErrorMsgKey = MsgKeysILV.GENDER_NOT_SAME;
            }
        }
        this.genderError = this.getMessage((Object)genderErrorMsgKey, new Object[0]);
        this.setValid(this.genderError == null);
    }

    public String toString() {
        return this.getGender().toString();
    }
}

