/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.CapturedImageConverter;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Biometrics
extends EnrolmentModelBase<Biometrics> {
    private final CaptureModality captureModality;
    private CaptureAttempt bestAttempt;
    private BiometricsCaptureTrail captureTrail;
    private List<CaptureAttempt> captureAttempts;
    private List<CaptureAttempt> deletedAttempts;
    private List<BodyPart> availableBodyParts;
    private List<BodyPart> missingBodyParts;
    private int maxCaptureAttempts;
    private boolean bypassQualityCheckAfterMaxAttempt = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(Biometrics.class);
    protected boolean uploadStatus;

    public Biometrics(EnrollmentService enrollmentService, CaptureModality modality, List<BodyPart> availableBodyParts, List<BodyPart> missingBodyParts, boolean isMandatory) {
        super(enrollmentService);
        this.captureModality = modality;
        this.captureAttempts = new ArrayList<CaptureAttempt>();
        this.deletedAttempts = new ArrayList<CaptureAttempt>();
        this.availableBodyParts = availableBodyParts;
        this.missingBodyParts = missingBodyParts;
        super.setMandatory(isMandatory);
        this.validate();
    }

    public CaptureModality getCaptureModality() {
        return this.captureModality;
    }

    BiometricsCaptureTrail getCaptureTrail() {
        if (this.captureAttempts.isEmpty() && this.missingBodyParts.isEmpty()) {
            return null;
        }
        BiometricsCaptureTrail captureTrail = new BiometricsCaptureTrail();
        if (this.captureTrail != null) {
            captureTrail.setModality(this.captureModality);
            List<BiometricsCapture> chExcludingBestCaptureAndDeletedCaptures = this.captureTrail.getCaptureHistory().stream().filter(e -> this.captureTrail.getBestCapture() != e).distinct().collect(Collectors.toList());
            captureTrail.setCaptureHistory(chExcludingBestCaptureAndDeletedCaptures);
            captureTrail.setBestCapture(this.captureTrail.getBestCapture());
        } else if (!this.missingBodyParts.isEmpty()) {
            captureTrail.setModality(this.captureModality);
            BiometricsCapture missedCapture = new BiometricsCapture();
            missedCapture.setMissingBodyParts(this.missingBodyParts);
            captureTrail.setBestCapture(missedCapture);
        }
        return captureTrail;
    }

    public CaptureAttempt getCaptureAttemptWithMaxScore() {
        double maxValue = -1.0;
        CaptureAttempt captureAttempt = null;
        for (CaptureAttempt attempt : this.captureAttempts) {
            if (!(maxValue < attempt.getScore())) continue;
            maxValue = attempt.getScore();
            captureAttempt = attempt;
        }
        return captureAttempt;
    }

    public CaptureAttempt getBestAttempt() {
        return this.bestAttempt;
    }

    public void setBestAttempt(CaptureAttempt bestAttempt) {
        this.bestAttempt = bestAttempt;
        this.validate();
        this.markBestAttemptOnTrail(bestAttempt);
        this.fireChangeEvent(this);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.validate();
    }

    void setMaxCaptureAttempts(int maxCaptureAttempts) {
        this.maxCaptureAttempts = maxCaptureAttempts;
        this.validate();
    }

    public void addCaptureAttempt(CaptureAttempt captureAttempt) {
        if (captureAttempt == null) {
            return;
        }
        this.captureAttempts.add(captureAttempt);
        this.addToCaptureTrail(captureAttempt);
        this.validate();
        super.fireChangeEvent(this);
    }

    public void deleteCaptureAttempt(CaptureAttempt captureAttempt) {
        if (captureAttempt == null) {
            return;
        }
        this.deletedAttempts.add(captureAttempt);
        this.deleteFromCaptureTrail(captureAttempt);
        this.validate();
        super.fireChangeEvent(this);
    }

    public void clearAttempts() {
        if (this.captureAttempts.isEmpty() && this.deletedAttempts.isEmpty()) {
            return;
        }
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.captureAttempts.forEach(CaptureAttempt::delete);
            this.deletedAttempts.forEach(CaptureAttempt::delete);
            this.captureAttempts.clear();
            this.deletedAttempts.clear();
        } else {
            this.captureAttempts = new ArrayList<CaptureAttempt>();
            this.deletedAttempts = new ArrayList<CaptureAttempt>();
        }
        this.bestAttempt = null;
        this.captureTrail = null;
        this.validate();
        super.fireChangeEvent(this);
    }

    public void setBypassQualityCheckAfterMaxAttempt(boolean bypassQualityCheckAfterMaxAttempt) {
        this.bypassQualityCheckAfterMaxAttempt = bypassQualityCheckAfterMaxAttempt;
    }

    public void setUploadStatus(boolean uploadStatus) {
        this.uploadStatus = uploadStatus;
        this.validate();
    }

    private void validate() {
        boolean valid = true;
        if (this.isMandatory()) {
            if (this.captureAttempts.size() == 0) {
                valid = false;
            } else if (this.bestAttempt == null && this.captureAttempts.size() < this.maxCaptureAttempts) {
                valid = false;
            } else if (!this.isQualityPassed()) {
                valid = false;
            }
        }
        if (this.enrollmentService.isUniversalClientTrnx() && this.isMandatory()) {
            this.setValid(valid && this.uploadStatus);
        } else {
            this.setValid(valid);
        }
    }

    private void addToCaptureTrail(CaptureAttempt captureAttempt) {
        BiometricsCapture capture;
        if (this.captureTrail == null) {
            this.captureTrail = new BiometricsCaptureTrail();
            this.captureTrail.setModality(this.captureModality);
        }
        if ((capture = this.attemptToBiometricCapture(captureAttempt, this.availableBodyParts, this.missingBodyParts)) != null) {
            this.captureTrail.getCaptureHistory().add(capture);
        }
    }

    private void deleteFromCaptureTrail(CaptureAttempt captureAttempt) {
        this.captureTrail.getCaptureHistory().forEach(at -> {
            if (Objects.equals(at.getCaptureAttemptId(), captureAttempt.getId())) {
                at.setDeleted(captureAttempt.isDeleted());
                at.setQuality(captureAttempt.getScore());
                if (captureAttempt.getImage() == null) {
                    at.setSampleDataByteArray(null);
                }
            }
        });
    }

    private void markBestAttemptOnTrail(CaptureAttempt captureAttempt) {
        if (captureAttempt == null) {
            return;
        }
        if (this.captureTrail == null) {
            this.captureTrail = new BiometricsCaptureTrail();
            this.captureTrail.setModality(this.captureModality);
        }
        this.captureTrail.getCaptureHistory().stream().filter(at -> Objects.equals(at.getCaptureAttemptId(), captureAttempt.getId())).findFirst().ifPresent(capture -> this.captureTrail.setBestCapture((BiometricsCapture)capture));
    }

    public void setAvailableBodyParts(List<BodyPart> availableBodyParts) {
        this.availableBodyParts = availableBodyParts;
    }

    public List<BodyPart> getAvailableBodyParts() {
        return this.availableBodyParts;
    }

    public List<BodyPart> getMissingBodyParts() {
        return this.missingBodyParts;
    }

    public void setMissingBodyParts(List<BodyPart> missingBodyParts) {
        this.missingBodyParts = missingBodyParts;
    }

    private BiometricsCapture attemptToBiometricCapture(CaptureAttempt attempt, List<BodyPart> bodyPartList, List<BodyPart> missingPartList) {
        if (attempt == null && missingPartList.size() == 0) {
            return null;
        }
        BiometricsCapture capture = new BiometricsCapture();
        capture.setBodyParts(bodyPartList);
        capture.setMissingBodyParts(missingPartList);
        if (attempt == null) {
            capture.setStartTime(System.currentTimeMillis());
            capture.setEndTime(System.currentTimeMillis());
            return capture;
        }
        if (attempt.getDeviceInfo() != null) {
            capture.setDeviceAttributes(attempt.getDeviceInfo().getDeviceAttributes());
        }
        if (attempt.getImage() != null) {
            capture.setSampleDataByteArray(attempt.getImage().getOriginalData());
            capture.setRenderData(CapturedImageConverter.toRenderableData(attempt.getImage(), "PNG"));
        }
        capture.setForcedCapture(attempt.isForcedCapture());
        capture.setStartTime(attempt.getStartTime());
        capture.setEndTime(attempt.getEndTime());
        capture.setQuality(attempt.getScore());
        capture.setQss(attempt.getQSS());
        capture.setFtcFlag(attempt.isFtcFlag());
        capture.setDeleted(attempt.isDeleted());
        capture.setCaptureAttemptId(attempt.getId());
        return capture;
    }

    private boolean isQualityPassed() {
        if (this.bypassQualityCheckAfterMaxAttempt && this.captureAttempts.size() - this.deletedAttempts.size() == this.maxCaptureAttempts) {
            return true;
        }
        return this.captureAttempts.stream().anyMatch(attempt -> attempt != null && attempt.isPass());
    }
}

