/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BiometricsExceptionDetail {
    private List<BiometricPosition> availableFingers = new ArrayList<BiometricPosition>(){
        {
            this.add(BiometricPosition.LEFT_INDEX);
            this.add(BiometricPosition.LEFT_RING);
            this.add(BiometricPosition.LEFT_MIDDLE);
            this.add(BiometricPosition.LEFT_LITTLE);
            this.add(BiometricPosition.RIGHT_INDEX);
            this.add(BiometricPosition.RIGHT_RING);
            this.add(BiometricPosition.RIGHT_MIDDLE);
            this.add(BiometricPosition.RIGHT_LITTLE);
            this.add(BiometricPosition.LEFT_THUMB);
            this.add(BiometricPosition.RIGHT_THUMB);
        }
    };
    private List<BiometricPosition> missingFingers;
    private List<BiometricPosition> availableEyes = new ArrayList<BiometricPosition>(){
        {
            this.add(BiometricPosition.LEFT_IRIS);
            this.add(BiometricPosition.RIGHT_IRIS);
        }
    };
    private List<BiometricPosition> missingEyes;

    public BiometricsExceptionDetail() {
        this.missingFingers = new ArrayList<BiometricPosition>();
        this.missingEyes = new ArrayList<BiometricPosition>();
    }

    public List<BiometricPosition> getAvailableFingers() {
        return this.availableFingers;
    }

    public List<BiometricPosition> getMissingFingers() {
        return this.missingFingers;
    }

    public List<BiometricPosition> getMissingFingersFromLeftHand() {
        return this.missingFingers.stream().filter(f -> f.toString().startsWith("Left")).collect(Collectors.toList());
    }

    public List<BiometricPosition> getMissingFingersFromRightHand() {
        return this.missingFingers.stream().filter(f -> f.toString().startsWith("Right")).collect(Collectors.toList());
    }

    public List<BiometricPosition> getAvailableEyes() {
        return this.availableEyes;
    }

    public List<BiometricPosition> getMissingEyes() {
        return this.missingEyes;
    }

    public void addLeftSlapFingers(List<BiometricPosition> availableFingers, List<BiometricPosition> missingFingers) {
        this.availableFingers.addAll(availableFingers);
        this.missingFingers.addAll(missingFingers);
    }

    public void addRightSlapFingers(List<BiometricPosition> availableFingers, List<BiometricPosition> missingFingers) {
        this.availableFingers.addAll(availableFingers);
        this.missingFingers.addAll(missingFingers);
    }

    public void addEyes(List<BiometricPosition> availableEyes, List<BiometricPosition> missingEyes) {
        this.availableEyes.addAll(availableEyes);
        this.missingEyes.addAll(missingEyes);
    }

    public boolean isBiometricExceptionApplied() {
        return this.missingEyes.size() != 0 || this.missingFingers.size() != 0;
    }

    boolean isFullBiometricsException() {
        return this.isBiometricExceptionApplied() && this.availableEyes.size() == 0 && this.availableFingers.size() == 0;
    }

    public boolean isLeftSlapExceptionApplied() {
        return this.missingFingers.size() >= 4 && this.missingFingers.contains(BiometricPosition.LEFT_INDEX) && this.missingFingers.contains(BiometricPosition.LEFT_RING) && this.missingFingers.contains(BiometricPosition.LEFT_MIDDLE) && this.missingFingers.contains(BiometricPosition.LEFT_LITTLE);
    }

    public boolean isRightSlapExceptionApplied() {
        return this.missingFingers.size() >= 4 && this.missingFingers.contains(BiometricPosition.RIGHT_INDEX) && this.missingFingers.contains(BiometricPosition.RIGHT_RING) && this.missingFingers.contains(BiometricPosition.RIGHT_MIDDLE) && this.missingFingers.contains(BiometricPosition.RIGHT_LITTLE);
    }

    public boolean isBothThumbsExceptionApplied() {
        return this.missingFingers.size() >= 2 && this.missingFingers.contains(BiometricPosition.LEFT_THUMB) && this.missingFingers.contains(BiometricPosition.RIGHT_THUMB);
    }

    public boolean isLeftEyeExceptionApplied() {
        return this.missingEyes.contains(BiometricPosition.LEFT_IRIS);
    }

    public boolean isBothEyesExceptionApplied() {
        return this.isLeftEyeExceptionApplied() && this.isRightEyeExceptionApplied();
    }

    public boolean isRightEyeExceptionApplied() {
        return this.missingEyes.contains(BiometricPosition.RIGHT_IRIS);
    }

    public void reset() {
        this.availableFingers.clear();
        this.availableEyes.clear();
        this.missingFingers.clear();
        this.missingEyes.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiometricsExceptionDetail that = (BiometricsExceptionDetail)o;
        return this.availableFingers.equals(that.availableFingers) && this.missingFingers.equals(that.missingFingers) && this.availableEyes.equals(that.availableEyes) && this.missingEyes.equals(that.missingEyes);
    }

    public int hashCode() {
        return Objects.hash(this.availableFingers, this.missingFingers, this.availableEyes, this.missingEyes);
    }

    public BiometricsExceptionDetail clone() {
        BiometricsExceptionDetail biometricsExceptionDetail = new BiometricsExceptionDetail();
        biometricsExceptionDetail.availableFingers = new ArrayList<BiometricPosition>(this.availableFingers);
        biometricsExceptionDetail.missingFingers = new ArrayList<BiometricPosition>(this.missingFingers);
        biometricsExceptionDetail.availableEyes = new ArrayList<BiometricPosition>(this.availableEyes);
        biometricsExceptionDetail.missingEyes = new ArrayList<BiometricPosition>(this.missingEyes);
        return biometricsExceptionDetail;
    }
}

