/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class BothIris
extends EnrolmentModelBase<BothIris> {
    private final Biometrics leftEye;
    private final Biometrics rightEye;
    private final BiometricsException exception;

    BothIris(EnrollmentService enrollmentService, BiometricsException exception) {
        super(enrollmentService);
        this.exception = exception;
        boolean newEnrolment = !enrollmentService.isUpdateEnrollment();
        this.leftEye = new Biometrics(enrollmentService, CaptureModality.LEFT_IRIS, this.getAvailableBodyPartsForLeftEye(), this.getMissingBodyPartsForLeftEye(), newEnrolment);
        this.rightEye = new Biometrics(enrollmentService, CaptureModality.RIGHT_IRIS, this.getAvailableBodyPartsForRightEye(), this.getMissingBodyPartsForRightEye(), newEnrolment);
        this.leftEye.addValidityChangeListener(this::reEvaluateIrisValidity);
        this.rightEye.addValidityChangeListener(this::reEvaluateIrisValidity);
        this.leftEye.addChangeListener(this::onBiometricChange);
        this.rightEye.addChangeListener(this::onBiometricChange);
        this.exception.addChangeListener(this::onBiometricExceptionChange);
    }

    public Biometrics getLeftEye() {
        return this.leftEye;
    }

    public Biometrics getRightEye() {
        return this.rightEye;
    }

    private void onBiometricExceptionChange(BiometricsException biometricsException) {
        this.leftEye.setAvailableBodyParts(this.getAvailableBodyPartsForLeftEye());
        this.rightEye.setAvailableBodyParts(this.getAvailableBodyPartsForRightEye());
        this.leftEye.setMissingBodyParts(this.getMissingBodyPartsForLeftEye());
        this.rightEye.setMissingBodyParts(this.getMissingBodyPartsForRightEye());
    }

    private void onBiometricChange(Biometrics biometrics) {
        super.fireChangeEvent(this);
    }

    private List<BodyPart> getBodyPartsForLeftEye() {
        return Collections.singletonList(BodyPart.IRIS_LEFT);
    }

    private List<BodyPart> getBodyPartsForRightEye() {
        return Collections.singletonList(BodyPart.IRIS_RIGHT);
    }

    private List<BodyPart> getAvailableBodyPartsForLeftEye() {
        List<BodyPart> bodyPartsForLeftEye = this.getBodyPartsForLeftEye();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableEyes());
        return availableBodyPartList.stream().filter(bodyPartsForLeftEye::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getAvailableBodyPartsForRightEye() {
        List<BodyPart> bodyPartsForRightEye = this.getBodyPartsForRightEye();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableEyes());
        return availableBodyPartList.stream().filter(bodyPartsForRightEye::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForLeftEye() {
        List<BodyPart> bodyPartsForLeftEye = this.getBodyPartsForLeftEye();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingEyes());
        return missingBodyPartList.stream().filter(bodyPartsForLeftEye::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForRightEye() {
        List<BodyPart> bodyPartsForRightEye = this.getBodyPartsForRightEye();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingEyes());
        return missingBodyPartList.stream().filter(bodyPartsForRightEye::contains).collect(Collectors.toList());
    }

    private void reEvaluateIrisValidity(boolean valid) {
        this.setValid(this.leftEye.isValid() && this.rightEye.isValid());
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.leftEye.setMandatory(mandatory);
        this.rightEye.setMandatory(mandatory);
    }

    public void reset() {
        this.leftEye.clearAttempts();
        this.rightEye.clearAttempts();
    }

    private List<BodyPart> mapBioPosToBodyParts(List<BiometricPosition> biometricPositionList) {
        ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
        for (BiometricPosition bioPos : biometricPositionList) {
            switch (bioPos) {
                case LEFT_IRIS: {
                    bodyParts.add(BodyPart.IRIS_LEFT);
                    break;
                }
                case RIGHT_IRIS: {
                    bodyParts.add(BodyPart.IRIS_RIGHT);
                }
            }
        }
        return bodyParts;
    }
}

