/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.packetgenerator.xml.StatusType;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ConfirmDob
extends EnrolmentModelBase<ConfirmDob> {
    public static final int CHILD_MAX_AGE = 5;
    private static final int MAX_AGE = 120;
    private int age = -1;
    private int day = -1;
    private int existingDay = -1;
    private int month = -1;
    private int existingMonth = -1;
    private int year = -1;
    private int existingYear = -1;
    private String ageError;
    private boolean isDobSelected;
    private boolean isVerified;
    private String ageDobLocal;
    private String dayError;
    private String monthError;
    private String yearError;
    private String ageCheckError;
    private AgeDob ageDob;

    ConfirmDob(EnrollmentService enrollmentService) {
        super(enrollmentService);
        if (enrollmentService.isUniversalClientTrnx()) {
            this.setMandatory(enrollmentService.isNewEnrollmentUC() || enrollmentService.getFieldsUpdateCount().getDob().hasToBeUpdated());
        } else {
            super.setMandatory(!enrollmentService.isUpdateEnrollment());
        }
        if (enrollmentService.isUpdateEnrollment()) {
            this.isDobSelected = true;
            enrollmentService.addResidentChildListeners(this::onChildUpdateChange);
        }
        this.validate();
    }

    private void validate() {
        this.validateDOBFields();
        this.validateAgeField();
        if (this.enrollmentService.isUniversalClientTrnx() && this.enrollmentService.isNewEnrollmentUC()) {
            this.validateAge();
        }
        super.setValid(this.ageError == null && this.dayError == null && this.monthError == null && this.yearError == null && this.ageCheckError == null);
    }

    private void validateAge() {
        MsgKeysILV errorMsg = null;
        if (this.enrollmentService.isChildEnrollment() && this.getAge() >= 5) {
            errorMsg = MsgKeysILV.CHILD;
        } else if (this.enrollmentService.isMinorEnrollment() && (this.getAge() < 5 || this.getAge() > 17)) {
            errorMsg = MsgKeysILV.MINOR;
        } else if (!(this.enrollmentService.isForeignResident() || this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment() || this.getAge() > 17)) {
            errorMsg = MsgKeysILV.ADULT;
        }
        this.ageCheckError = this.getMessage((Object)errorMsg, new Object[0]);
    }

    private void onChildUpdateChange(Boolean childUpdate) {
        this.validate();
    }

    public Integer getAge() {
        if (this.isDobSelected()) {
            return this.deriveAgeFromDob();
        }
        return this.age;
    }

    public void setAge(String age) {
        if (!this.isDobSelected()) {
            GregorianCalendar cal = new GregorianCalendar();
            this.age = this.parseIntField(age);
            this.ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
            this.validate();
            if (this.isValid()) {
                this.day = 1;
                this.month = 1;
                this.year = cal.get(1) - this.age;
            } else {
                this.reset();
            }
            super.fireChangeEvent(this);
        }
    }

    public Integer getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public Integer getDayForDisplay() {
        return this.day > 0 ? this.day : this.existingDay;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public Integer getMonthForDisplay() {
        return this.month > 0 ? this.month : this.existingMonth;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Integer getYearForDisplay() {
        return this.year > 0 ? this.year : this.existingYear;
    }

    public boolean isDobSelected() {
        return this.isDobSelected;
    }

    public void setDobSelected(boolean isDobSelected) {
        if (this.isDobSelected == isDobSelected) {
            return;
        }
        this.isDobSelected = isDobSelected;
        this.reset();
        this.validate();
    }

    private void validateAgeField() {
        MsgKeysILV ageErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected() && this.getDay() > 0 && this.getMonth() > 0 && this.getYear() > 0 && this.deriveAgeFromDob() >= 120) {
            ageErrorMsgKey = MsgKeysILV.DOB;
        }
        if (!this.isDobSelected() && this.ageDob != null && !Objects.equals(this.getAge(), this.ageDob.getAge())) {
            ageErrorMsgKey = MsgKeysILV.DOB_SAME;
        }
        this.ageError = this.getMessage((Object)ageErrorMsgKey, new Object[0]);
    }

    public boolean isEmpty() {
        if (this.isDobSelected()) {
            return this.day == -1 || this.month == -1 || this.year == -1;
        }
        return true;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public void setVerified(boolean verified) {
        this.isVerified = verified;
        super.fireChangeEvent(this);
    }

    public String getAgeDobFormatted() {
        if (!this.isValid()) {
            return "";
        }
        GregorianCalendar dobOfResident = new GregorianCalendar(this.getYear(), this.getMonth() - 1, this.getDay());
        return ECMPDateFormatHelper.getDateStr(dobOfResident.getTime(), ECMPDateFormats.STANDARD_DATE_FORMAT);
    }

    public void setAgeDobLocal(String ageDobLocal) {
        this.ageDobLocal = ageDobLocal;
    }

    public String getAgeError() {
        return this.ageError;
    }

    public String getDayError() {
        if (this.dayError == null) {
            return this.ageCheckError;
        }
        return this.dayError;
    }

    public String getMonthError() {
        if (this.monthError == null) {
            return this.ageCheckError;
        }
        return this.monthError;
    }

    public String getYearError() {
        if (this.yearError == null) {
            return this.ageCheckError;
        }
        return this.yearError;
    }

    public String getAgeCheckError() {
        return this.ageCheckError;
    }

    public StatusType getStatus() {
        if (!this.isDobSelected()) {
            return StatusType.APPROXIMATE;
        }
        if (this.isVerified()) {
            return StatusType.VERIFIED;
        }
        return StatusType.DECLARED;
    }

    public String toString() {
        if (this.isValid() && this.day > 0 && this.month > 0 && this.year > 0) {
            return this.day + " " + this.month + " " + this.year;
        }
        return "";
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    public void setDob(String day, String month, String year) {
        this.ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        this.day = this.parseIntField(day);
        this.month = this.parseIntField(month);
        this.year = this.parseIntField(year);
        this.validate();
        super.fireChangeEvent(this);
    }

    public void setDob(String dob) {
        this.ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        if (StringUtils.isNotBlank((String)dob) && dob.length() == 10) {
            this.setDob(dob.substring(0, 2), dob.substring(3, 5), dob.substring(6, 10));
        }
    }

    private void validateDOBFields() {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.validateDayForUC();
            this.validateMonthForUC();
            this.validateYearForUC();
        } else {
            this.validateDay();
            this.validateMonth();
            this.validateYear();
        }
    }

    private boolean isDateNotChanged() {
        return this.day == this.existingDay && this.month == this.existingMonth && this.year == this.existingYear;
    }

    private void validateDayForUC() {
        MsgKeysILV dayErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            if (this.day < 0) {
                dayErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.day != this.ageDob.getDay()) {
                dayErrorMsgKey = MsgKeysILV.DATE_NOT_SAME;
            } else if (this.day == 0 || this.day > 31 || this.month == 2 && this.day > 29) {
                dayErrorMsgKey = MsgKeysILV.DOB_DAY;
            } else if (this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11) {
                if (this.day > 30) {
                    dayErrorMsgKey = MsgKeysILV.DOB_DAY;
                }
            } else if (this.month == 2 && !this.checkIfLeapYear(this.year) && this.day > 28) {
                dayErrorMsgKey = MsgKeysILV.DOB_DAY;
            } else if (this.isDateNotChanged()) {
                dayErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.dayError = this.getMessage((Object)dayErrorMsgKey, new Object[0]);
    }

    private void validateDay() {
        MsgKeysILV dayErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            if (this.day < 0) {
                dayErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.day == 0 || this.day > 31 || this.month == 2 && this.day > 29) {
                dayErrorMsgKey = MsgKeysILV.DOB_DAY;
            } else if (this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11) {
                if (this.day > 30) {
                    dayErrorMsgKey = MsgKeysILV.DOB_DAY;
                }
            } else if (this.month == 2 && !this.checkIfLeapYear(this.year) && this.day > 28) {
                dayErrorMsgKey = MsgKeysILV.DOB_DAY;
            } else if (this.isDateNotChanged()) {
                dayErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.dayError = this.getMessage((Object)dayErrorMsgKey, new Object[0]);
    }

    private void validateMonthForUC() {
        MsgKeysILV monthErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            if (this.month < 0) {
                monthErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.month == 0 || this.month > 12) {
                monthErrorMsgKey = MsgKeysILV.DOB_MONTH;
            } else if (this.isDateNotChanged()) {
                monthErrorMsgKey = MsgKeysILV.DOB_SAME;
            } else if (this.month != this.ageDob.getMonth()) {
                monthErrorMsgKey = MsgKeysILV.DATE_NOT_SAME;
            }
        }
        this.monthError = this.getMessage((Object)monthErrorMsgKey, new Object[0]);
    }

    private void validateYearForUC() {
        MsgKeysILV yearErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            GregorianCalendar cal = new GregorianCalendar(this.year, this.month - 1, this.day);
            if (this.year < 0) {
                yearErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.year == 0) {
                yearErrorMsgKey = MsgKeysILV.DOB_YEAR;
            } else if (cal.getTime().after(new Date())) {
                yearErrorMsgKey = MsgKeysILV.DOB;
            } else if (this.year == 0 || this.deriveAgeFromDob() < 0 || this.deriveAgeFromDob() >= 120) {
                yearErrorMsgKey = MsgKeysILV.DOB;
            } else if (this.enrollmentService.isChildEnrollment() && this.deriveAgeFromDob() >= 5) {
                yearErrorMsgKey = MsgKeysILV.DOB_CHILD;
            } else if (this.isDateNotChanged()) {
                yearErrorMsgKey = MsgKeysILV.DOB_SAME;
            } else if (this.year != this.ageDob.getYear()) {
                yearErrorMsgKey = MsgKeysILV.DATE_NOT_SAME;
            }
        }
        this.yearError = this.getMessage((Object)yearErrorMsgKey, new Object[0]);
    }

    private void validateMonth() {
        MsgKeysILV monthErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            if (this.month < 0) {
                monthErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.month == 0 || this.month > 12) {
                monthErrorMsgKey = MsgKeysILV.DOB_MONTH;
            } else if (this.isDateNotChanged()) {
                monthErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.monthError = this.getMessage((Object)monthErrorMsgKey, new Object[0]);
    }

    private void validateYear() {
        MsgKeysILV yearErrorMsgKey = null;
        if (this.isMandatory() && this.isDobSelected()) {
            GregorianCalendar cal = new GregorianCalendar(this.year, this.month - 1, this.day);
            if (this.year < 0) {
                yearErrorMsgKey = MsgKeysILV.MANDATORY;
            } else if (this.year == 0) {
                yearErrorMsgKey = MsgKeysILV.DOB_YEAR;
            } else if (cal.getTime().after(new Date())) {
                yearErrorMsgKey = MsgKeysILV.DOB;
            } else if (this.year == 0 || this.deriveAgeFromDob() < 0 || this.deriveAgeFromDob() >= 120) {
                yearErrorMsgKey = MsgKeysILV.DOB;
            } else if (this.enrollmentService.isChildEnrollment() && this.deriveAgeFromDob() >= 5) {
                yearErrorMsgKey = MsgKeysILV.DOB_CHILD;
            } else if (this.isDateNotChanged()) {
                yearErrorMsgKey = MsgKeysILV.DOB_SAME;
            }
        }
        this.yearError = this.getMessage((Object)yearErrorMsgKey, new Object[0]);
    }

    private boolean checkIfLeapYear(int year) {
        if (year <= 0) {
            return false;
        }
        if (year % 400 == 0) {
            return true;
        }
        if (year % 100 == 0) {
            return false;
        }
        return year % 4 == 0;
    }

    private int deriveAgeFromDob() {
        GregorianCalendar dob = new GregorianCalendar(this.year, this.month - 1, this.day);
        Calendar enrolDate = Calendar.getInstance();
        int age = enrolDate.get(1) - dob.get(1);
        if (enrolDate.get(2) + 1 < dob.get(2) + 1) {
            --age;
        }
        if (enrolDate.get(2) + 1 == dob.get(2) + 1 && enrolDate.get(5) < dob.get(5)) {
            --age;
        }
        return age;
    }

    private int parseIntField(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void resetToExistingDate() {
        this.day = this.existingDay;
        this.month = this.existingMonth;
        this.year = this.existingYear;
    }

    private void reset() {
        this.age = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfirmDob that = (ConfirmDob)o;
        return this.day == that.day && this.month == that.month && this.year == that.year;
    }

    public int hashCode() {
        return Objects.hash(this.day, this.month, this.year);
    }
}

