/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.rd.device.xml.DeviceRdInfo;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.CapturedImageConverter;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import java.util.Collections;
import java.util.HashMap;

public class ConfirmerDetails
extends EnrolmentModelBase<ConfirmerDetails> {
    private UserDetails operator;
    private UserDetails supervisor;
    private UserDetails introducer;

    ConfirmerDetails(EnrollmentService enrollmentService) {
        super(enrollmentService);
    }

    public UserDetails getOperator() {
        return this.operator;
    }

    public void setOperator(UserDetails userDetails) {
        this.operator = userDetails;
    }

    public UserDetails getSupervisor() {
        return this.supervisor;
    }

    public void setSupervisor(UserDetails userDetails) {
        this.supervisor = userDetails;
    }

    public UserDetails getIntroducer() {
        return this.introducer;
    }

    public void setIntroducer(UserDetails userDetails) {
        this.introducer = userDetails;
    }

    public BiometricsCapture getBioCapture(CaptureAttempt attempt, BodyPart bodyPart) {
        BiometricsCapture capture = new BiometricsCapture();
        capture.setBodyParts(Collections.singletonList(bodyPart));
        capture.setForcedCapture(attempt.isForcedCapture());
        capture.setStartTime(attempt.getStartTime());
        capture.setEndTime(attempt.getEndTime());
        capture.setQuality(attempt.getScore());
        capture.setFtcFlag(attempt.isFtcFlag());
        capture.setFtcFlag(attempt.isFtcFlag());
        if (this.enrollmentService.isRDBasedUpdate()) {
            capture.setDeviceAttributes(this.getDeviceAttributes(attempt.getDevRdInfo()));
        } else {
            if (attempt.getDeviceInfo() != null) {
                capture.setDeviceAttributes(attempt.getDeviceInfo().getDeviceAttributes());
            }
            capture.setQss(attempt.getQSS());
            capture.setSampleDataByteArray(attempt.getImage().getOriginalData());
            capture.setRenderData(CapturedImageConverter.toRenderableData(attempt.getImage(), "PNG"));
        }
        capture.setDeleted(attempt.isDeleted());
        return capture;
    }

    private HashMap<String, String> getDeviceAttributes(DeviceRdInfo confirmerBioDeviceInfo) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (confirmerBioDeviceInfo != null) {
            attribs.put("dpId", confirmerBioDeviceInfo.getDpId());
            attribs.put("rdsId", confirmerBioDeviceInfo.getRdsId());
            attribs.put("rdsVer", confirmerBioDeviceInfo.getRdsVer());
            attribs.put("dc", confirmerBioDeviceInfo.getDc());
            attribs.put("mi", confirmerBioDeviceInfo.getMi());
            attribs.put("mc", confirmerBioDeviceInfo.getMc());
        }
        return attribs;
    }
}

