/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.enrollment.model.Mobile;

public class Contact
extends EnrolmentModelBase<Contact> {
    private final Address address;
    private final ForeignNRI foreignNRIAddress;
    private final Mobile mobile;
    private final Email email;
    private Address lastSavedAddress;

    Contact(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.address = new Address(enrollmentService);
        this.foreignNRIAddress = new ForeignNRI(enrollmentService);
        this.mobile = new Mobile(enrollmentService);
        this.email = new Email(enrollmentService);
        this.address.addValidityChangeListener(this::reEvaluateContactDetailValidity);
        this.address.addChangeListener(this::onAddressChange);
        this.foreignNRIAddress.addValidityChangeListener(this::reEvaluateContactDetailValidity);
        this.foreignNRIAddress.addChangeListener(this::onForeignNRIAddressChange);
        this.mobile.addValidityChangeListener(this::reEvaluateContactDetailValidity);
        this.mobile.addChangeListener(this::onMobileChange);
        this.email.addValidityChangeListener(this::reEvaluateContactDetailValidity);
        this.email.addChangeListener(this::onEmailChange);
        super.setValid(enrollmentService.isUpdateEnrollment() || !enrollmentService.isUniversalClientTrnx());
        this.addEventListenersForUpdateEnrollment(enrollmentService.isUpdateEnrollment());
    }

    private void addEventListenersForUpdateEnrollment(boolean isUpdateEnrollment) {
        if (!isUpdateEnrollment) {
            return;
        }
        this.address.addUpdateChangeListener(this::reEvaluateContactUpdateState);
        this.mobile.addUpdateChangeListener(this::reEvaluateContactUpdateState);
        this.email.addUpdateChangeListener(this::reEvaluateContactUpdateState);
    }

    private void onMobileChange(Mobile mobile) {
        this.fireChangeEvent(this);
    }

    private void onAddressChange(Address address) {
        this.fireChangeEvent(this);
    }

    private void onForeignNRIAddressChange(ForeignNRI foreignNRIAddress) {
        this.fireChangeEvent(this);
    }

    private void onEmailChange(Email email) {
        this.fireChangeEvent(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public ForeignNRI getForeignNriAddress() {
        return this.foreignNRIAddress;
    }

    public Address getLastSavedAddress() {
        return this.lastSavedAddress;
    }

    public void setLastSavedAddress(Address lastSavedAddress) {
        this.lastSavedAddress = lastSavedAddress;
    }

    public Email getEmail() {
        return this.email;
    }

    public Mobile getMobile() {
        return this.mobile;
    }

    @Override
    public boolean isUpdated() {
        return this.address.isUpdated() || this.mobile.isUpdated() || this.email.isUpdated();
    }

    private void reEvaluateContactDetailValidity(Boolean valid) {
        if (this.enrollmentService.doesNriHaveForeignAddress()) {
            super.setValid(valid != false && this.foreignNRIAddress.isValid() && this.mobile.isValid() && this.email.isValid());
        } else {
            super.setValid(valid != false && this.address.isValid() && this.mobile.isValid() && this.email.isValid());
        }
    }

    private void reEvaluateContactUpdateState(EnrolmentModelBase modelBase) {
        boolean prevUpdateValue = super.isUpdated();
        super.setUpdated(this.address.isUpdated() || this.mobile.isUpdated() || this.email.isUpdated());
        boolean isUpdated = super.isUpdated();
        if (prevUpdateValue != isUpdated) {
            super.fireUpdateChangeEvent(this);
        }
    }
}

