/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Brn;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.RelativeDetail;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;

public class Demographics
extends EnrolmentModelBase<Demographics> {
    private final ResidentialStatus residentialStatus;
    private final PersonalDetail personalDetail;
    private final Contact contact;
    private final RelativeDetail fatherDetail;
    private final RelativeDetail motherDetail;
    private final RelativeDetail otherDetail;
    private final Brn brnDetails;

    public Demographics(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.residentialStatus = new ResidentialStatus(enrollmentService);
        this.personalDetail = new PersonalDetail(enrollmentService);
        this.contact = new Contact(enrollmentService);
        this.fatherDetail = new RelativeDetail(enrollmentService);
        this.motherDetail = new RelativeDetail(enrollmentService);
        this.otherDetail = new RelativeDetail(enrollmentService);
        this.brnDetails = new Brn(enrollmentService);
        if (enrollmentService.isUniversalClientTrnx()) {
            this.residentialStatus.addChangeListener(residentialStatus -> this.contact.getEmail().setMandatory(enrollmentService.isNewEnrollmentUC() && (residentialStatus.isNRI() || residentialStatus.enrollmentService.isForeignResident()) || FieldInfoUtils.isDemographicTabRequired()));
        } else {
            this.residentialStatus.addChangeListener(residentialStatus -> this.contact.getEmail().setMandatory(residentialStatus.isNRI()));
        }
        this.personalDetail.addValidityChangeListener(this::reEvaluateDemographicsValidity);
        this.contact.addValidityChangeListener(this::reEvaluateDemographicsValidity);
        this.addEventListenersForUpdateEnrollment(enrollmentService.isUpdateEnrollment());
    }

    private void addEventListenersForUpdateEnrollment(boolean isUpdateEnrollment) {
        if (!isUpdateEnrollment) {
            return;
        }
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.personalDetail.addUpdateChangeListener(this::reEvaluateIsUpdated);
        this.contact.addUpdateChangeListener(this::reEvaluateIsUpdated);
    }

    public ResidentialStatus getResidentialStatus() {
        return this.residentialStatus;
    }

    public RelativeDetail getFatherDetail() {
        return this.fatherDetail;
    }

    public RelativeDetail getMotherDetail() {
        return this.motherDetail;
    }

    public RelativeDetail getOtherDetail() {
        return this.otherDetail;
    }

    public Brn getBrnDetails() {
        return this.brnDetails;
    }

    public PersonalDetail getPersonalDetail() {
        return this.personalDetail;
    }

    public Contact getContact() {
        return this.contact;
    }

    private void reEvaluateIsUpdated(EnrolmentModelBase modelBase) {
        boolean prevUpdateValue = super.isUpdated();
        super.setUpdated(this.personalDetail.isUpdated() || this.contact.isUpdated());
        boolean isUpdated = super.isUpdated();
        if (prevUpdateValue != isUpdated) {
            this.reEvaluateDemographicsValidity(true);
        }
    }

    private void onBiometricUpdateTypeChange(Boolean biometricUpdate) {
        this.reEvaluateDemographicsValidity(true);
    }

    public RelationshipType getHofRelationType() {
        if (this.fatherDetail.isHOF()) {
            return this.fatherDetail.getRelationType();
        }
        if (this.motherDetail.isHOF()) {
            return this.motherDetail.getRelationType();
        }
        return this.otherDetail.getRelationType();
    }

    private void reEvaluateDemographicsValidity(Boolean valid) {
        boolean isValid;
        boolean bl = isValid = valid != false && this.personalDetail.isValid() && this.contact.isValid();
        if ((this.enrollmentService.isOffLineDocumentUpdate() || this.enrollmentService.isDocumentUpdate()) && this.enrollmentService.isNRIEnrolment()) {
            isValid = true;
        }
        if (this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isUpdateUC()) {
            isValid = this.enrollmentService.isOffLineDocumentUpdate() ? isValid && this.getPersonalDetail().getName().isValid() && this.getPersonalDetail().getAadhaarNumber().isValid() : (this.enrollmentService.isDocumentUpdate() ? true : isValid && (this.personalDetail.isUpdated() || this.contact.isUpdated() || this.enrollmentService.isBiometricUpdate()));
        }
        super.setValid(isValid);
    }
}

