/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Email
extends EnrolmentModelBase<Email> {
    private String email = "";
    private String existingEmail = "";
    private String emailError;
    private boolean isEmailVerified = true;

    public Email(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.setValid(true);
    }

    public String email() {
        return this.email;
    }

    public String getEmailForDisplay() {
        return StringUtils.isNotBlank((String)this.email) ? this.email : this.existingEmail;
    }

    public String getEmailError() {
        return this.emailError;
    }

    public boolean isEmailVerified() {
        return this.isEmailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.isEmailVerified = emailVerified;
        this.validate();
        super.fireChangeEvent(this);
    }

    public void setEmail(String email) {
        boolean isNewEnrollment = !this.enrollmentService.isUpdateEnrollment();
        this.setMandatory(isNewEnrollment && !StringUtils.isBlank((String)email) || this.enrollmentService.isNRIEnrolment() || this.isUpdated() || this.enrollmentService.isForeignResident());
        this.email = email;
        this.validate();
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            super.setValid(this.emailError == null);
        }
        super.fireChangeEvent(this);
    }

    @Override
    public void setMandatory(boolean isMandatory) {
        super.setMandatory(isMandatory);
        this.validate();
    }

    public String getExistingEmail() {
        return this.existingEmail;
    }

    public void setExistingEmail(String existingEmail) {
        this.existingEmail = existingEmail;
    }

    @Override
    public void setUpdated(boolean updated) {
        super.setUpdated(updated);
        super.setUpdatedBit(updated, BitIdentifierSelection.EMAILBIT.getBitIndentifier());
        this.validate();
        super.fireChangeEvent(this);
        super.fireUpdateChangeEvent(this);
    }

    private void validate() {
        Matcher matcher;
        String EMAIL_PATTERN = "^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        MsgKeysILV emailErrorMsgKey = null;
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        if (this.isMandatory()) {
            if (StringUtils.isBlank((String)this.email)) {
                emailErrorMsgKey = MsgKeysILV.EMAIL_MANDATORY;
            } else if (!StringUtils.isBlank((String)this.email)) {
                matcher = pattern.matcher(this.email);
                if (!matcher.matches()) {
                    emailErrorMsgKey = MsgKeysILV.EMAIL_INVALID;
                } else if (!this.enrollmentService.getDemographics().getResidentialStatus().isNRI() && this.email.equals(this.existingEmail)) {
                    emailErrorMsgKey = MsgKeysILV.EMAIL_SAME;
                } else if (this.enrollmentService.isUniversalClientTrnx() && this.email.equals(this.existingEmail)) {
                    emailErrorMsgKey = MsgKeysILV.EMAIL_SAME;
                }
            }
        }
        if (this.enrollmentService.isHofEnrollment() && this.enrollmentService.isUniversalClientTrnx()) {
            emailErrorMsgKey = null;
            if (!StringUtils.isBlank((String)this.existingEmail) && !(matcher = pattern.matcher(this.existingEmail)).matches()) {
                emailErrorMsgKey = MsgKeysILV.EMAIL_INVALID;
            }
        }
        this.emailError = this.getMessage((Object)emailErrorMsgKey, new Object[0]);
        if (this.enrollmentService.isUniversalClientTrnx() && this.isMandatory()) {
            if (this.enrollmentService.isNewEnrollmentUC()) {
                this.setValid(this.emailError == null && this.isEmailVerified);
            }
            if (this.enrollmentService.isUpdateUC()) {
                this.setValid(this.emailError == null && this.isEmailVerified);
            }
        } else {
            this.setValid(this.emailError == null);
        }
    }
}

