/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.preference.PreferencesPostProcessor;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.oauthapi.json.mda.roiapi.LabelDetail;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrolStepInfo;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.IEnrolmentIDGenerator;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.enrollment.model.Appointment;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.ConfirmerDetails;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.FingerPrint;
import in.gov.uidai.ec.service.enrollment.model.Iris;
import in.gov.uidai.ec.service.enrollment.model.Photograph;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.ResidentConfirmation;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.service.findaadhaar.model.BitIdentifierSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class EnrollmentState {
    private final EnrollmentService enrollmentService;
    private final IEnrolmentIDGenerator idGen;
    private final List<EnrolStepInfo> stepList;
    private final HashMap<Integer, Boolean> tabStates;
    private final List<Consumer<Boolean>> biometricUpdateChangeListener;
    private final List<Consumer<Boolean>> childEnrollmentChangeListener;
    private boolean isHofEnrollment;
    private boolean isDocumentBased;
    private FieldsUpdateCount fieldsUpdateCount;
    private Appointment appointment;
    private Demographics demographics;
    private References references;
    private Photograph photograph;
    private BiometricsException biometricsException;
    private FingerPrint fingerPrint;
    private Iris iris;
    private ConfirmerDetails confirmerDetails;
    private long startTime;
    private long endTime;
    private EID enrolId;
    private DocumentsManager docMan;
    private boolean isChildEnrollment;
    private boolean isAadhaarActive;
    private boolean isAdultEnrollment;
    private boolean isMinorEnrollment;
    private boolean isBiometricUpdate;
    private boolean isMandatoryBiometricUpdate;
    private boolean isUpdateEnrollment;
    private boolean isOnlineUpdate;
    private boolean isNameFieldEnable;
    private boolean isAadharFieldEnable;
    private boolean isChildEnrolmentEnable;
    private boolean isUpdateBioMetricEnable;
    private boolean isMandatoryBioMetricEnable;
    private boolean isPhotographCaptureEnabled;
    private boolean isRDBasedUpdate;
    private boolean isAppointmentBasedFlow;
    private boolean isSupervisorCaptureRequired;
    private boolean isPACValidationRequired;
    private boolean isLanguageOnlyUpdate;
    private boolean isFindAadhaar;
    private boolean isBiometricUpdateAllowed;
    private UpdateType updateType;
    private String langCode;
    private boolean isDocUpdate;
    private boolean isOffLineDocUpdate;
    private Map<DocumentType, List<LabelDetail>> roiLabelList;
    private boolean isDemoUpdate;
    private boolean isPobRequired;
    private boolean isForeignResident;
    private boolean nriHaveForeignAddress;
    private String hofUid;
    private String hofName;
    private String hofNameLocal;
    private Integer latestScannedDocumentId = 0;
    private String sId;
    private String grievanceId;
    private String linkedEid;
    private String supervisorAuthUrl;
    private String refId;
    private String residentUid;
    private String acknowledgementSlip;
    private byte[] acknowledgementSlipBytes;
    private boolean isHofConsentGoingOn;

    public EnrollmentState(IEnrolmentIDGenerator gen, EnrollmentService enrollmentService) {
        this.idGen = gen;
        this.enrollmentService = enrollmentService;
        this.stepList = new ArrayList<EnrolStepInfo>();
        this.tabStates = new HashMap();
        this.biometricUpdateChangeListener = new ArrayList<Consumer<Boolean>>();
        this.childEnrollmentChangeListener = new ArrayList<Consumer<Boolean>>();
        boolean isWhiteListed = PreferencesPostProcessor.getStationType();
        this.setUpdatedBit(isWhiteListed, BitIdentifierSelection.WHITELISTBIT.getBitIndentifier());
    }

    public EnrollmentState(String residentUId, EnrollmentService enrollmentService) {
        this.idGen = null;
        this.residentUid = residentUId;
        this.enrollmentService = enrollmentService;
        this.stepList = new ArrayList<EnrolStepInfo>();
        this.tabStates = new HashMap();
        this.biometricUpdateChangeListener = new ArrayList<Consumer<Boolean>>();
        this.childEnrollmentChangeListener = new ArrayList<Consumer<Boolean>>();
        boolean isWhiteListed = PreferencesPostProcessor.getStationType();
        this.setUpdatedBit(isWhiteListed, BitIdentifierSelection.WHITELISTBIT.getBitIndentifier());
    }

    public EnrollmentState(EnrollmentService enrollmentService) {
        this.idGen = null;
        this.enrollmentService = enrollmentService;
        this.stepList = new ArrayList<EnrolStepInfo>();
        this.tabStates = new HashMap();
        this.biometricUpdateChangeListener = new ArrayList<Consumer<Boolean>>();
        this.childEnrollmentChangeListener = new ArrayList<Consumer<Boolean>>();
        boolean isWhiteListed = PreferencesPostProcessor.getStationType();
        this.setUpdatedBit(isWhiteListed, BitIdentifierSelection.WHITELISTBIT.getBitIndentifier());
    }

    public void init(boolean updateEnrollment, boolean onlineUpdate, boolean docUpdate, boolean isOffLineDocumentUpdate) {
        this.setIsUpdateEnrollment(updateEnrollment);
        if (onlineUpdate || docUpdate) {
            this.setOnlineUpdate(onlineUpdate || docUpdate);
            this.setRDBasedUpdate(onlineUpdate || docUpdate);
            this.setSupervisorCaptureRequired(!onlineUpdate && !docUpdate);
            this.setPhotographCaptureEnabled(!onlineUpdate && !docUpdate);
            this.setBiometricUpdateAllowed(!onlineUpdate && !docUpdate);
            this.setAppointmentBasedFlow(onlineUpdate || docUpdate);
            this.setPACValidationRequired(onlineUpdate || docUpdate);
            this.setLanguageOnlyUpdate(onlineUpdate || docUpdate);
            this.setFindAadhaar(onlineUpdate || docUpdate);
            this.setDocUpdate(docUpdate);
        } else if (isOffLineDocumentUpdate) {
            this.setOffLineDocUpdate(isOffLineDocumentUpdate);
            this.setPhotographCaptureEnabled(isOffLineDocumentUpdate);
        } else {
            this.setSupervisorCaptureRequired(!onlineUpdate);
            this.setPhotographCaptureEnabled(!onlineUpdate);
            this.setBiometricUpdateAllowed(!onlineUpdate);
        }
        if (updateEnrollment) {
            if (this.updateType != UpdateType.APPOINTMENT_UPDATE) {
                if (docUpdate && this.isOnlineUpdate) {
                    this.setUpdateType(UpdateType.ONLINE_DOC_UPDATE);
                } else if (this.isOnlineUpdate) {
                    this.setUpdateType(UpdateType.ONLINE_UPDATE);
                } else if (isOffLineDocumentUpdate) {
                    this.setUpdateType(UpdateType.OFFLINE_DOC_UPDATE);
                } else {
                    this.setUpdateType(UpdateType.OFFLINE_UPDATE);
                }
            }
        } else {
            this.updateType = UpdateType.NEW_ENROLLMENT;
        }
        if (!updateEnrollment) {
            this.setIsNameFieldEnable(true);
        } else {
            if (docUpdate || isOffLineDocumentUpdate) {
                this.setUpdatedBit(true, BitIdentifierSelection.DOCONLYUPDATEBIT.getBitIndentifier());
            }
            if (isOffLineDocumentUpdate) {
                this.setIsNameFieldEnable(isOffLineDocumentUpdate);
                this.setIsAadharFieldEnable(isOffLineDocumentUpdate);
            } else {
                this.setIsNameFieldEnable(!onlineUpdate && !docUpdate);
                this.setIsAadharFieldEnable(!onlineUpdate && !docUpdate);
                this.setIsChildEnrolmentEnable(!onlineUpdate && !docUpdate);
                this.setIsUpdateBioMetricEnable(!onlineUpdate && !docUpdate);
                this.setIsMandatoryBioMetricEnable(!onlineUpdate && !docUpdate);
            }
        }
        this.startTime = System.currentTimeMillis();
        this.docMan = new DocumentsManager(this.enrollmentService);
        this.demographics = new Demographics(this.enrollmentService);
        this.references = new References(this.enrollmentService, this.demographics);
        this.biometricsException = new BiometricsException(this.enrollmentService);
        this.photograph = new Photograph(this.enrollmentService, this.biometricsException);
        this.fingerPrint = new FingerPrint(this.enrollmentService, this.demographics, this.biometricsException);
        this.iris = new Iris(this.enrollmentService, this.demographics, this.biometricsException);
        this.confirmerDetails = new ConfirmerDetails(this.enrollmentService);
    }

    public void addBiometricUpdateChangeListener(Consumer<Boolean> delegate) {
        this.biometricUpdateChangeListener.add(delegate);
    }

    public void addResidentChildEnrollmentChangeListeners(Consumer<Boolean> delegate) {
        this.childEnrollmentChangeListener.add(delegate);
    }

    public void generateEnrolmentId() {
        this.endTime = System.currentTimeMillis();
        if (this.idGen != null) {
            this.enrolId = this.idGen.generate();
        }
    }

    public ConfirmerDetails getConfirmerDetails() {
        return this.confirmerDetails;
    }

    public boolean isUpdateEnrollment() {
        return this.isUpdateEnrollment;
    }

    public boolean isChildEnrollment() {
        return this.isChildEnrollment;
    }

    public void setChildEnrollment(boolean childEnrollment) {
        this.setUpdatedBit(childEnrollment, BitIdentifierSelection.CHILDUPDATEBIT.getBitIndentifier());
        boolean prevIsChildEnrollment = this.isChildEnrollment();
        this.isChildEnrollment = childEnrollment;
        if (this.isChildEnrollment) {
            this.setBiometricUpdate(false);
            this.setMandatoryBiometricUpdate(false);
        }
        if (prevIsChildEnrollment != childEnrollment) {
            this.fireResidentChildEnrollment(childEnrollment);
        }
    }

    public boolean isAdultEnrollment() {
        return this.isAdultEnrollment;
    }

    public void setAdultEnrollment(boolean adultEnrollment) {
        boolean prevIsAdultEnrollment = this.isAdultEnrollment;
        this.isAdultEnrollment = adultEnrollment;
        if (prevIsAdultEnrollment != adultEnrollment) {
            this.fireResidentChildEnrollment(adultEnrollment);
        }
    }

    public boolean isMinorEnrollment() {
        return this.isMinorEnrollment;
    }

    public void setMinorEnrollment(boolean minorEnrollment) {
        boolean prevIsMinorEnrollment = this.isMinorEnrollment;
        this.isMinorEnrollment = minorEnrollment;
        if (prevIsMinorEnrollment != minorEnrollment) {
            this.fireResidentChildEnrollment(minorEnrollment);
        }
    }

    public boolean isBiometricUpdate() {
        return this.isBiometricUpdate;
    }

    public void setBiometricUpdate(boolean biometricUpdate) {
        this.setUpdatedBit(biometricUpdate || this.isMandatoryBiometricUpdate, BitIdentifierSelection.BIOMETRICBIT.getBitIndentifier());
        this.setUpdatedBit(biometricUpdate || this.isMandatoryBiometricUpdate, BitIdentifierSelection.PHOTOUPDATEBIT.getBitIndentifier());
        boolean prevIsBiometricUpdate = this.isBiometricUpdate();
        this.isBiometricUpdate = biometricUpdate;
        if (this.isBiometricUpdate) {
            this.setChildEnrollment(false);
            this.setMandatoryBiometricUpdate(false);
        }
        this.fireBiometricUpdateChangeListener();
    }

    public boolean isMandatoryBiometricUpdate() {
        return this.isMandatoryBiometricUpdate;
    }

    public void setMandatoryBiometricUpdate(boolean mandatoryBiometricUpdate) {
        this.setUpdatedBit(mandatoryBiometricUpdate, BitIdentifierSelection.MBUPDATEBIT.getBitIndentifier());
        this.setUpdatedBit(mandatoryBiometricUpdate || this.isBiometricUpdate, BitIdentifierSelection.PHOTOUPDATEBIT.getBitIndentifier());
        boolean prevIsMandatoryBiometricUpdate = this.isMandatoryBiometricUpdate();
        this.isMandatoryBiometricUpdate = mandatoryBiometricUpdate;
        if (this.isMandatoryBiometricUpdate) {
            if (!this.isBiometricUpdate) {
                this.setUpdatedBit(true, BitIdentifierSelection.BIOMETRICBIT.getBitIndentifier());
            }
            this.setBiometricUpdate(false);
            this.setChildEnrollment(false);
        }
        this.fireBiometricUpdateChangeListener();
    }

    public boolean isOnlineUpdate() {
        return this.isOnlineUpdate;
    }

    public boolean isDocUpdate() {
        return this.isDocUpdate;
    }

    public void setOnlineUpdate(boolean onlineUpdate) {
        this.isOnlineUpdate = onlineUpdate;
    }

    public void setDocUpdate(boolean isDocUpdate) {
        this.isDocUpdate = isDocUpdate;
    }

    public boolean isOffLineDocUpdate() {
        return this.isOffLineDocUpdate;
    }

    public void setOffLineDocUpdate(boolean isOffLineDocUpdate) {
        this.isOffLineDocUpdate = isOffLineDocUpdate;
    }

    public boolean isPhotographCaptureEnabled() {
        return this.isPhotographCaptureEnabled;
    }

    public void setPhotographCaptureEnabled(boolean photographCaptureEnabled) {
        this.isPhotographCaptureEnabled = photographCaptureEnabled;
    }

    public boolean isAppointmentBasedFlow() {
        return this.isAppointmentBasedFlow;
    }

    public void setAppointmentBasedFlow(boolean appointmentBasedFlow) {
        this.isAppointmentBasedFlow = appointmentBasedFlow;
    }

    public boolean isSupervisorCaptureRequired() {
        return this.isSupervisorCaptureRequired;
    }

    public void setSupervisorCaptureRequired(boolean supervisorCaptureRequired) {
        this.isSupervisorCaptureRequired = supervisorCaptureRequired;
    }

    public boolean isPACValidationRequired() {
        return this.isPACValidationRequired;
    }

    public void setPACValidationRequired(boolean PACValidationRequired) {
        this.isPACValidationRequired = PACValidationRequired;
    }

    public boolean isLanguageOnlyUpdate() {
        return this.isLanguageOnlyUpdate;
    }

    public void setLanguageOnlyUpdate(boolean languageOnlyUpdate) {
        this.isLanguageOnlyUpdate = languageOnlyUpdate;
    }

    public boolean isFindAadhaar() {
        return this.isFindAadhaar;
    }

    public void setFindAadhaar(boolean findAadhaar) {
        this.isFindAadhaar = findAadhaar;
    }

    public boolean isRDBasedUpdate() {
        return this.isRDBasedUpdate;
    }

    public void setRDBasedUpdate(boolean RDBasedUpdate) {
        this.isRDBasedUpdate = RDBasedUpdate;
    }

    public boolean isBiometricUpdateAllowed() {
        return this.isBiometricUpdateAllowed;
    }

    public void setBiometricUpdateAllowed(boolean biometricUpdateAllowed) {
        this.isBiometricUpdateAllowed = biometricUpdateAllowed;
    }

    public boolean isNameFieldEnable() {
        return this.isNameFieldEnable;
    }

    public boolean isAadhaarFieldEnable() {
        return this.isAadharFieldEnable;
    }

    public boolean isChildEnrolmentEnable() {
        return this.isChildEnrolmentEnable;
    }

    public boolean isUpdateBioMetricEnable() {
        return this.isUpdateBioMetricEnable;
    }

    public boolean isMandatoryBioMetricEnable() {
        return this.isMandatoryBioMetricEnable;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public void setHofEnrollment(boolean isHof) {
        this.isHofEnrollment = isHof;
    }

    public void setDocumentBasedEnrollment(boolean isDocBased) {
        this.isDocumentBased = isDocBased;
    }

    public boolean isDocumentBasedEnrollment() {
        return this.isDocumentBased;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = updateType;
    }

    public Demographics getDemographics() {
        return this.demographics;
    }

    public References getReferences() {
        return this.references;
    }

    public BiometricsException getBiometricsException() {
        return this.biometricsException;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public EID getEnrolId() {
        return this.enrolId;
    }

    public void setEnrolId(EID eid) {
        this.enrolId = eid;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getBiometricsTrailMap() {
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> captureModalityBiometricsCaptureTrailMap = new LinkedHashMap<CaptureModality, BiometricsCaptureTrail>();
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.FACE, this.photograph.getPhoto().getCaptureTrail());
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.LEFT_SLAP, this.fingerPrint.getLeftSlap().getCaptureTrail());
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.RIGHT_SLAP, this.fingerPrint.getRightSlap().getCaptureTrail());
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.THUMB_SLAP, this.fingerPrint.getBothThumbs().getCaptureTrail());
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.LEFT_IRIS, this.iris.getLeftEye().getCaptureTrail());
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.RIGHT_IRIS, this.iris.getRightEye().getCaptureTrail());
        return captureModalityBiometricsCaptureTrailMap;
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getRDBiometricsTrailMap() {
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> captureModalityBiometricsCaptureTrailMap = new LinkedHashMap<CaptureModality, BiometricsCaptureTrail>();
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.FACE, this.photograph.getResidentConfirmation().getResidentRdCaptureTrail());
        return captureModalityBiometricsCaptureTrailMap;
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getBiometricsExceptionTrailMap() {
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> captureModalityBiometricsCaptureTrailMap = new LinkedHashMap<CaptureModality, BiometricsCaptureTrail>();
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.BIOX, this.photograph.getExceptionPhoto().getCaptureTrail());
        return captureModalityBiometricsCaptureTrailMap;
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getFaceTrailMap() {
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> captureModalityBiometricsCaptureTrailMap = new LinkedHashMap<CaptureModality, BiometricsCaptureTrail>();
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.FACE, this.photograph.getPhoto().getCaptureTrail());
        return captureModalityBiometricsCaptureTrailMap;
    }

    public LinkedHashMap<CaptureModality, BiometricsCaptureTrail> getBiometricsTrailMapForUpdate() {
        if (this.enrollmentService.isBiometricUpdate()) {
            return this.getBiometricsTrailMap();
        }
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> captureModalityBiometricsCaptureTrailMap = new LinkedHashMap<CaptureModality, BiometricsCaptureTrail>();
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, CaptureModality.FACE, this.photograph.getPhoto().getCaptureTrail());
        ResidentConfirmation residentConfirmation = this.photograph.getResidentConfirmation();
        BiometricsCaptureTrail biometricsCaptureTrail = null;
        CaptureModality captureModality = null;
        if (residentConfirmation.isMandatory()) {
            if (residentConfirmation.getLeftSlap().isMandatory()) {
                biometricsCaptureTrail = residentConfirmation.getLeftSlap().getCaptureTrail();
                captureModality = CaptureModality.LEFT_SLAP;
            } else if (residentConfirmation.getRightSlap().isMandatory()) {
                biometricsCaptureTrail = residentConfirmation.getRightSlap().getCaptureTrail();
                captureModality = CaptureModality.RIGHT_SLAP;
            } else if (residentConfirmation.getBothThumbs().isMandatory()) {
                biometricsCaptureTrail = residentConfirmation.getBothThumbs().getCaptureTrail();
                captureModality = CaptureModality.THUMB_SLAP;
            } else if (residentConfirmation.getLeftIris().isMandatory()) {
                biometricsCaptureTrail = residentConfirmation.getLeftIris().getCaptureTrail();
                captureModality = CaptureModality.LEFT_IRIS;
            } else if (residentConfirmation.getRightIris().isMandatory()) {
                biometricsCaptureTrail = residentConfirmation.getRightIris().getCaptureTrail();
                captureModality = CaptureModality.RIGHT_IRIS;
            }
        }
        this.addToBiometricCaptureTrail(captureModalityBiometricsCaptureTrailMap, captureModality, biometricsCaptureTrail);
        return captureModalityBiometricsCaptureTrailMap;
    }

    private void addToBiometricCaptureTrail(HashMap<CaptureModality, BiometricsCaptureTrail> biometricCaptureTrailMap, CaptureModality captureModality, BiometricsCaptureTrail biometricsCaptureTrail) {
        if (biometricsCaptureTrail != null) {
            biometricCaptureTrailMap.put(captureModality, biometricsCaptureTrail);
        }
    }

    public List<EnrolStepInfo> getEnrolSteps() {
        return this.stepList;
    }

    public DocumentsManager getDocMan() {
        return this.docMan;
    }

    public String getDemographicsOverride() {
        ArrayList<String> wrongFields = new ArrayList<String>();
        if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.isMobileOnlyUpdate()) {
            return "";
        }
        if (this.demographics.getPersonalDetail().getName().hasTransliterationMismatchForName()) {
            wrongFields.add(this.enrollmentService.isUpdateEnrollment() ? "Old name" : "Name");
        }
        if (this.demographics.getPersonalDetail().getName().hasTransliterationMismatchForNewName()) {
            wrongFields.add("Name");
        }
        if (this.demographics.getContact().getAddress().hasTransliterationMismatchForName()) {
            wrongFields.add("C/O");
        }
        if (this.references.getReferenceIntroducer().hasTransliterationMismatchForName()) {
            wrongFields.add("Introducer Name");
        }
        if (this.references.getReferenceRelative().hasTransliterationMismatchForName()) {
            wrongFields.add("Relation Name");
        }
        StringBuilder fields = new StringBuilder();
        if (!wrongFields.isEmpty()) {
            wrongFields.forEach(s -> fields.append((String)s).append(","));
            fields.deleteCharAt(fields.length() - 1);
        }
        return fields.toString();
    }

    public boolean isNRIEnrolment() {
        return this.demographics.getResidentialStatus().isNRI();
    }

    public boolean isTabEnabled(int tabId) {
        if (this.enrollmentService.isOnlineUpdate() && this.tabStates.get(tabId) == null) {
            return false;
        }
        return this.tabStates.get(tabId);
    }

    public Photograph getPhotograph() {
        return this.photograph;
    }

    public FingerPrint getFingerPrint() {
        return this.fingerPrint;
    }

    public Iris getIris() {
        return this.iris;
    }

    public void updateTabState(int tabId, boolean enabled) {
        this.tabStates.put(tabId, enabled);
    }

    public void setIsNRIEnrolment(boolean isNRIEnrolment) {
        this.demographics.getResidentialStatus().setNRI(isNRIEnrolment);
    }

    public void setIsUpdateEnrollment(boolean updateEnrollment) {
        this.isUpdateEnrollment = updateEnrollment;
    }

    public void setIsNameFieldEnable(boolean enable) {
        this.isNameFieldEnable = enable;
    }

    public void setIsAadharFieldEnable(boolean enable) {
        this.isAadharFieldEnable = enable;
    }

    public void setIsChildEnrolmentEnable(boolean enable) {
        this.isChildEnrolmentEnable = enable;
    }

    public void setIsUpdateBioMetricEnable(boolean enable) {
        this.isUpdateBioMetricEnable = enable;
    }

    public void setIsMandatoryBioMetricEnable(boolean enable) {
        this.isMandatoryBioMetricEnable = enable;
    }

    public void fireBiometricUpdateChangeListener() {
        this.biometricUpdateChangeListener.forEach(listener -> listener.accept(this.isBiometricUpdate() || this.isMandatoryBiometricUpdate()));
    }

    public void fireResidentChildEnrollment(Boolean isSelected) {
        this.childEnrollmentChangeListener.forEach(listener -> listener.accept(isSelected));
    }

    public void setEnrollmentLocale(Locale currentTLocale) {
        this.langCode = UidLocaleUtils.getLangCodeFrmLocaleStr((String)currentTLocale.toString());
    }

    public String getLangCode() {
        return this.langCode;
    }

    private void setUpdatedBit(boolean updated, int i) {
        StringBuilder updatedBit = new StringBuilder(updated ? "1" : "0");
        StringBuilder updatedBitValues = this.enrollmentService.getUpdatedBitValues();
        updatedBitValues = new StringBuilder(updatedBitValues.substring(0, i) + updatedBit + updatedBitValues.substring(i + 1));
        this.enrollmentService.setUpdatedBitValues(updatedBitValues);
    }

    public boolean isHofEnrollment() {
        return this.isHofEnrollment;
    }

    public String getHofUid() {
        return this.hofUid;
    }

    public void setHofUid(String hofUid) {
        this.hofUid = hofUid;
    }

    public boolean isDemoUpdate() {
        return this.isDemoUpdate;
    }

    public FieldsUpdateCount getFieldsUpdateCount() {
        return this.fieldsUpdateCount;
    }

    public String getsId() {
        return this.sId;
    }

    public String getRefId() {
        return this.refId;
    }

    public void setsId(String sId) {
        this.sId = sId;
    }

    public String getAcknowledgementSlip() {
        return this.acknowledgementSlip;
    }

    public void setAcknowledgementSlip(String acknowledgementSlip) {
        this.acknowledgementSlip = acknowledgementSlip;
    }

    public byte[] getAcknowledgementSlipBytes() {
        return this.acknowledgementSlipBytes;
    }

    public void setAcknowledgementSlipBytes(byte[] acknowledgementSlipBytes) {
        this.acknowledgementSlipBytes = acknowledgementSlipBytes;
    }

    public String getResidentUid() {
        return this.residentUid;
    }

    public void initUC(boolean newEnrollment, boolean isPacValid) {
        this.setOnlineUpdate(true);
        this.setIsUpdateEnrollment(!newEnrollment);
        this.setRDBasedUpdate(false);
        this.setSupervisorCaptureRequired(false);
        this.setPhotographCaptureEnabled(true);
        this.setBiometricUpdateAllowed(true);
        this.setAppointmentBasedFlow(true);
        this.setPACValidationRequired(isPacValid);
        this.setLanguageOnlyUpdate(false);
        this.setFindAadhaar(true);
        if (newEnrollment) {
            this.setUpdateType(UpdateType.UC_ENROLLMENT);
        } else {
            this.setUpdateType(UpdateType.UC_UPDATE);
        }
        if (newEnrollment) {
            this.setIsNameFieldEnable(true);
        } else {
            this.setIsNameFieldEnable(false);
            this.setIsAadharFieldEnable(false);
            this.setIsChildEnrolmentEnable(false);
            this.setIsUpdateBioMetricEnable(false);
            this.setIsMandatoryBioMetricEnable(false);
        }
        this.startTime = System.currentTimeMillis();
        this.docMan = new DocumentsManager(this.enrollmentService);
        if (!newEnrollment) {
            this.fieldsUpdateCount = new FieldsUpdateCount(this.enrollmentService);
        }
        this.demographics = new Demographics(this.enrollmentService);
        this.references = new References(this.enrollmentService, this.demographics);
        this.biometricsException = new BiometricsException(this.enrollmentService);
        this.photograph = new Photograph(this.enrollmentService, this.biometricsException);
        this.fingerPrint = new FingerPrint(this.enrollmentService, this.demographics, this.biometricsException);
        this.iris = new Iris(this.enrollmentService, this.demographics, this.biometricsException);
        this.confirmerDetails = new ConfirmerDetails(this.enrollmentService);
        this.appointment = new Appointment(this.enrollmentService);
    }

    public void setDemoUpdate(boolean demoUpdate) {
        this.isDemoUpdate = demoUpdate;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public boolean getIsPobRequired() {
        return this.isPobRequired;
    }

    public void setPobRequired(boolean pobRequired) {
        this.isPobRequired = pobRequired;
    }

    public boolean isNriHaveForeignAddress() {
        return this.nriHaveForeignAddress;
    }

    public void setNriHaveForeignAddress(boolean nriHaveForeignAddress) {
        this.nriHaveForeignAddress = nriHaveForeignAddress;
    }

    public Integer getNextScannedDocumentId() {
        this.latestScannedDocumentId = this.latestScannedDocumentId + 1;
        return this.latestScannedDocumentId;
    }

    public void setIsPobRequired(boolean isPobRequired) {
        this.isPobRequired = isPobRequired;
    }

    public void setRoiLabelList(DocumentType documentType, List<LabelDetail> roiLabelList) {
        if (this.roiLabelList == null) {
            this.roiLabelList = new HashMap<DocumentType, List<LabelDetail>>();
        }
        this.roiLabelList.put(documentType, roiLabelList);
    }

    public void resetRoiLabelList() {
        if (this.roiLabelList == null) {
            return;
        }
        this.roiLabelList.clear();
    }

    public List<LabelDetail> getRoiLabelList(DocumentType documentType) {
        if (this.roiLabelList == null) {
            return null;
        }
        return this.roiLabelList.get((Object)documentType);
    }

    public String getHofName() {
        return this.hofName;
    }

    public boolean isForeignResident() {
        return this.isForeignResident;
    }

    public void setHofName(String hofName) {
        this.hofName = hofName;
    }

    public void setForeignResident(boolean foreignResident) {
        this.isForeignResident = foreignResident;
    }

    public void setHofNameLocal(String hofNameLocal) {
        this.hofNameLocal = hofNameLocal;
    }

    public String getHofNameLocal() {
        return this.hofNameLocal;
    }

    public boolean isAadhaarActive() {
        return this.isAadhaarActive;
    }

    public void setAadhaarActive(boolean aadhaarActive) {
        this.isAadhaarActive = aadhaarActive;
    }

    public Appointment getAppointment() {
        return this.appointment;
    }

    public String getGrievanceId() {
        return this.grievanceId;
    }

    public void setGrievanceId(String grievanceId) {
        this.grievanceId = grievanceId;
    }

    public String getLinkedEid() {
        return this.linkedEid;
    }

    public void setLinkedEid(String linkedEid) {
        this.linkedEid = linkedEid;
    }

    public String getSupervisorAuthUrl() {
        return this.supervisorAuthUrl;
    }

    public void setSupervisorAuthUrl(String supervisorAuthUrl) {
        this.supervisorAuthUrl = supervisorAuthUrl;
    }

    public boolean isHofConsentGoingOn() {
        return this.isHofConsentGoingOn;
    }

    public void setHofConsentGoingOn(boolean hofConsentGoingOn) {
        this.isHofConsentGoingOn = hofConsentGoingOn;
    }
}

