/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.IEditDistance;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;

public abstract class EnrolmentModelBase<T>
extends ModelBase<T> {
    private static final int EDIT_DISTANCE_THRESHOLD = 50;
    private final List<Consumer<T>> updateChangeListeners = new ArrayList<Consumer<T>>();
    protected EnrollmentService enrollmentService;
    private boolean isUpdated;

    public EnrolmentModelBase(EnrollmentService enrollmentService) {
        super(enrollmentService.getResourceBundleContext());
        this.enrollmentService = enrollmentService;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    protected void setUpdated(boolean updated) {
        this.isUpdated = updated;
        this.setMandatory(updated);
    }

    protected void setUpdatedBit(boolean updated, int i) {
        StringBuilder updatedBit = new StringBuilder(updated ? "1" : "0");
        StringBuilder updatedBitValues = this.enrollmentService.getUpdatedBitValues();
        updatedBitValues = new StringBuilder(updatedBitValues.substring(0, i) + updatedBit + updatedBitValues.substring(i + 1));
        this.enrollmentService.setUpdatedBitValues(updatedBitValues);
    }

    public void addUpdateChangeListener(Consumer<T> delegate) {
        if (delegate == null) {
            return;
        }
        this.updateChangeListeners.add(delegate);
    }

    protected void fireUpdateChangeEvent(T updateValue) {
        this.updateChangeListeners.forEach(listener -> listener.accept(updateValue));
    }

    protected boolean isTransliterationDiffValid(String englishText, String localText) {
        int score;
        if (StringUtils.isBlank((String)englishText) || StringUtils.isBlank((String)localText)) {
            return false;
        }
        String locale = UidLocaleUtils.getLocaleFromLangCode((int)Integer.parseInt(this.enrollmentService.getEnrollmentLangCode())).toString();
        List editDistanceList = TransliterationManager.getInst().getEditDistance("en_in", locale);
        if (editDistanceList.isEmpty()) {
            return false;
        }
        englishText = this.stripDoubleSpaces(englishText);
        localText = this.stripDoubleSpaces(localText);
        if (StringUtils.countMatches((String)englishText, (String)" ") != StringUtils.countMatches((String)localText, (String)" ")) {
            return true;
        }
        try {
            score = ((IEditDistance)editDistanceList.get(0)).findSimilarity(englishText.toLowerCase(), "en_in", localText, locale, new TransliterationHints[]{TransliterationHints.NAME});
        }
        catch (Exception e) {
            return true;
        }
        return score < 50;
    }

    private String stripDoubleSpaces(String input) {
        return input.trim().replaceAll("\\s+", " ");
    }
}

