/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.oauthapi.json.countapi.CountLimit;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;

public class FieldUpdateCount
extends EnrolmentModelBase<FieldUpdateCount> {
    private boolean updateAllowed;
    private int updateLimit;
    private int updatesAvailed;
    private boolean hasToBeUpdated;

    public FieldUpdateCount(EnrollmentService enrollmentService) {
        super(enrollmentService);
    }

    public boolean updateAllowed() {
        return this.updateAllowed;
    }

    public int getUpdateLimit() {
        return this.updateLimit;
    }

    public int getUpdatesAvailed() {
        return this.updatesAvailed;
    }

    public boolean hasToBeUpdated() {
        return this.hasToBeUpdated;
    }

    public void updateField(boolean update) {
        this.hasToBeUpdated = update;
        this.fireChangeEvent(this);
    }

    public static FieldUpdateCount create(EnrollmentService enrollmentService, CountLimit countLimit) {
        FieldUpdateCount fieldUpdateCount = new FieldUpdateCount(enrollmentService);
        fieldUpdateCount.updateAllowed = countLimit.isUpdateAllowed();
        fieldUpdateCount.updatesAvailed = countLimit.getUpdatesAvailed();
        fieldUpdateCount.updateLimit = countLimit.getUpdateAttemptLimit();
        return fieldUpdateCount;
    }

    public static FieldUpdateCount create(EnrollmentService enrollmentService, UcDemographicServiceProto.DemographicState demographicState) {
        FieldUpdateCount fieldUpdateCount = new FieldUpdateCount(enrollmentService);
        fieldUpdateCount.updateAllowed = demographicState.getUpdateAllowed();
        fieldUpdateCount.updatesAvailed = demographicState.getUpdatedCount();
        fieldUpdateCount.updateLimit = demographicState.getUpdateAttemptLimit();
        return fieldUpdateCount;
    }

    public static FieldUpdateCount create(EnrollmentService enrollmentService) {
        FieldUpdateCount fieldUpdateCount = new FieldUpdateCount(enrollmentService);
        fieldUpdateCount.updateAllowed = true;
        fieldUpdateCount.updatesAvailed = 0;
        fieldUpdateCount.updateLimit = -1;
        return fieldUpdateCount;
    }
}

