/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.oauthapi.json.countapi.CountLimit;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.ec.service.enrollment.model.FieldUpdateCount;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsUpdateCount
extends EnrolmentModelBase<FieldsUpdateCount> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldUpdateCount.class);
    private final int LANGUAGE = 0;
    private final int NAME = 1;
    private final int GENDER = 2;
    private final int DOB = 3;
    private final int ADDRESS = 4;
    private final int MOBILE = 5;
    private final int EMAIL = 6;
    private final int BIO = 7;
    private final int ACTIVATION = 8;
    private final int POI = 9;
    private final int POA = 10;
    private final int POR = 11;
    private final int POB = 12;
    private final int POF = 13;
    private EnrollmentService enrollmentService;
    private FieldUpdateCount language;
    private FieldUpdateCount name;
    private FieldUpdateCount gender;
    private FieldUpdateCount dob;
    private FieldUpdateCount address;
    private FieldUpdateCount mobile;
    private FieldUpdateCount email;
    private FieldUpdateCount bio;
    private FieldUpdateCount activation;
    private FieldUpdateCount poi;
    private FieldUpdateCount poa;
    private FieldUpdateCount por;
    private FieldUpdateCount pob;
    private FieldUpdateCount pof;
    private List<FieldUpdateCount> updateCountList;

    public FieldsUpdateCount(EnrollmentService enrollmentService) {
        super(enrollmentService);
        this.enrollmentService = enrollmentService;
        this.updateCountList = Arrays.asList(this.language, this.name, this.gender, this.dob, this.address, this.mobile, this.email, this.bio, this.activation, this.poi, this.poa, this.por, this.pob, this.pof);
        this.setValid(false);
    }

    private FieldUpdateCount getOrCreateField(FieldUpdateCount fieldUpdateCount) {
        return Optional.ofNullable(fieldUpdateCount).orElseGet(() -> new FieldUpdateCount(this.enrollmentService));
    }

    public FieldUpdateCount getLanguage() {
        return this.getOrCreateField(this.language);
    }

    public FieldUpdateCount getBio() {
        return this.getOrCreateField(this.bio);
    }

    public FieldUpdateCount getActivationAadhaar() {
        return this.getOrCreateField(this.activation);
    }

    public FieldUpdateCount getName() {
        return this.getOrCreateField(this.name);
    }

    public FieldUpdateCount getGender() {
        return this.getOrCreateField(this.gender);
    }

    public FieldUpdateCount getDob() {
        return this.getOrCreateField(this.dob);
    }

    public FieldUpdateCount getAddress() {
        return this.getOrCreateField(this.address);
    }

    public FieldUpdateCount getMobile() {
        return this.getOrCreateField(this.mobile);
    }

    public FieldUpdateCount getEmail() {
        return this.getOrCreateField(this.email);
    }

    public FieldUpdateCount getPoi() {
        return this.poi;
    }

    public FieldUpdateCount getPoa() {
        return this.poa;
    }

    public FieldUpdateCount getPor() {
        return this.por;
    }

    public FieldUpdateCount getPob() {
        return this.pob;
    }

    public FieldUpdateCount getPof() {
        return this.pof;
    }

    public List<FieldUpdateCount> getUpdateCountList() {
        return this.updateCountList;
    }

    public void setLanguage(CountLimit language) {
        this.language = FieldUpdateCount.create(this.enrollmentService, language);
        this.language.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(0, this.language);
    }

    public void setName(CountLimit name) {
        this.name = FieldUpdateCount.create(this.enrollmentService, name);
        this.name.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(1, this.name);
    }

    public void setGender(CountLimit gender) {
        this.gender = FieldUpdateCount.create(this.enrollmentService, gender);
        this.gender.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(2, this.gender);
    }

    public void setDob(CountLimit dob) {
        this.dob = FieldUpdateCount.create(this.enrollmentService, dob);
        this.dob.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(3, this.dob);
    }

    public void setAddress(CountLimit address) {
        this.address = FieldUpdateCount.create(this.enrollmentService, address);
        this.address.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(4, this.address);
    }

    public void setMobile(CountLimit mobile) {
        this.mobile = FieldUpdateCount.create(this.enrollmentService, mobile);
        this.mobile.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(5, this.mobile);
    }

    public void setEmail(CountLimit email) {
        this.email = FieldUpdateCount.create(this.enrollmentService, email);
        this.email.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(6, this.email);
    }

    public void setLanguage(UcDemographicServiceProto.DemographicState language) {
        this.language = FieldUpdateCount.create(this.enrollmentService, language);
        this.language.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(0, this.language);
    }

    public void setName(UcDemographicServiceProto.DemographicState name) {
        this.name = FieldUpdateCount.create(this.enrollmentService, name);
        this.name.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(1, this.name);
    }

    public void setGender(UcDemographicServiceProto.DemographicState gender) {
        this.gender = FieldUpdateCount.create(this.enrollmentService, gender);
        this.gender.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(2, this.gender);
    }

    public void setDob(UcDemographicServiceProto.DemographicState dob) {
        this.dob = FieldUpdateCount.create(this.enrollmentService, dob);
        this.dob.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(3, this.dob);
    }

    public void setAddress(UcDemographicServiceProto.DemographicState address) {
        this.address = FieldUpdateCount.create(this.enrollmentService, address);
        this.address.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(4, this.address);
    }

    public void setMobile(UcDemographicServiceProto.DemographicState mobile) {
        this.mobile = FieldUpdateCount.create(this.enrollmentService, mobile);
        this.mobile.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(5, this.mobile);
    }

    public void setEmail(UcDemographicServiceProto.DemographicState email) {
        this.email = FieldUpdateCount.create(this.enrollmentService, email);
        this.email.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(6, this.email);
    }

    public void setBio() {
        this.bio = FieldUpdateCount.create(this.enrollmentService);
        this.bio.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(7, this.bio);
    }

    public void setActivationAadhaar() {
        this.activation = FieldUpdateCount.create(this.enrollmentService);
        this.activation.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(8, this.activation);
    }

    public void setPoi() {
        this.poi = FieldUpdateCount.create(this.enrollmentService);
        this.poi.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(9, this.poi);
    }

    public void setPoa() {
        this.poa = FieldUpdateCount.create(this.enrollmentService);
        this.poa.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(10, this.poa);
    }

    public void setPor() {
        this.por = FieldUpdateCount.create(this.enrollmentService);
        this.por.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(11, this.por);
    }

    public void setPob() {
        this.pob = FieldUpdateCount.create(this.enrollmentService);
        this.pob.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(12, this.pob);
    }

    public void setPof() {
        this.pof = FieldUpdateCount.create(this.enrollmentService);
        this.pof.addChangeListener(ignore -> this.residentUpdatePreferenceChanged());
        this.updateCountList.set(13, this.pof);
    }

    public boolean isDemoUpdate() {
        return this.name.hasToBeUpdated() || this.gender.hasToBeUpdated() || this.dob.hasToBeUpdated() || this.address.hasToBeUpdated() || this.mobile.hasToBeUpdated() || this.email.hasToBeUpdated();
    }

    public boolean isBioUpdate() {
        return this.bio.hasToBeUpdated();
    }

    private void residentUpdatePreferenceChanged() {
        boolean anyFieldToBeUpdated = this.updateCountList.stream().filter(Objects::nonNull).anyMatch(FieldUpdateCount::hasToBeUpdated);
        this.setValid(anyFieldToBeUpdated);
    }
}

