/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.enrollment.model;

import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.EnrolmentModelBase;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FingerPrint
extends EnrolmentModelBase<FingerPrint> {
    private final Biometrics leftSlap;
    private final Biometrics rightSlap;
    private final Biometrics bothThumbs;
    private final BiometricsException exception;
    private final List<Consumer<BiometricsException>> fingerprintBiometricExceptionChangeListeners = new ArrayList<Consumer<BiometricsException>>();

    FingerPrint(EnrollmentService enrollmentService, Demographics demographics, BiometricsException exception) {
        super(enrollmentService);
        this.exception = exception;
        AgeDob ageDob = demographics.getPersonalDetail().getAgeDob();
        boolean newEnrolment = !enrollmentService.isUpdateEnrollment();
        this.leftSlap = new Biometrics(enrollmentService, CaptureModality.LEFT_SLAP, this.getAvailableBodyPartsForLeftSlap(), this.getMissingBodyPartsForLeftSlap(), newEnrolment);
        this.rightSlap = new Biometrics(enrollmentService, CaptureModality.RIGHT_SLAP, this.getAvailableBodyPartsForRightSlap(), this.getMissingBodyPartsForRightSlap(), newEnrolment);
        this.bothThumbs = new Biometrics(enrollmentService, CaptureModality.THUMB_SLAP, this.getAvailableBodyPartsForThumbSlap(), this.getMissingBodyPartsForThumbSlap(), newEnrolment);
        this.leftSlap.addValidityChangeListener(this::reEvaluateFingerprintValidity);
        this.rightSlap.addValidityChangeListener(this::reEvaluateFingerprintValidity);
        this.bothThumbs.addValidityChangeListener(this::reEvaluateFingerprintValidity);
        this.leftSlap.addChangeListener(this::onBiometricChange);
        this.rightSlap.addChangeListener(this::onBiometricChange);
        this.bothThumbs.addChangeListener(this::onBiometricChange);
        this.exception.addChangeListener(this::onBiometricExceptionChange);
        ageDob.addChangeListener(this::reEvaluateFingerPrint);
        this.addEventListenersForUpdateEnrollment(enrollmentService.isUpdateEnrollment());
        this.setMandatory(newEnrolment && ageDob.isValid() && !ageDob.isChild());
        this.validate();
    }

    private void addEventListenersForUpdateEnrollment(boolean isUpdateEnrollment) {
        if (!isUpdateEnrollment) {
            return;
        }
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.enrollmentService.addResidentChildListeners(this::onResidentChildUpdateTypeChange);
    }

    public void addFingerprintBiometricExceptionChangeListener(Consumer<BiometricsException> delegate) {
        this.fingerprintBiometricExceptionChangeListeners.add(delegate);
    }

    private void fireFingerprintBiometricExceptionChange(BiometricsException biometricsException) {
        for (Consumer<BiometricsException> listener : this.fingerprintBiometricExceptionChangeListeners) {
            listener.accept(biometricsException);
        }
    }

    private void onBiometricUpdateTypeChange(Boolean biometricUpdate) {
        boolean childUpdate = this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild();
        this.setMandatory(!childUpdate && biometricUpdate != false);
    }

    private void onResidentChildUpdateTypeChange(Boolean childUpdate) {
        boolean biometricUpdate = this.enrollmentService.isBiometricUpdate();
        this.setMandatory(childUpdate == false && biometricUpdate);
    }

    private void onBiometricChange(Biometrics biometrics) {
        super.fireChangeEvent(this);
    }

    private void onBiometricExceptionChange(BiometricsException biometricException) {
        this.leftSlap.setAvailableBodyParts(this.getAvailableBodyPartsForLeftSlap());
        this.rightSlap.setAvailableBodyParts(this.getAvailableBodyPartsForRightSlap());
        this.bothThumbs.setAvailableBodyParts(this.getAvailableBodyPartsForThumbSlap());
        this.leftSlap.setMissingBodyParts(this.getMissingBodyPartsForLeftSlap());
        this.rightSlap.setMissingBodyParts(this.getMissingBodyPartsForRightSlap());
        this.bothThumbs.setMissingBodyParts(this.getMissingBodyPartsForThumbSlap());
        boolean leftSlapMandatory = true;
        boolean rightSlapMandatory = true;
        boolean bothThumbMandatory = true;
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        if (biometricsExceptionDetail.isBiometricExceptionApplied()) {
            if (biometricsExceptionDetail.isLeftSlapExceptionApplied()) {
                leftSlapMandatory = false;
            }
            if (biometricsExceptionDetail.isRightSlapExceptionApplied()) {
                rightSlapMandatory = false;
            }
            if (biometricsExceptionDetail.isBothThumbsExceptionApplied()) {
                bothThumbMandatory = false;
            }
        }
        this.getLeftSlap().setMandatory(leftSlapMandatory);
        this.getRightSlap().setMandatory(rightSlapMandatory);
        this.getBothThumbs().setMandatory(bothThumbMandatory);
        this.reset();
        this.fireFingerprintBiometricExceptionChange(biometricException);
    }

    public Biometrics getLeftSlap() {
        return this.leftSlap;
    }

    public Biometrics getRightSlap() {
        return this.rightSlap;
    }

    public Biometrics getBothThumbs() {
        return this.bothThumbs;
    }

    public void setMaxCaptureAttempt(int maxCaptureAttempt) {
        this.leftSlap.setMaxCaptureAttempts(maxCaptureAttempt);
        this.rightSlap.setMaxCaptureAttempts(maxCaptureAttempt);
        this.bothThumbs.setMaxCaptureAttempts(maxCaptureAttempt);
    }

    private void reEvaluateFingerprintValidity(boolean valid) {
        this.validate();
    }

    private void reEvaluateFingerPrint(AgeDob ageDob) {
        boolean mandatory;
        boolean isChild = ageDob.isChild();
        BiometricsExceptionDetail bioExceptionDetail = this.enrollmentService.getBiometricsException().getExceptionDetail();
        if (this.enrollmentService.isUniversalClientTrnx() && (bioExceptionDetail.isBothThumbsExceptionApplied() || bioExceptionDetail.isLeftSlapExceptionApplied() || bioExceptionDetail.isRightSlapExceptionApplied())) {
            return;
        }
        if (this.enrollmentService.isUpdateEnrollment()) {
            mandatory = !isChild && this.enrollmentService.isBiometricUpdate();
        } else {
            boolean bl = mandatory = !isChild;
        }
        if (this.isMandatory() != mandatory) {
            this.setMandatory(mandatory);
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        super.setMandatory(mandatory);
        this.leftSlap.setMandatory(mandatory);
        this.rightSlap.setMandatory(mandatory);
        this.bothThumbs.setMandatory(mandatory);
        this.reset();
    }

    public void reset() {
        this.leftSlap.clearAttempts();
        this.rightSlap.clearAttempts();
        this.bothThumbs.clearAttempts();
        this.validate();
    }

    private void validate() {
        if (this.isMandatory()) {
            this.setValid(this.leftSlap.isValid() && this.rightSlap.isValid() && this.bothThumbs.isValid());
        } else {
            this.setValid(true);
        }
    }

    private List<BodyPart> getBodyPartsForLeftSlap() {
        return new ArrayList<BodyPart>(){
            {
                this.add(BodyPart.POINTER_FINGER_LEFT);
                this.add(BodyPart.MIDDLE_FINGER_LEFT);
                this.add(BodyPart.RING_FINGER_LEFT);
                this.add(BodyPart.LITTLE_FINGER_LEFT);
            }
        };
    }

    private List<BodyPart> getBodyPartsForRightSlap() {
        return new ArrayList<BodyPart>(){
            {
                this.add(BodyPart.POINTER_FINGER_RIGHT);
                this.add(BodyPart.MIDDLE_FINGER_RIGHT);
                this.add(BodyPart.RING_FINGER_RIGHT);
                this.add(BodyPart.LITTLE_FINGER_RIGHT);
            }
        };
    }

    private List<BodyPart> getBodyPartsForThumbSlap() {
        return new ArrayList<BodyPart>(){
            {
                this.add(BodyPart.THUMB_LEFT);
                this.add(BodyPart.THUMB_RIGHT);
            }
        };
    }

    private List<BodyPart> getAvailableBodyPartsForLeftSlap() {
        List<BodyPart> bodyPartsForLeftSlap = this.getBodyPartsForLeftSlap();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableFingers());
        return availableBodyPartList.stream().filter(bodyPartsForLeftSlap::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForLeftSlap() {
        List<BodyPart> bodyPartsForLeftSlap = this.getBodyPartsForLeftSlap();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingFingers());
        return missingBodyPartList.stream().filter(bodyPartsForLeftSlap::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getAvailableBodyPartsForRightSlap() {
        List<BodyPart> bodyPartsForRightSlap = this.getBodyPartsForRightSlap();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableFingers());
        return availableBodyPartList.stream().filter(bodyPartsForRightSlap::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForRightSlap() {
        List<BodyPart> bodyPartsForRightSlap = this.getBodyPartsForRightSlap();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingFingers());
        return missingBodyPartList.stream().filter(bodyPartsForRightSlap::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getAvailableBodyPartsForThumbSlap() {
        List<BodyPart> bodyPartsForThumbSlap = this.getBodyPartsForThumbSlap();
        List<BodyPart> availableBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getAvailableFingers());
        return availableBodyPartList.stream().filter(bodyPartsForThumbSlap::contains).collect(Collectors.toList());
    }

    private List<BodyPart> getMissingBodyPartsForThumbSlap() {
        List<BodyPart> bodyPartsForThumbSlap = this.getBodyPartsForThumbSlap();
        List<BodyPart> missingBodyPartList = this.mapBioPosToBodyParts(this.exception.getExceptionDetail().getMissingFingers());
        return missingBodyPartList.stream().filter(bodyPartsForThumbSlap::contains).collect(Collectors.toList());
    }

    private List<BodyPart> mapBioPosToBodyParts(List<BiometricPosition> biometricPositionList) {
        ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
        for (BiometricPosition bioPos : biometricPositionList) {
            switch (bioPos) {
                case LEFT_INDEX: {
                    bodyParts.add(BodyPart.POINTER_FINGER_LEFT);
                    break;
                }
                case LEFT_MIDDLE: {
                    bodyParts.add(BodyPart.MIDDLE_FINGER_LEFT);
                    break;
                }
                case LEFT_RING: {
                    bodyParts.add(BodyPart.RING_FINGER_LEFT);
                    break;
                }
                case LEFT_LITTLE: {
                    bodyParts.add(BodyPart.LITTLE_FINGER_LEFT);
                    break;
                }
                case RIGHT_INDEX: {
                    bodyParts.add(BodyPart.POINTER_FINGER_RIGHT);
                    break;
                }
                case RIGHT_MIDDLE: {
                    bodyParts.add(BodyPart.MIDDLE_FINGER_RIGHT);
                    break;
                }
                case RIGHT_RING: {
                    bodyParts.add(BodyPart.RING_FINGER_RIGHT);
                    break;
                }
                case RIGHT_LITTLE: {
                    bodyParts.add(BodyPart.LITTLE_FINGER_RIGHT);
                    break;
                }
                case LEFT_THUMB: {
                    bodyParts.add(BodyPart.THUMB_LEFT);
                    break;
                }
                case RIGHT_THUMB: {
                    bodyParts.add(BodyPart.THUMB_RIGHT);
                }
            }
        }
        return bodyParts;
    }
}

